/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnGetStatusSummary;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnMarkReplaced;
import org.tmatesoft.svn.core.wc2.SvnRemoteSetProperty;
import org.tmatesoft.svn.core.wc2.SvnResolve;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnSetLock;
import org.tmatesoft.svn.core.wc2.SvnSetProperty;
import org.tmatesoft.svn.core.wc2.SvnStatusSummary;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUnlock;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNWCClient
extends SVNBasicClient {
    private ISVNAddParameters addParameters;
    private ISVNCommitHandler commitHandler;
    private boolean revertMissingDirectories;
    public static ISVNAddParameters DEFAULT_ADD_PARAMETERS = new ISVNAddParameters(){

        public ISVNAddParameters.Action onInconsistentEOLs(File file) {
            return ISVNAddParameters.REPORT_ERROR;
        }
    };

    public SVNWCClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.setCommitHandler(null);
        this.setAddParameters(null);
    }

    public SVNWCClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
        this.setCommitHandler(null);
        this.setAddParameters(null);
    }

    public void setAddParameters(ISVNAddParameters addParameters) {
        if (addParameters == null) {
            addParameters = DEFAULT_ADD_PARAMETERS;
        }
        this.addParameters = addParameters;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        if (handler == null) {
            handler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = handler;
    }

    public void setRevertMissingDirectories(boolean revertMissing) {
        this.revertMissingDirectories = revertMissing;
    }

    public boolean isRevertMissingDirectories() {
        return this.revertMissingDirectories;
    }

    public void doGetFileContents(File path, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        SvnCat cat = this.getOperationsFactory().createCat();
        if (revision == SVNRevision.UNDEFINED) {
            revision = pegRevision != null && pegRevision.isValid() ? pegRevision : SVNRevision.BASE;
        }
        cat.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        cat.setRevision(revision);
        cat.setExpandKeywords(expandKeywords);
        cat.setOutput(dst);
        cat.run();
    }

    public void doGetFileContents(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean expandKeywords, OutputStream dst) throws SVNException {
        SvnCat cat = this.getOperationsFactory().createCat();
        if (revision == SVNRevision.UNDEFINED) {
            revision = pegRevision != null && pegRevision.isValid() ? pegRevision : SVNRevision.HEAD;
        }
        cat.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        cat.setRevision(revision);
        cat.setExpandKeywords(expandKeywords);
        cat.setOutput(dst);
        cat.run();
    }

    public void doCleanup(File path) throws SVNException {
        SvnCleanup cleanup = this.getOperationsFactory().createCleanup();
        cleanup.setSingleTarget(SvnTarget.fromFile(path));
        cleanup.run();
    }

    public void doCleanup(File path, boolean deleteWCProperties) throws SVNException {
        SvnCleanup cleanup = this.getOperationsFactory().createCleanup();
        cleanup.setSingleTarget(SvnTarget.fromFile(path));
        cleanup.setDeleteWCProperties(deleteWCProperties);
        cleanup.run();
    }

    public void doSetProperty(File path, String propName, SVNPropertyValue propValue, boolean skipChecks, SVNDepth depth, ISVNPropertyHandler handler, Collection<String> changeLists) throws SVNException {
        SvnSetProperty ps = this.getOperationsFactory().createSetProperty();
        ps.setPropertyName(propName);
        ps.setPropertyValue(propValue);
        ps.setForce(skipChecks);
        ps.setDepth(depth);
        ps.setSingleTarget(SvnTarget.fromFile(path));
        ps.setApplicalbeChangelists(changeLists);
        ps.setReceiver(SvnCodec.propertyReceiver(handler));
        ps.run();
    }

    public void doSetProperty(File path, ISVNPropertyValueProvider propertyValueProvider, boolean skipChecks, SVNDepth depth, ISVNPropertyHandler handler, Collection<String> changeLists) throws SVNException {
        SvnSetProperty ps = this.getOperationsFactory().createSetProperty();
        ps.setPropertyValueProvider(SvnCodec.propertyValueProvider(propertyValueProvider));
        ps.setForce(skipChecks);
        ps.setDepth(depth);
        ps.setSingleTarget(SvnTarget.fromFile(path));
        ps.setApplicalbeChangelists(changeLists);
        ps.setReceiver(SvnCodec.propertyReceiver(handler));
        ps.run();
    }

    public SVNCommitInfo doSetProperty(SVNURL url, String propName, SVNPropertyValue propValue, SVNRevision baseRevision, String commitMessage, SVNProperties revisionProperties, boolean skipChecks, final ISVNPropertyHandler handler) throws SVNException {
        SvnRemoteSetProperty ps = this.getOperationsFactory().createRemoteSetProperty();
        ps.setSingleTarget(SvnTarget.fromURL(url));
        ps.setPropertyName(propName);
        ps.setPropertyValue(propValue);
        ps.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        ps.setRevisionProperties(revisionProperties);
        ps.setCommitMessage(commitMessage);
        ps.setPropertyReceiver(new ISvnObjectReceiver<SVNPropertyData>(){

            @Override
            public void receive(SvnTarget target, SVNPropertyData object) throws SVNException {
                if (handler != null) {
                    handler.handleProperty(target.getURL(), object);
                }
            }
        });
        return (SVNCommitInfo)ps.run();
    }

    public void doSetRevisionProperty(File path, SVNRevision revision, String propName, SVNPropertyValue propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        SvnSetProperty ps = this.getOperationsFactory().createSetProperty();
        ps.setRevisionProperty(true);
        ps.setSingleTarget(SvnTarget.fromFile(path));
        ps.setRevision(revision);
        ps.setPropertyName(propName);
        ps.setPropertyValue(propValue);
        ps.setForce(force);
        SVNPropertyData propertyData = (SVNPropertyData)ps.run();
        if (handler != null) {
            handler.handleProperty(revision != null ? revision.getNumber() : -1L, propertyData);
        }
    }

    public void doSetRevisionProperty(SVNURL url, SVNRevision revision, String propName, SVNPropertyValue propValue, boolean force, ISVNPropertyHandler handler) throws SVNException {
        SvnSetProperty ps = this.getOperationsFactory().createSetProperty();
        ps.setRevisionProperty(true);
        ps.setSingleTarget(SvnTarget.fromURL(url));
        ps.setRevision(revision);
        ps.setPropertyName(propName);
        ps.setPropertyValue(propValue);
        ps.setForce(force);
        SVNPropertyData propertyData = (SVNPropertyData)ps.run();
        if (handler != null) {
            handler.handleProperty(revision != null ? revision.getNumber() : -1L, propertyData);
        }
    }

    public SVNPropertyData doGetProperty(File path, final String propName, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        SvnGetProperties getProperties = this.getOperationsFactory().createGetProperties();
        getProperties.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        getProperties.setRevision(revision);
        getProperties.setDepth(SVNDepth.EMPTY);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                if (propName != null && object.containsName(propName)) {
                    data[0] = new SVNPropertyData(propName, object.getSVNPropertyValue(propName), SVNWCClient.this.getOptions());
                }
            }
        });
        getProperties.run();
        return data[0];
    }

    public SVNPropertyData doGetProperty(SVNURL url, final String propName, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        SvnGetProperties getProperties = this.getOperationsFactory().createGetProperties();
        getProperties.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        getProperties.setRevision(revision);
        getProperties.setDepth(SVNDepth.EMPTY);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                if (propName != null && object.containsName(propName)) {
                    data[0] = new SVNPropertyData(propName, object.getSVNPropertyValue(propName), SVNWCClient.this.getOptions());
                }
            }
        });
        getProperties.run();
        return data[0];
    }

    public void doGetProperty(File path, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        this.doGetProperty(path, propName, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), handler, null);
    }

    public void doGetProperty(File path, final String propName, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, final ISVNPropertyHandler handler, Collection<String> changeLists) throws SVNException {
        SvnGetProperties getProperties = this.getOperationsFactory().createGetProperties();
        getProperties.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        getProperties.setRevision(revision);
        getProperties.setDepth(depth);
        getProperties.setApplicalbeChangelists(changeLists);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                if (propName != null && object.containsName(propName)) {
                    SVNPropertyData propertyData = new SVNPropertyData(propName, object.getSVNPropertyValue(propName), SVNWCClient.this.getOptions());
                    if (target.isFile()) {
                        handler.handleProperty(target.getFile(), propertyData);
                    } else {
                        handler.handleProperty(target.getURL(), propertyData);
                    }
                } else if (propName == null) {
                    for (String propertyName : object.nameSet()) {
                        String name = propertyName.toString();
                        SVNPropertyData propertyData = new SVNPropertyData(name, object.getSVNPropertyValue(name), SVNWCClient.this.getOptions());
                        if (target.isFile()) {
                            handler.handleProperty(target.getFile(), propertyData);
                            continue;
                        }
                        handler.handleProperty(target.getURL(), propertyData);
                    }
                }
            }
        });
        getProperties.run();
    }

    public void doGetProperty(SVNURL url, String propName, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        this.doGetProperty(url, propName, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), handler);
    }

    public void doGetProperty(SVNURL url, final String propName, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, final ISVNPropertyHandler handler) throws SVNException {
        SvnGetProperties getProperties = this.getOperationsFactory().createGetProperties();
        getProperties.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        getProperties.setRevision(revision);
        getProperties.setDepth(depth);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                if (propName != null && object.containsName(propName)) {
                    SVNPropertyData propertyData = new SVNPropertyData(propName, object.getSVNPropertyValue(propName), SVNWCClient.this.getOptions());
                    handler.handleProperty(target.getURL(), propertyData);
                } else if (propName == null) {
                    for (String propertyName : object.nameSet()) {
                        String name = propertyName.toString();
                        SVNPropertyData propertyData = new SVNPropertyData(name, object.getSVNPropertyValue(name), SVNWCClient.this.getOptions());
                        handler.handleProperty(target.getURL(), propertyData);
                    }
                }
            }
        });
        getProperties.run();
    }

    public long doGetRevisionProperty(File path, final String propName, SVNRevision revision, final ISVNPropertyHandler handler) throws SVNException {
        final SvnGetProperties getProperties = this.getOperationsFactory().createGetProperties();
        getProperties.setSingleTarget(SvnTarget.fromFile(path));
        getProperties.setRevisionProperties(true);
        getProperties.setRevision(revision);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                if (propName == null) {
                    for (String name : object.nameSet()) {
                        SVNPropertyData pdata = new SVNPropertyData(name, object.getSVNPropertyValue(name), SVNWCClient.this.getOptions());
                        if (handler == null) continue;
                        handler.handleProperty(getProperties.getRevisionNumber(), pdata);
                    }
                } else if (propName != null && object.containsName(propName)) {
                    SVNPropertyData pdata = new SVNPropertyData(propName, object.getSVNPropertyValue(propName), SVNWCClient.this.getOptions());
                    if (handler != null) {
                        handler.handleProperty(getProperties.getRevisionNumber(), pdata);
                    }
                }
            }
        });
        getProperties.run();
        return getProperties.getRevisionNumber();
    }

    public long doGetRevisionProperty(SVNURL url, final String propName, SVNRevision revision, final ISVNPropertyHandler handler) throws SVNException {
        final SvnGetProperties getProperties = this.getOperationsFactory().createGetProperties();
        getProperties.setSingleTarget(SvnTarget.fromURL(url));
        getProperties.setRevisionProperties(true);
        getProperties.setRevision(revision);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                if (propName == null) {
                    for (String name : object.nameSet()) {
                        SVNPropertyData pdata = new SVNPropertyData(name, object.getSVNPropertyValue(name), SVNWCClient.this.getOptions());
                        if (handler == null) continue;
                        handler.handleProperty(getProperties.getRevisionNumber(), pdata);
                    }
                } else if (propName != null && object.containsName(propName)) {
                    SVNPropertyData pdata = new SVNPropertyData(propName, object.getSVNPropertyValue(propName), SVNWCClient.this.getOptions());
                    if (handler != null) {
                        handler.handleProperty(getProperties.getRevisionNumber(), pdata);
                    }
                }
            }
        });
        getProperties.run();
        return getProperties.getRevisionNumber();
    }

    public void doDelete(File path, boolean force, boolean dryRun) throws SVNException {
        this.doDelete(path, force, true, dryRun);
    }

    public void doDelete(File path, boolean force, boolean deleteFiles, boolean dryRun) throws SVNException {
        SvnScheduleForRemoval remove = this.getOperationsFactory().createScheduleForRemoval();
        remove.setSingleTarget(SvnTarget.fromFile(path));
        remove.setForce(force);
        remove.setDeleteFiles(deleteFiles);
        remove.setDryRun(dryRun);
        remove.run();
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive) throws SVNException {
        File[] paths = new File[]{path};
        this.doAdd(paths, force, mkdir, climbUnversionedParents, SVNDepth.fromRecurse(recursive), false, false, climbUnversionedParents);
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, boolean recursive, boolean includeIgnored) throws SVNException {
        File[] paths = new File[]{path};
        this.doAdd(paths, force, mkdir, climbUnversionedParents, SVNDepth.fromRecurse(recursive), false, includeIgnored, climbUnversionedParents);
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, SVNDepth depth, boolean includeIgnored, boolean makeParents) throws SVNException {
        File[] paths = new File[]{path};
        this.doAdd(paths, force, mkdir, climbUnversionedParents, depth, false, includeIgnored, makeParents);
    }

    public void doAdd(File[] paths, boolean force, boolean mkdir, boolean climbUnversionedParents, SVNDepth depth, boolean depthIsSticky, boolean includeIgnored, boolean makeParents) throws SVNException {
        SvnScheduleForAddition add = this.getOperationsFactory().createScheduleForAddition();
        for (int i = 0; i < paths.length; ++i) {
            add.addTarget(SvnTarget.fromFile(paths[i]));
        }
        add.setMkDir(mkdir);
        add.setForce(force);
        add.setDepth(depth);
        add.setDepth(depth);
        add.setIncludeIgnored(includeIgnored);
        add.setAddParents(makeParents);
        add.setAddParameters(SvnCodec.addParameters(this.addParameters));
        add.run();
    }

    public void doAdd(File path, boolean force, boolean mkdir, boolean climbUnversionedParents, SVNDepth depth, boolean depthIsSticky, boolean includeIgnored, boolean makeParents) throws SVNException {
        File[] paths = new File[]{path};
        this.doAdd(paths, force, mkdir, climbUnversionedParents, depth, depthIsSticky, includeIgnored, makeParents);
    }

    public void doMarkReplaced(File path) throws SVNException {
        SvnMarkReplaced mr = this.getOperationsFactory().createMarkReplaced();
        mr.setSingleTarget(SvnTarget.fromFile(path));
        mr.run();
    }

    public void doRevert(File path, boolean recursive) throws SVNException {
        this.doRevert(new File[]{path}, SVNDepth.fromRecurse(recursive), null);
    }

    public void doRevert(File[] paths, boolean recursive) throws SVNException {
        this.doRevert(paths, SVNDepth.fromRecurse(recursive), null);
    }

    public void doRevert(File[] paths, SVNDepth depth, Collection<String> changeLists) throws SVNException {
        SvnRevert revert = this.getOperationsFactory().createRevert();
        for (int i = 0; i < paths.length; ++i) {
            revert.addTarget(SvnTarget.fromFile(paths[i]));
        }
        revert.setDepth(depth);
        revert.setApplicalbeChangelists(changeLists);
        revert.setRevertMissingDirectories(this.revertMissingDirectories);
        revert.run();
    }

    public void doResolve(File path, boolean recursive) throws SVNException {
        this.doResolve(path, SVNDepth.fromRecurse(recursive), SVNConflictChoice.MINE_FULL);
    }

    public void doResolve(File path, SVNDepth depth, SVNConflictChoice conflictChoice) throws SVNException {
        SvnResolve resolve = this.getOperationsFactory().createResolve();
        resolve.addTarget(SvnTarget.fromFile(path));
        resolve.setDepth(depth);
        resolve.setConflictChoice(conflictChoice);
        resolve.run();
    }

    public void doResolve(File path, SVNDepth depth, boolean resolveContents, boolean resolveProperties, SVNConflictChoice conflictChoice) throws SVNException {
        SvnResolve resolve = this.getOperationsFactory().createResolve();
        resolve.addTarget(SvnTarget.fromFile(path));
        resolve.setDepth(depth);
        resolve.setResolveContents(resolveContents);
        resolve.setResolveProperties(resolveProperties);
        resolve.setConflictChoice(conflictChoice);
        resolve.run();
    }

    public void doResolve(File path, SVNDepth depth, boolean resolveContents, boolean resolveProperties, boolean resolveTree, SVNConflictChoice conflictChoice) throws SVNException {
        SvnResolve resolve = this.getOperationsFactory().createResolve();
        resolve.addTarget(SvnTarget.fromFile(path));
        resolve.setDepth(depth);
        resolve.setResolveContents(resolveContents);
        resolve.setResolveProperties(resolveProperties);
        resolve.setResolveTree(resolveTree);
        resolve.setConflictChoice(conflictChoice);
        resolve.run();
    }

    public void doLock(File[] paths, boolean stealLock, String lockMessage) throws SVNException {
        SvnSetLock lock = this.getOperationsFactory().createSetLock();
        for (int i = 0; i < paths.length; ++i) {
            lock.addTarget(SvnTarget.fromFile(paths[i]));
        }
        lock.setStealLock(stealLock);
        lock.setLockMessage(lockMessage);
        lock.run();
    }

    public void doLock(SVNURL[] urls, boolean stealLock, String lockMessage) throws SVNException {
        SvnSetLock lock = this.getOperationsFactory().createSetLock();
        for (int i = 0; i < urls.length; ++i) {
            lock.addTarget(SvnTarget.fromURL(urls[i]));
        }
        lock.setStealLock(stealLock);
        lock.setLockMessage(lockMessage);
        lock.run();
    }

    public void doUnlock(File[] paths, boolean breakLock) throws SVNException {
        SvnUnlock unlock = this.getOperationsFactory().createUnlock();
        for (int i = 0; i < paths.length; ++i) {
            unlock.addTarget(SvnTarget.fromFile(paths[i]));
        }
        unlock.setBreakLock(breakLock);
        unlock.run();
    }

    public void doUnlock(SVNURL[] urls, boolean breakLock) throws SVNException {
        SvnUnlock unlock = this.getOperationsFactory().createUnlock();
        for (int i = 0; i < urls.length; ++i) {
            unlock.addTarget(SvnTarget.fromURL(urls[i]));
        }
        unlock.setBreakLock(breakLock);
        unlock.run();
    }

    public void doInfo(File path, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, SVNRevision.UNDEFINED, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), null, handler);
    }

    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(path, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), null, handler);
    }

    public void doInfo(File path, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, Collection<String> changeLists, final ISVNInfoHandler handler) throws SVNException {
        SvnGetInfo getInfo = this.getOperationsFactory().createGetInfo();
        getInfo.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        getInfo.setRevision(revision);
        getInfo.setDepth(depth);
        getInfo.setApplicalbeChangelists(changeLists);
        getInfo.setReceiver(new ISvnObjectReceiver<SvnInfo>(){

            @Override
            public void receive(SvnTarget target, SvnInfo object) throws SVNException {
                handler.handleInfo(SvnCodec.info(object));
            }
        });
        getInfo.run();
    }

    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNInfoHandler handler) throws SVNException {
        this.doInfo(url, pegRevision, revision, SVNDepth.getInfinityOrEmptyDepth(recursive), handler);
    }

    public void doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, final ISVNInfoHandler handler) throws SVNException {
        SvnGetInfo getInfo = this.getOperationsFactory().createGetInfo();
        getInfo.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        getInfo.setRevision(revision);
        getInfo.setDepth(depth);
        getInfo.setReceiver(new ISvnObjectReceiver<SvnInfo>(){

            @Override
            public void receive(SvnTarget target, SvnInfo object) throws SVNException {
                handler.handleInfo(SvnCodec.info(object));
            }
        });
        getInfo.run();
    }

    public String doGetWorkingCopyID(File path, String trailURL) throws SVNException {
        return this.doGetWorkingCopyID(path, trailURL, false);
    }

    public String doGetWorkingCopyID(File path, String trailURL, boolean committed) throws SVNException {
        SvnStatusSummary summary;
        SvnGetStatusSummary gs = this.getOperationsFactory().createGetStatusSummary();
        gs.addTarget(SvnTarget.fromFile(path));
        gs.setTrailUrl(trailURL);
        gs.setCommitted(committed);
        try {
            summary = (SvnStatusSummary)gs.run();
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                SVNFileType ft = SVNFileType.getType(path);
                if (ft == SVNFileType.SYMLINK) {
                    return "Unversioned symlink";
                }
                if (ft == SVNFileType.DIRECTORY) {
                    return "Unversioned directory";
                }
                if (ft == SVNFileType.FILE) {
                    return "Unversioned file";
                }
                return "'" + path.getPath() + "' doesn't exist";
            }
            throw e;
        }
        if (summary.getMinRevision() < 0L) {
            return "Uncommitted local addition, copy or move";
        }
        StringBuffer result = new StringBuffer();
        result.append(summary.getMinRevision());
        if (summary.getMaxRevision() != summary.getMinRevision()) {
            result.append(":");
            result.append(summary.getMaxRevision());
        }
        result.append(summary.isModified() ? "M" : "");
        result.append(summary.isSwitched() ? "S" : "");
        result.append(summary.isSparseCheckout() ? "P" : "");
        return result.toString();
    }

    public SVNInfo doInfo(File path, SVNRevision revision) throws SVNException {
        final SVNInfo[] info = new SVNInfo[1];
        SvnGetInfo getInfo = this.getOperationsFactory().createGetInfo();
        getInfo.setSingleTarget(SvnTarget.fromFile(path));
        getInfo.setRevision(revision);
        getInfo.setDepth(SVNDepth.EMPTY);
        getInfo.setReceiver(new ISvnObjectReceiver<SvnInfo>(){

            @Override
            public void receive(SvnTarget target, SvnInfo object) throws SVNException {
                if (info[0] == null) {
                    info[0] = SvnCodec.info(object);
                }
            }
        });
        getInfo.run();
        return info[0];
    }

    public SVNInfo doInfo(SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        final SVNInfo[] info = new SVNInfo[1];
        SvnGetInfo getInfo = this.getOperationsFactory().createGetInfo();
        getInfo.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        getInfo.setRevision(revision);
        getInfo.setDepth(SVNDepth.EMPTY);
        getInfo.setReceiver(new ISvnObjectReceiver<SvnInfo>(){

            @Override
            public void receive(SvnTarget target, SvnInfo object) throws SVNException {
                if (info[0] == null) {
                    info[0] = SvnCodec.info(object);
                }
            }
        });
        getInfo.run();
        return info[0];
    }

    public void doCleanupWCProperties(File directory) throws SVNException {
        SVNWCClient16 oldClient = new SVNWCClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
        oldClient.doCleanupWCProperties(directory);
    }

    public void doSetWCFormat(File directory, int format) throws SVNException {
        if (format == 12) {
            SvnUpgrade upgrade = this.getOperationsFactory().createUpgrade();
            upgrade.setSingleTarget(SvnTarget.fromFile(directory));
            upgrade.setDepth(SVNDepth.INFINITY);
            upgrade.run();
        } else {
            SVNWCClient16 oldClient = new SVNWCClient16(this.getOperationsFactory().getAuthenticationManager(), this.getOptions());
            oldClient.doSetWCFormat(directory, format);
        }
    }

    public void doSetProperty(File path, String propName, SVNPropertyValue propValue, boolean force, boolean recursive, ISVNPropertyHandler handler) throws SVNException {
        this.doSetProperty(path, propName, propValue, force, SVNDepth.fromRecurse(recursive), handler, null);
    }
}

