/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffStatusReceiver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgDiff
extends SvnNgOperationRunner<Void, SvnDiff> {
    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }

    @Override
    public boolean isApplicable(SvnDiff operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (operation.getSource() != null) {
            return !operation.getSource().isFile() || wcGeneration == SvnWcGeneration.V17;
        }
        if (operation.getFirstSource().isFile() && wcGeneration != SvnWcGeneration.V17) {
            return false;
        }
        return !operation.getSecondSource().isFile() || wcGeneration == SvnWcGeneration.V17;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        if (this.isPeggedDiff()) {
            SvnTarget target = ((SvnDiff)this.getOperation()).getSource();
            SVNRevision revision1 = ((SvnDiff)this.getOperation()).getStartRevision();
            SVNRevision revision2 = ((SvnDiff)this.getOperation()).getEndRevision();
            SVNRevision pegRevision = target.getPegRevision();
            this.doDiff(target, revision1, pegRevision, target, revision2);
        } else {
            SvnTarget target1 = ((SvnDiff)this.getOperation()).getFirstSource();
            SvnTarget target2 = ((SvnDiff)this.getOperation()).getSecondSource();
            SVNRevision revision1 = target1.getPegRevision();
            SVNRevision revision2 = target2.getPegRevision();
            SVNRevision pegRevision = SVNRevision.UNDEFINED;
            this.doDiff(target1, revision1, pegRevision, target2, revision2);
        }
        return null;
    }

    private void doDiff(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2) throws SVNException {
        boolean isRepos2;
        boolean isRepos1;
        boolean isLocalRev2;
        if (revision1 == SVNRevision.UNDEFINED || revision2 == SVNRevision.UNDEFINED) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean isLocalRev1 = revision1 == SVNRevision.BASE || revision1 == SVNRevision.WORKING;
        boolean bl = isLocalRev2 = revision2 == SVNRevision.BASE || revision2 == SVNRevision.WORKING;
        if (pegRevision != SVNRevision.UNDEFINED) {
            if (isLocalRev1 && isLocalRev2) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            isRepos1 = !isLocalRev1;
            isRepos2 = !isLocalRev2;
        } else {
            isRepos1 = !isLocalRev1 || target1.isURL();
            boolean bl2 = isRepos2 = !isLocalRev2 || target2.isURL();
        }
        if (isRepos1) {
            if (isRepos2) {
                this.doDiffReposRepos(target1, revision1, pegRevision, target2, revision2);
            } else {
                this.doDiffReposWC(target1, revision1, pegRevision, target2, revision2, false);
            }
        } else if (isRepos2) {
            this.doDiffReposWC(target2, revision2, pegRevision, target1, revision1, true);
        } else {
            this.doDiffWCWC(target1, revision1, target2, revision2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposRepos(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2) throws SVNException {
        block36: {
            SVNURL url1 = this.getRepositoryAccess().getTargetURL(target1);
            SVNURL url2 = this.getRepositoryAccess().getTargetURL(target2);
            File basePath = null;
            if (target1.isFile()) {
                basePath = target1.getFile();
            } else if (target2.isFile()) {
                basePath = target2.getFile();
            }
            SVNRepository repository = this.getRepositoryAccess().createRepository(url2, null, true);
            if (pegRevision != SVNRevision.UNDEFINED) {
                block35: {
                    try {
                        Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(repository, target2, pegRevision, revision1, revision2);
                        url1 = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                        url2 = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.endUrl);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block35;
                        throw e;
                    }
                }
                repository.setLocation(url2, false);
            }
            long revisionNumber2 = this.getRepositoryAccess().getRevisionNumber(repository, target2, revision2, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            SVNNodeKind kind2 = repository.checkPath("", revisionNumber2);
            repository.setLocation(url1, false);
            final long revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(repository, target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            SVNNodeKind kind1 = repository.checkPath("", revisionNumber1);
            if (kind1 == SVNNodeKind.NONE && kind2 == SVNNodeKind.NONE) {
                SVNErrorMessage err;
                if (url1.equals(url2)) {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url1, new Long(revisionNumber1), new Long(revisionNumber2));
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff targets ''{0}'' and ''{1}'' were not found in the repository at revisions ''{2}'' and ''{3}''", url1, url2, new Long(revisionNumber1), new Long(revisionNumber2));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else if (kind1 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(url1, revisionNumber2, revisionNumber1, repository);
            } else if (kind2 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(url2, revisionNumber1, revisionNumber2, repository);
            }
            SVNURL anchor1 = url1;
            SVNURL anchor2 = url2;
            String targetString1 = "";
            String targetString2 = "";
            SVNURL repositoryRoot = null;
            SVNNodeKind oldKind1 = kind1;
            SVNNodeKind oldKind2 = kind2;
            if (kind1 == SVNNodeKind.NONE || kind2 == SVNNodeKind.NONE) {
                SVNNodeKind kind;
                SVNRevision revision;
                repositoryRoot = repository.getRepositoryRoot(true);
                SVNURL newAnchor = kind1 == SVNNodeKind.NONE ? anchor1 : anchor2;
                SVNRevision sVNRevision = revision = kind1 == SVNNodeKind.NONE ? revision1 : revision2;
                do {
                    if (!newAnchor.equals(repositoryRoot)) {
                        newAnchor = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(newAnchor.toString()));
                        if (basePath != null) {
                            basePath = SVNFileUtil.getParentFile(basePath);
                        }
                    }
                    repository.setLocation(newAnchor, false);
                } while ((kind = repository.checkPath("", revision.getNumber())) != SVNNodeKind.DIR);
                anchor1 = anchor2 = newAnchor;
                targetString1 = SVNPathUtil.getRelativePath(newAnchor.toDecodedString(), url1.toDecodedString());
                targetString2 = SVNPathUtil.getRelativePath(newAnchor.toDecodedString(), url2.toDecodedString());
                assert (target1 != null && target2 != null);
                if (kind1 == SVNNodeKind.NONE) {
                    kind1 = SVNNodeKind.DIR;
                } else {
                    kind2 = SVNNodeKind.DIR;
                }
            } else if (kind1 == SVNNodeKind.FILE || kind2 == SVNNodeKind.FILE) {
                targetString1 = SVNPathUtil.tail(url1.toDecodedString());
                targetString2 = SVNPathUtil.tail(url2.toDecodedString());
                anchor1 = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url1.toString()));
                anchor2 = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url2.toString()));
                if (basePath != null) {
                    basePath = SVNFileUtil.getParentFile(basePath);
                }
                repository.setLocation(anchor1, false);
            }
            ISvnDiffGenerator generator = this.getDiffGenerator();
            generator.setOriginalTargets(SvnTarget.fromURL(url1), SvnTarget.fromURL(url2));
            generator.setAnchors(SvnTarget.fromURL(anchor1), SvnTarget.fromURL(anchor2));
            if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
                if (repositoryRoot == null) {
                    repositoryRoot = repository.getRepositoryRoot(true);
                }
                generator.setRepositoryRoot(SvnTarget.fromURL(repositoryRoot));
            }
            SvnDiffCallback callback = this.createDiffCallback(generator, false, revisionNumber1, revisionNumber2);
            SVNRepository extraRepository = this.getRepositoryAccess().createRepository(anchor1, null, false);
            try {
                SvnNgRemoteDiffEditor remoteDiffEditor;
                boolean pureRemoteDiff = basePath == null;
                ISVNEditor editor = remoteDiffEditor = SvnNgRemoteDiffEditor.createEditor(this.getWcContext(), pureRemoteDiff ? new File("") : basePath, ((SvnDiff)this.getOperation()).getDepth(), extraRepository, revisionNumber1, true, false, pureRemoteDiff, callback, this);
                editor = SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog());
                if (oldKind1 != SVNNodeKind.NONE && oldKind2 != SVNNodeKind.NONE) {
                    ISVNReporterBaton reporter = new ISVNReporterBaton(){

                        public void report(ISVNReporter reporter) throws SVNException {
                            reporter.setPath("", null, revisionNumber1, SVNDepth.INFINITY, false);
                            reporter.finishReport();
                        }
                    };
                    try {
                        repository.diff(url2, revisionNumber2, revisionNumber1, targetString1, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, reporter, editor);
                        break block36;
                    }
                    finally {
                        remoteDiffEditor.cleanup();
                    }
                }
                repository.setLocation(anchor1, false);
                ISVNReporterBaton reporter = new ISVNReporterBaton(){

                    public void report(ISVNReporter reporter) throws SVNException {
                        reporter.setPath("", null, revisionNumber1, SVNDepth.INFINITY, false);
                        reporter.finishReport();
                    }
                };
                try {
                    repository.diff(anchor2.appendPath(SVNPathUtil.head(targetString2), false), revisionNumber2, revisionNumber1, SVNPathUtil.head(targetString2), ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, reporter, editor);
                }
                finally {
                    remoteDiffEditor.cleanup();
                }
            }
            finally {
                extraRepository.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposWC(SvnTarget target1, SVNRevision revision1, SVNRevision pegRevision, SvnTarget target2, SVNRevision revision2, boolean reverse) throws SVNException {
        SvnDiffEditor svnDiffEditor;
        assert (!target2.isURL());
        SVNURL url1 = this.getRepositoryAccess().getTargetURL(target1);
        String target = this.getWcContext().getActualTarget(target2.getFile());
        File anchor = target == null || target.length() == 0 ? target2.getFile() : SVNFileUtil.getParentFile(target2.getFile());
        SVNURL anchorUrl = this.getWcContext().getNodeUrl(anchor);
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", (Object)anchor);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ISvnDiffGenerator generator = this.getDiffGenerator();
        if (pegRevision != SVNRevision.UNDEFINED) {
            url1 = (SVNURL)this.getRepositoryAccess().getLocations(null, target1, pegRevision, revision1, SVNRevision.UNDEFINED).get(SvnRepositoryAccess.LocationsInfo.startUrl);
            if (!reverse) {
                generator.setOriginalTargets(SvnTarget.fromURL(url1), SvnTarget.fromURL(anchorUrl.appendPath(target, false)));
                generator.setAnchors(SvnTarget.fromURL(url1), SvnTarget.fromURL(anchorUrl.appendPath(target, false)));
            } else {
                generator.setOriginalTargets(SvnTarget.fromURL(anchorUrl.appendPath(target, false)), SvnTarget.fromURL(url1));
                generator.setAnchors(SvnTarget.fromURL(anchorUrl.appendPath(target, false)), SvnTarget.fromURL(url1));
            }
        } else if (!reverse) {
            generator.setOriginalTargets(target1, target2);
            generator.setAnchors(target1, target2);
        } else {
            generator.setOriginalTargets(target2, target1);
            generator.setAnchors(target2, target1);
        }
        SVNRepository repository2 = this.getRepositoryAccess().createRepository(anchorUrl, null, true);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            File wcRoot = this.getWcContext().getDb().getWCRoot(anchor);
            generator.setRepositoryRoot(SvnTarget.fromFile(wcRoot));
        }
        boolean serverSupportsDepth = repository2.hasCapability(SVNCapability.DEPTH);
        long revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(repository2, url1.equals(target1.getURL()) ? null : target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SvnDiffCallback callback = this.createDiffCallback(generator, reverse, revisionNumber1, -1L);
        SVNReporter17 reporter = new SVNReporter17(target2.getFile(), this.getWcContext(), false, !serverSupportsDepth, ((SvnDiff)this.getOperation()).getDepth(), false, false, true, false, SVNDebugLog.getDefaultLog());
        boolean revisionIsBase = this.isRevisionBase(revision2);
        ISVNUpdateEditor updateEditor = svnDiffEditor = new SvnDiffEditor(anchor, target, callback, ((SvnDiff)this.getOperation()).getDepth(), this.getWcContext(), reverse, revisionIsBase, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), this);
        if (!serverSupportsDepth && ((SvnDiff)this.getOperation()).getDepth() == SVNDepth.UNKNOWN) {
            updateEditor = new SVNAmbientDepthFilterEditor17(updateEditor, this.getWcContext(), anchor, target, revisionIsBase);
        }
        ISVNEditor editor = SVNCancellableEditor.newInstance(updateEditor, this, SVNDebugLog.getDefaultLog());
        try {
            repository2.diff(url1, revisionNumber1, revisionNumber1, target, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), this.getDiffDepth(((SvnDiff)this.getOperation()).getDepth()), true, (ISVNReporterBaton)reporter, editor);
        }
        finally {
            svnDiffEditor.cleanup();
        }
    }

    private void doDiffWCWC(SvnTarget target1, SVNRevision revision1, SvnTarget target2, SVNRevision revision2) throws SVNException {
        long revisionNumber1;
        assert (!target1.isURL());
        assert (!target2.isURL());
        if (!target1.getFile().equals(target2.getFile()) || revision1 != SVNRevision.BASE || revision2 != SVNRevision.WORKING) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Only diffs between a path's text-base and its working files are supported at this time");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        try {
            revisionNumber1 = this.getRepositoryAccess().getRevisionNumber(null, target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_BAD_REVISION) {
                revisionNumber1 = 0L;
            }
            throw e;
        }
        ISvnDiffGenerator generator = this.getDiffGenerator();
        generator.setOriginalTargets(target1, target2);
        generator.setAnchors(target1, target2);
        if (((SvnDiff)this.getOperation()).isUseGitDiffFormat()) {
            generator.setRepositoryRoot(SvnTarget.fromFile(this.getWcContext().getDb().getWCRoot(target1.getFile())));
        }
        SvnDiffCallback callback = this.createDiffCallback(generator, false, revisionNumber1, -1L);
        this.doDiffWC(target1.getFile(), callback);
    }

    private void doDiffWC(File localAbspath, ISvnDiffCallback callback) throws SVNException {
        boolean getAll = ((SvnDiff)this.getOperation()).isShowCopiesAsAdds() || ((SvnDiff)this.getOperation()).isUseGitDiffFormat();
        boolean diffIgnored = false;
        SvnDiffStatusReceiver statusHandler = new SvnDiffStatusReceiver(this.getWcContext(), localAbspath, this.getWcContext().getDb(), callback, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).isShowCopiesAsAdds(), ((SvnDiff)this.getOperation()).isUseGitDiffFormat(), ((SvnDiff)this.getOperation()).getApplicableChangelists());
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(localAbspath, this.getWcContext(), ((SvnDiff)this.getOperation()).getOptions(), true, getAll, ((SvnDiff)this.getOperation()).getDepth(), statusHandler);
        statusEditor.walkStatus(localAbspath, ((SvnDiff)this.getOperation()).getDepth(), getAll, true, false, ((SvnDiff)this.getOperation()).getApplicableChangelists());
    }

    private void checkDiffTargetExists(SVNURL url, long revision, long otherRevision, SVNRepository repository) throws SVNException {
        repository.setLocation(url, false);
        SVNNodeKind kind = repository.checkPath("", revision);
        if (kind == SVNNodeKind.NONE) {
            if (revision == otherRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revision ''{1}''", url, new Long(revision));
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url, new Long(revision), new Long(otherRevision));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    private boolean isPeggedDiff() {
        return ((SvnDiff)this.getOperation()).getSource() != null;
    }

    private boolean isRevisionBase(SVNRevision revision2) {
        return revision2 == SVNRevision.BASE;
    }

    private SVNDepth getDiffDepth(SVNDepth depth) {
        return depth != SVNDepth.INFINITY ? depth : SVNDepth.UNKNOWN;
    }

    private SvnDiffCallback createDiffCallback(ISvnDiffGenerator generator, boolean reverse, long revisionNumber1, long revisionNumber2) {
        return new SvnDiffCallback(generator, reverse ? revisionNumber2 : revisionNumber1, reverse ? revisionNumber1 : revisionNumber2, ((SvnDiff)this.getOperation()).getOutput());
    }

    private ISvnDiffGenerator getDiffGenerator() {
        ISvnDiffGenerator diffGenerator = ((SvnDiff)this.getOperation()).getDiffGenerator();
        if (diffGenerator == null) {
            diffGenerator = new SvnDiffGenerator();
        }
        diffGenerator.setUseGitFormat(((SvnDiff)this.getOperation()).isUseGitDiffFormat());
        if (((SvnDiff)this.getOperation()).getRelativeToDirectory() != null) {
            if (diffGenerator instanceof SvnDiffGenerator) {
                ((SvnDiffGenerator)diffGenerator).setRelativeToTarget(SvnTarget.fromFile(((SvnDiff)this.getOperation()).getRelativeToDirectory()));
            } else {
                diffGenerator.setBaseTarget(SvnTarget.fromFile(((SvnDiff)this.getOperation()).getRelativeToDirectory()));
            }
        }
        return diffGenerator;
    }
}

