/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgCommitUtil {
    public static SvnCommitPacket harvestCopyCommitables(SVNWCContext context, File path, SVNURL dst, SvnCommitPacket packet, ISvnUrlKindCallback urlKindCallback, ISvnCommitParameters commitParameters, Map<File, String> externalsStorage) throws SVNException {
        SVNWCContext.SVNWCNodeReposInfo reposInfo = context.getNodeReposInfo(path);
        File commitRelPath = new File(SVNURLUtil.getRelativeURL(reposInfo.reposRootUrl, dst, false));
        SvnNgCommitUtil.harvestCommittables(context, path, packet, null, reposInfo.reposRootUrl, commitRelPath, true, SVNDepth.INFINITY, false, null, false, false, urlKindCallback, commitParameters, externalsStorage, context.getEventHandler());
        return packet;
    }

    public static SvnCommitPacket harvestCommittables(SVNWCContext context, SvnCommitPacket packet, Map<SVNURL, String> lockTokens, File baseDirPath, Collection<String> targets, SVNDepth depth, boolean justLocked, Collection<String> changelists, ISvnUrlKindCallback urlKindCallback, ISvnCommitParameters commitParameters, Map<File, String> externalsStorage) throws SVNException {
        HashMap<File, File> danglers = new HashMap<File, File>();
        for (String target : targets) {
            File targetPath = SVNFileUtil.createFilePath(baseDirPath, target);
            SVNNodeKind kind = context.readKind(targetPath, false);
            if (kind == SVNNodeKind.NONE) {
                SVNErrorMessage err;
                SVNTreeConflictDescription tc = context.getTreeConflict(targetPath);
                if (tc != null) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)targetPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control", (Object)targetPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            SVNWCContext.SVNWCNodeReposInfo reposInfo = context.getNodeReposInfo(targetPath);
            SVNURL repositoryRootUrl = reposInfo.reposRootUrl;
            boolean added = context.isNodeAdded(targetPath);
            if (added) {
                File parentPath = SVNFileUtil.getParentFile(targetPath);
                try {
                    boolean parentIsAdded = context.isNodeAdded(parentPath);
                    if (parentIsAdded) {
                        Structure<StructureFields.NodeOriginInfo> origin = context.getNodeOrigin(parentPath, false, StructureFields.NodeOriginInfo.copyRootAbsPath, StructureFields.NodeOriginInfo.isCopy);
                        if (origin.is(StructureFields.NodeOriginInfo.isCopy)) {
                            parentPath = (File)origin.get(StructureFields.NodeOriginInfo.copyRootAbsPath);
                        }
                        origin.release();
                        danglers.put(parentPath, targetPath);
                    }
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "''{0}'' is scheduled for addition within unversioned parent", (Object)targetPath);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    throw e;
                }
            }
            SvnNgCommitUtil.bailOnTreeConflictedAncestor(context, targetPath);
            SvnNgCommitUtil.harvestCommittables(context, targetPath, packet, lockTokens, repositoryRootUrl, null, false, depth, justLocked, changelists, false, false, urlKindCallback, commitParameters, externalsStorage, context.getEventHandler());
        }
        for (SVNURL root : packet.getRepositoryRoots()) {
            SvnNgCommitUtil.handleDescendants(context, packet, root, new ArrayList<SvnCommitItem>(packet.getItems(root)), urlKindCallback, context.getEventHandler());
        }
        for (File danglingParent : danglers.keySet()) {
            if (packet.hasItem(danglingParent)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not known to exist in the repository and is not part of the commit, yet its child ''{1}'' is part of the commit", danglingParent.getAbsolutePath(), ((File)danglers.get(danglingParent)).getAbsolutePath());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return packet;
    }

    private static void handleDescendants(SVNWCContext context, SvnCommitPacket packet, SVNURL rootUrl, Collection<SvnCommitItem> items, ISvnUrlKindCallback urlKindCallback, ISVNEventHandler eventHandler) throws SVNException {
        for (SvnCommitItem item : items) {
            if (!item.hasFlag(1) || item.getCopyFromUrl() == null) continue;
            if (eventHandler != null) {
                eventHandler.checkCancelled();
            }
            Collection<File> notPresent = SvnWcDbReader.getNotPresentDescendants((SVNWCDb)context.getDb(), item.getPath());
            for (File absent : notPresent) {
                boolean itemFound = false;
                File localAbsPath = SVNFileUtil.createFilePath(item.getPath(), absent);
                for (SvnCommitItem i : items) {
                    if (!i.getPath().equals(localAbsPath)) continue;
                    itemFound = true;
                    break;
                }
                if (itemFound) continue;
                SVNURL url = SVNWCUtils.join(item.getCopyFromUrl(), absent);
                SVNNodeKind kind = SVNNodeKind.UNKNOWN;
                if (urlKindCallback != null && (kind = urlKindCallback.getUrlKind(url, item.getCopyFromRevision())) == SVNNodeKind.NONE) continue;
                packet.addItem(localAbsPath, rootUrl, kind, SVNWCUtils.join(item.getUrl(), absent), -1L, null, -1L, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void harvestCommittables(SVNWCContext context, File localAbsPath, SvnCommitPacket committables, Map<SVNURL, String> lockTokens, SVNURL repositoryRootUrl, File commitRelPath, boolean copyModeRoot, SVNDepth depth, boolean justLocked, Collection<String> changelists, boolean skipFiles, boolean skipDirs, ISvnUrlKindCallback urlKindCallback, ISvnCommitParameters commitParameters, Map<File, String> externalsStorage, ISVNEventHandler eventHandler) throws SVNException {
        String externalsProperty;
        SVNProperties properties;
        SvnCommitItem item;
        boolean copyMode;
        if (committables.hasItem(localAbsPath)) {
            return;
        }
        boolean bl = copyMode = commitRelPath != null;
        if (eventHandler != null) {
            eventHandler.checkCancelled();
        }
        Structure<NodeCommitStatus> commitStatus = SvnNgCommitUtil.getNodeCommitStatus(context, localAbsPath);
        if (skipFiles && commitStatus.get(NodeCommitStatus.kind) == SVNNodeKind.FILE || commitStatus.is(NodeCommitStatus.excluded)) {
            commitStatus.release();
            return;
        }
        if (commitStatus.get(NodeCommitStatus.reposRelPath) == null && commitRelPath != null) {
            commitStatus.set(NodeCommitStatus.reposRelPath, commitRelPath);
        }
        SVNWCContext.CheckSpecialInfo checkSpecial = SVNWCContext.checkSpecialPath(localAbsPath);
        SVNNodeKind workingKind = checkSpecial.kind;
        boolean isSpecial = checkSpecial.isSpecial;
        if (workingKind != SVNNodeKind.FILE && workingKind != SVNNodeKind.DIR && workingKind != SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean matchesChangelists = context.isChangelistMatch(localAbsPath, changelists);
        if (workingKind != SVNNodeKind.DIR && workingKind != SVNNodeKind.NONE && !matchesChangelists) {
            commitStatus.release();
            return;
        }
        if ((!commitStatus.is(NodeCommitStatus.symlink) && isSpecial || SVNFileUtil.symlinksSupported() && commitStatus.is(NodeCommitStatus.symlink) && !isSpecial) && workingKind != SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Entry ''{0}'' has unexpectedly changed special status", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (copyMode && commitStatus.is(NodeCommitStatus.updateRoot) && commitStatus.get(NodeCommitStatus.kind) == SVNNodeKind.FILE && copyMode) {
            commitStatus.release();
            return;
        }
        if (commitStatus.is(NodeCommitStatus.conflicted) && matchesChangelists) {
            SVNWCContext.ConflictInfo ci = context.getConflicted(localAbsPath, true, true, true);
            if (ci.propConflicted || ci.textConflicted || ci.treeConflicted) {
                if (eventHandler != null) {
                    // empty if block
                }
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)localAbsPath);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        }
        if (commitStatus.is(NodeCommitStatus.deleted) && !commitStatus.is(NodeCommitStatus.isOpRoot)) {
            commitStatus.release();
            return;
        }
        if (commitStatus.get(NodeCommitStatus.reposRelPath) == null) {
            File reposRelPath = context.getNodeReposRelPath(localAbsPath);
            commitStatus.set(NodeCommitStatus.reposRelPath, reposRelPath);
        }
        int stateFlags = 0;
        if (commitStatus.is(NodeCommitStatus.deleted) || commitStatus.is(NodeCommitStatus.isReplaceRoot)) {
            stateFlags |= 2;
        } else if (commitStatus.is(NodeCommitStatus.notPresent)) {
            if (!copyMode) {
                commitStatus.release();
                return;
            }
            if (urlKindCallback != null) {
                Structure<StructureFields.NodeOriginInfo> originInfo = context.getNodeOrigin(SVNFileUtil.getParentFile(localAbsPath), false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath);
                File reposRelPath = SVNFileUtil.createFilePath((File)originInfo.get(StructureFields.NodeOriginInfo.reposRelpath), SVNFileUtil.getFileName(localAbsPath));
                SVNURL url = SVNWCUtils.join(repositoryRootUrl, reposRelPath);
                long revision = originInfo.lng(StructureFields.NodeOriginInfo.revision);
                originInfo.release();
                if (urlKindCallback.getUrlKind(url, revision) == SVNNodeKind.NONE) {
                    commitStatus.release();
                    return;
                }
            }
            stateFlags |= 2;
        }
        File copyFromPath = null;
        long copyFromRevision = -1L;
        if (commitStatus.is(NodeCommitStatus.added) && commitStatus.is(NodeCommitStatus.isOpRoot)) {
            stateFlags |= 1;
            if (commitStatus.get(NodeCommitStatus.originalReposRelPath) != null) {
                stateFlags |= 0x10;
                copyFromPath = (File)commitStatus.get(NodeCommitStatus.originalReposRelPath);
                copyFromRevision = commitStatus.lng(NodeCommitStatus.originalRevision);
            }
        }
        if (copyMode && (!commitStatus.is(NodeCommitStatus.added) || copyModeRoot) && (stateFlags & 2) == 0) {
            long dirRevision = 0L;
            if (!copyModeRoot) {
                dirRevision = context.getNodeBaseRev(SVNFileUtil.getParentFile(localAbsPath));
            }
            if (copyModeRoot || dirRevision != commitStatus.lng(NodeCommitStatus.revision)) {
                stateFlags |= 1;
                Structure<StructureFields.NodeOriginInfo> originInfo = context.getNodeOrigin(localAbsPath, false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath);
                copyFromPath = (File)originInfo.get(StructureFields.NodeOriginInfo.reposRelpath);
                copyFromRevision = originInfo.lng(StructureFields.NodeOriginInfo.revision);
                originInfo.release();
                if (copyFromPath != null) {
                    stateFlags |= 0x10;
                }
            }
        }
        boolean textModified = false;
        if ((stateFlags & 1) != 0) {
            if (workingKind == SVNNodeKind.NONE) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' is scheduled for addition, but is missing", (Object)localAbsPath);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            if (commitStatus.get(NodeCommitStatus.kind) == SVNNodeKind.FILE) {
                textModified = (stateFlags & 0x10) != 0 ? context.isTextModified(localAbsPath, false) : true;
            }
        } else if ((stateFlags & 2) == 0 && commitStatus.get(NodeCommitStatus.kind) == SVNNodeKind.FILE) {
            textModified = context.isTextModified(localAbsPath, false);
        }
        boolean propsModified = commitStatus.is(NodeCommitStatus.propsMod);
        if (textModified) {
            stateFlags |= 4;
        }
        if (propsModified) {
            stateFlags |= 8;
        }
        if (commitStatus.get(NodeCommitStatus.lockToken) != null && lockTokens != null && (stateFlags != 0 || justLocked)) {
            stateFlags |= 0x20;
        }
        if ((stateFlags & 0xFFFFFFC7) == 0 && matchesChangelists && workingKind == SVNNodeKind.NONE && commitParameters != null) {
            ISvnCommitParameters.Action action = ISvnCommitParameters.Action.SKIP;
            SVNNodeKind nodeKind = (SVNNodeKind)commitStatus.get(NodeCommitStatus.kind);
            if (nodeKind == SVNNodeKind.DIR) {
                action = commitParameters.onMissingDirectory(localAbsPath);
            } else if (nodeKind == SVNNodeKind.FILE) {
                action = commitParameters.onMissingFile(localAbsPath);
            }
            if (action == ISvnCommitParameters.Action.DELETE) {
                stateFlags |= 2;
                SvnNgRemove.delete(context, localAbsPath, false, false, null);
            } else if (action == ISvnCommitParameters.Action.ERROR) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy {1} ''{0}'' is missing", localAbsPath, nodeKind == SVNNodeKind.DIR ? "directory" : "file");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (stateFlags != 0 && matchesChangelists && (item = committables.addItem(localAbsPath, (SVNNodeKind)commitStatus.get(NodeCommitStatus.kind), repositoryRootUrl, SVNFileUtil.getFilePath(copyMode ? commitRelPath : (File)commitStatus.get(NodeCommitStatus.reposRelPath)), copyMode ? -1L : commitStatus.lng(NodeCommitStatus.revision), SVNFileUtil.getFilePath(copyFromPath), copyFromRevision, stateFlags)).hasFlag(32) && lockTokens != null) {
            lockTokens.put(item.getUrl(), (String)commitStatus.get(NodeCommitStatus.lockToken));
        }
        if (matchesChangelists && externalsStorage != null && (properties = context.getActualProps(localAbsPath)) != null && (externalsProperty = properties.getStringValue("svn:externals")) != null) {
            externalsStorage.put(localAbsPath, externalsProperty);
        }
        if (lockTokens != null && (stateFlags & 2) != 0) {
            SvnNgCommitUtil.collectLocks(context, localAbsPath, lockTokens);
        }
        try {
            if (commitStatus.get(NodeCommitStatus.kind) != SVNNodeKind.DIR || depth.compareTo(SVNDepth.EMPTY) <= 0) {
                return;
            }
            SvnNgCommitUtil.bailOnTreeConflictedChildren(context, localAbsPath, (SVNNodeKind)commitStatus.get(NodeCommitStatus.kind), depth, changelists);
        }
        finally {
            commitStatus.release();
        }
        if ((stateFlags & 2) == 0 || (stateFlags & 1) != 0) {
            SVNDepth depthBelowHere = depth;
            if (depth.compareTo(SVNDepth.INFINITY) < 0) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            List<File> children = context.getChildrenOfWorkingNode(localAbsPath, copyMode);
            for (File child : children) {
                String name = SVNFileUtil.getFileName(child);
                File childCommitRelPath = null;
                if (commitRelPath != null) {
                    childCommitRelPath = SVNFileUtil.createFilePath(commitRelPath, name);
                }
                SvnNgCommitUtil.harvestCommittables(context, child, committables, lockTokens, repositoryRootUrl, childCommitRelPath, false, depthBelowHere, justLocked, changelists, depth.compareTo(SVNDepth.FILES) < 0, depth.compareTo(SVNDepth.IMMEDIATES) < 0, urlKindCallback, commitParameters, externalsStorage, eventHandler);
            }
        }
    }

    private static Structure<NodeCommitStatus> getNodeCommitStatus(SVNWCContext context, File localAbsPath) throws SVNException {
        Object result = Structure.obtain(NodeCommitStatus.class);
        Structure<StructureFields.NodeInfo> nodeInfo = context.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.originalRevision, StructureFields.NodeInfo.originalReposRelpath, StructureFields.NodeInfo.lock, StructureFields.NodeInfo.changelist, StructureFields.NodeInfo.conflicted, StructureFields.NodeInfo.opRoot, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod, StructureFields.NodeInfo.haveBase, StructureFields.NodeInfo.haveMoreWork);
        if (nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File) {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.kind, SVNNodeKind.FILE);
        } else if (nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir) {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.kind, SVNNodeKind.DIR);
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.kind, SVNNodeKind.UNKNOWN);
        }
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.reposRelPath, nodeInfo.get(StructureFields.NodeInfo.reposRelPath));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.revision, nodeInfo.lng(StructureFields.NodeInfo.revision));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.originalReposRelPath, nodeInfo.get(StructureFields.NodeInfo.originalReposRelpath));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.originalRevision, nodeInfo.lng(StructureFields.NodeInfo.originalRevision));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.changelist, nodeInfo.get(StructureFields.NodeInfo.changelist));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.propsMod, nodeInfo.is(StructureFields.NodeInfo.propsMod));
        ISVNWCDb.SVNWCDbStatus nodeStatus = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.added, nodeStatus == ISVNWCDb.SVNWCDbStatus.Added);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.deleted, nodeStatus == ISVNWCDb.SVNWCDbStatus.Deleted);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.notPresent, nodeStatus == ISVNWCDb.SVNWCDbStatus.NotPresent);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.excluded, nodeStatus == ISVNWCDb.SVNWCDbStatus.Excluded);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.isOpRoot, nodeInfo.is(StructureFields.NodeInfo.opRoot));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.conflicted, nodeInfo.is(StructureFields.NodeInfo.conflicted));
        if (nodeStatus == ISVNWCDb.SVNWCDbStatus.Added && nodeInfo.is(StructureFields.NodeInfo.opRoot) && (nodeInfo.is(StructureFields.NodeInfo.haveBase) || nodeInfo.is(StructureFields.NodeInfo.haveMoreWork))) {
            Structure<SvnWcDbReader.ReplaceInfo> replaceInfo = SvnWcDbReader.readNodeReplaceInfo((SVNWCDb)context.getDb(), localAbsPath, SvnWcDbReader.ReplaceInfo.replaceRoot);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.isReplaceRoot, replaceInfo.is(SvnWcDbReader.ReplaceInfo.replaceRoot));
            replaceInfo.release();
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.isReplaceRoot, false);
        }
        if (nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File && (nodeInfo.is(StructureFields.NodeInfo.hadProps) || nodeInfo.is(StructureFields.NodeInfo.propsMod))) {
            SVNProperties properties = context.getDb().readProperties(localAbsPath);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.symlink, properties.getStringValue("svn:special") != null);
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.symlink, false);
        }
        if (nodeInfo.is(StructureFields.NodeInfo.haveBase) && (nodeInfo.lng(StructureFields.NodeInfo.revision) < 0L || nodeStatus == ISVNWCDb.SVNWCDbStatus.Normal)) {
            ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.revision, baseInfo.revision);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.updateRoot, baseInfo.updateRoot);
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.updateRoot, false);
        }
        ISVNWCDb.SVNWCDbLock lock = (ISVNWCDb.SVNWCDbLock)nodeInfo.get(StructureFields.NodeInfo.lock);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.lockToken, lock != null ? lock.token : null);
        nodeInfo.release();
        return result;
    }

    private static void bailOnTreeConflictedChildren(SVNWCContext context, File localAbsPath, SVNNodeKind kind, SVNDepth depth, Collection<String> changelistsSet) throws SVNException {
        if (depth == SVNDepth.EMPTY || kind != SVNNodeKind.DIR) {
            return;
        }
        Map<String, SVNTreeConflictDescription> conflicts = context.getDb().opReadAllTreeConflicts(localAbsPath);
        if (conflicts == null || conflicts.isEmpty()) {
            return;
        }
        for (SVNTreeConflictDescription conflict : conflicts.values()) {
            if (conflict.getNodeKind() == SVNNodeKind.DIR && depth == SVNDepth.FILES || !context.isChangelistMatch(localAbsPath, changelistsSet)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)conflict.getPath());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private static void collectLocks(final SVNWCContext context, File path, final Map<SVNURL, String> lockTokens) throws SVNException {
        SVNWCContext.ISVNWCNodeHandler nodeHandler = new SVNWCContext.ISVNWCNodeHandler(){

            public void nodeFound(File localAbspath, ISVNWCDb.SVNWCDbKind kind) throws SVNException {
                ISVNWCDb.SVNWCDbLock nodeLock = context.getNodeLock(localAbspath);
                if (nodeLock == null || nodeLock.token == null) {
                    return;
                }
                SVNURL url = context.getNodeUrl(localAbspath);
                if (url != null) {
                    lockTokens.put(url, nodeLock.token);
                }
            }
        };
        context.nodeWalkChildren(path, nodeHandler, false, SVNDepth.INFINITY, null);
    }

    private static void bailOnTreeConflictedAncestor(SVNWCContext context, File firstAbspath) throws SVNException {
        boolean wcRoot;
        File localAbspath = firstAbspath;
        while (!(wcRoot = context.checkWCRoot((File)localAbspath, (boolean)false).wcRoot)) {
            File parentAbspath = SVNFileUtil.getFileDir(localAbspath);
            boolean treeConflicted = context.getConflicted((File)parentAbspath, (boolean)false, (boolean)false, (boolean)true).treeConflicted;
            if (treeConflicted) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in tree-conflict", (Object)localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
                return;
            }
            localAbspath = parentAbspath;
        }
    }

    public static SVNURL translateCommitables(Collection<SvnCommitItem> items, Map<String, SvnCommitItem> decodedPaths) throws SVNException {
        HashMap<SVNURL, SvnCommitItem> itemsMap = new HashMap<SVNURL, SvnCommitItem>();
        for (SvnCommitItem item : items) {
            if (itemsMap.containsKey(item.getUrl())) {
                SvnCommitItem oldItem = (SvnCommitItem)itemsMap.get(item.getUrl());
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_DUPLICATE_COMMIT_URL, "Cannot commit both ''{0}'' and ''{1}'' as they refer to the same URL", item.getPath(), oldItem.getPath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            itemsMap.put(item.getUrl(), item);
        }
        Iterator urls = itemsMap.keySet().iterator();
        SVNURL baseURL = (SVNURL)urls.next();
        while (urls.hasNext()) {
            SVNURL url = (SVNURL)urls.next();
            baseURL = SVNURLUtil.getCommonURLAncestor(baseURL, url);
        }
        if (itemsMap.containsKey(baseURL)) {
            SvnCommitItem rootItem = (SvnCommitItem)itemsMap.get(baseURL);
            if (rootItem.getKind() != SVNNodeKind.DIR) {
                baseURL = baseURL.removePathTail();
            } else if (rootItem.getKind() == SVNNodeKind.DIR && (rootItem.hasFlag(1) || rootItem.hasFlag(2) || rootItem.hasFlag(16) || rootItem.hasFlag(32))) {
                baseURL = baseURL.removePathTail();
            }
        }
        if (baseURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Cannot compute base URL for commit operation");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        for (SVNURL url : itemsMap.keySet()) {
            SvnCommitItem item = (SvnCommitItem)itemsMap.get(url);
            String realPath = url.equals(baseURL) ? "" : SVNPathUtil.getRelativePath(baseURL.getPath(), url.getPath());
            decodedPaths.put(realPath, item);
        }
        return baseURL;
    }

    public static Map<String, String> translateLockTokens(Map<SVNURL, String> lockTokens, SVNURL baseURL) {
        TreeMap<String, String> translatedLocks = new TreeMap<String, String>();
        for (SVNURL url : lockTokens.keySet()) {
            if (!SVNURLUtil.isAncestor(baseURL, url)) continue;
            String token = lockTokens.get(url);
            String path = url.getPath().substring(baseURL.getPath().length());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            translatedLocks.put(path, token);
        }
        return translatedLocks;
    }

    static interface ISvnUrlKindCallback {
        public SVNNodeKind getUrlKind(SVNURL var1, long var2) throws SVNException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeCommitStatus {
        kind,
        added,
        deleted,
        notPresent,
        excluded,
        isOpRoot,
        isReplaceRoot,
        symlink,
        reposRelPath,
        revision,
        originalReposRelPath,
        originalRevision,
        changelist,
        conflicted,
        updateRoot,
        lockToken,
        propsMod;

    }
}

