/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.OaiPmh;
import org.jdom.Element;

public class ResumptionToken {
    private String token;
    private ISODate expirDate;
    private Integer listSize;
    private Integer cursor;

    public ResumptionToken() {
    }

    public ResumptionToken(Element rt) {
        this.token = rt.getText();
        String expDt = rt.getAttributeValue("expirationDate");
        String listSz = rt.getAttributeValue("completeListSize");
        String curs = rt.getAttributeValue("cursor");
        this.expirDate = expDt == null ? null : new ISODate(expDt);
        this.listSize = listSz == null ? null : Integer.valueOf(listSz);
        this.cursor = curs == null ? null : Integer.valueOf(curs);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public ISODate getExpirDate() {
        return this.expirDate;
    }

    public void setExpirDate(ISODate date) {
        this.expirDate = date;
    }

    public Integer getCompleteListSize() {
        return this.listSize;
    }

    public Integer getCursor() {
        return this.cursor;
    }

    public boolean isTokenEmpty() {
        return this.token.length() == 0;
    }

    public Element toXml() {
        Element root = new Element("resumptionToken", OaiPmh.Namespaces.OAI_PMH);
        root.setText(this.token);
        if (this.expirDate != null) {
            root.setAttribute("expirationDate", this.expirDate.toString());
        }
        if (this.listSize != null) {
            root.setAttribute("completeListSize", this.listSize.toString());
        }
        if (this.cursor != null) {
            root.setAttribute("cursor", this.cursor.toString());
        }
        return root;
    }
}

