/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.exceptions.BadResumptionTokenException;
import org.fao.oaipmh.requests.TokenListRequest;
import org.fao.oaipmh.responses.ResumptionToken;
import org.fao.oaipmh.util.SearchResult;
import org.jdom.Element;

public class GeonetworkResumptionToken
extends ResumptionToken {
    public static final String SEPARATOR = "/-/";
    private Integer listSize;
    private Integer cursor;
    private Integer pos;
    private String set = "";
    private String from = "";
    private String until = "";
    private String prefix = "";
    private Boolean isReset = false;
    private String randomid;
    private SearchResult res;
    private SecureRandom random = new SecureRandom();

    public GeonetworkResumptionToken(Element rt) {
        this.build(rt);
    }

    public GeonetworkResumptionToken(TokenListRequest req) throws BadResumptionTokenException {
        String strToken = req.getResumptionToken();
        if (strToken == null) {
            if (req.getFrom() != null) {
                this.from = req.getFrom().toString();
            }
            if (req.getUntil() != null) {
                this.until = req.getUntil().toString();
            }
            if (req.getSet() != null) {
                this.set = req.getSet();
            }
            this.prefix = req.getMetadataPrefix();
            this.randomid = this.generateRandomString();
        } else {
            this.parseToken(strToken);
        }
    }

    public GeonetworkResumptionToken(TokenListRequest req, SearchResult res) throws BadResumptionTokenException {
        this(req);
        this.res = res;
    }

    public static String buildKey(TokenListRequest req) throws BadResumptionTokenException {
        GeonetworkResumptionToken temp = new GeonetworkResumptionToken(req);
        return temp.getKey();
    }

    public static int getPos(TokenListRequest req) throws BadResumptionTokenException {
        GeonetworkResumptionToken temp = new GeonetworkResumptionToken(req);
        return temp.getPos();
    }

    @Override
    public String getToken() {
        if (this.isReset.booleanValue()) {
            return "";
        }
        return this.getKey() + SEPARATOR + this.pos;
    }

    @Override
    public void setToken(String token) {
        try {
            this.parseToken(token);
        }
        catch (BadResumptionTokenException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTokenEmpty() {
        return this.isReset;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public String getKey() {
        return this.set + SEPARATOR + this.prefix + SEPARATOR + this.from + SEPARATOR + this.until + SEPARATOR + this.randomid;
    }

    public SearchResult getRes() {
        return this.res;
    }

    public void setRes(SearchResult res) {
        this.res = res;
    }

    public void reset() {
        this.isReset = true;
    }

    public void setupToken(int newpos) {
        if (newpos < this.res.getIds().size()) {
            this.setPos(newpos);
        } else {
            this.reset();
        }
    }

    @Override
    public Element toXml() {
        Element root = new Element("resumptionToken", OaiPmh.Namespaces.OAI_PMH);
        root.setText(this.getToken());
        if (this.getExpirDate() != null) {
            root.setAttribute("expirationDate", this.getExpirDate().toString());
        }
        if (this.listSize != null) {
            root.setAttribute("completeListSize", this.listSize.toString());
        }
        if (this.cursor != null) {
            root.setAttribute("cursor", this.cursor.toString());
        }
        return root;
    }

    private void build(Element rt) {
        try {
            this.parseToken(rt.getText());
        }
        catch (BadResumptionTokenException e) {
            throw new RuntimeException(e);
        }
        String expDt = rt.getAttributeValue("expirationDate");
        String listSz = rt.getAttributeValue("completeListSize");
        String curs = rt.getAttributeValue("cursor");
        this.setExpirDate(expDt == null ? null : new ISODate(expDt));
        this.listSize = listSz == null ? null : Integer.valueOf(listSz);
        this.cursor = curs == null ? null : Integer.valueOf(curs);
    }

    private void parseToken(String strToken) throws BadResumptionTokenException {
        String[] temp = strToken.split(SEPARATOR);
        if (temp.length != 6) {
            throw new BadResumptionTokenException("unknown resumptionToken format: " + strToken);
        }
        this.set = temp[0];
        this.prefix = temp[1];
        this.from = temp[2];
        this.until = temp[3];
        this.randomid = temp[4];
        this.pos = Integer.parseInt(temp[5]);
    }

    public String generateRandomString() {
        return new BigInteger(130, this.random).toString(36);
    }
}

