/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.InspireAtomFeedEntry;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class AtomGetData
implements Service {
    private static final String DATASET_IDENTIFIER_CODE_PARAM = "spatial_dataset_identifier_code";
    private static final String DATASET_IDENTIFIER_NS_PARAM = "spatial_dataset_identifier_namespace";
    private static final String DATASET_CRS_PARAM = "crs";

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        String datasetIdCode = Util.getParam((Element)params, (String)DATASET_IDENTIFIER_CODE_PARAM);
        String datasetIdNs = Util.getParam((Element)params, (String)DATASET_IDENTIFIER_NS_PARAM);
        String datasetCrs = Util.getParam((Element)params, (String)DATASET_CRS_PARAM);
        String datasetUuid = service.retrieveDatasetUuidFromIdentifierNs(datasetIdCode, datasetIdNs);
        if (StringUtils.isEmpty((String)datasetUuid)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        String id = dm.getMetadataId(datasetUuid);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        InspireAtomFeed inspireAtomFeed = service.findByMetadataId(Integer.parseInt(id));
        String atomUrl = inspireAtomFeed.getAtomUrl();
        if (StringUtils.isEmpty((String)atomUrl)) {
            throw new Exception("Metadata has no atom feed");
        }
        Pair<Integer, InspireAtomFeedEntry> result = this.countDatasetsForCrs(inspireAtomFeed, datasetCrs);
        int downloadCount = (Integer)result.one();
        InspireAtomFeedEntry selectedEntry = (InspireAtomFeedEntry)result.two();
        if (downloadCount == 0) {
            throw new Exception("No downloads available for dataset: " + datasetIdCode + " and CRS: " + datasetCrs);
        }
        if (downloadCount == 1) {
            return new Element("response").setAttribute("redirect", "true").setAttribute("url", selectedEntry.getUrl()).setAttribute("mime-type", selectedEntry.getType());
        }
        Element feed = service.retrieveFeed(context, inspireAtomFeed);
        InspireAtomUtil.filterDatasetFeedByCrs(feed, datasetCrs);
        return feed;
    }

    private Pair<Integer, InspireAtomFeedEntry> countDatasetsForCrs(InspireAtomFeed inspireAtomFeed, String datasetCrs) {
        int downloadCount = 0;
        InspireAtomFeedEntry selectedEntry = null;
        for (InspireAtomFeedEntry entry : inspireAtomFeed.getEntryList()) {
            if (!datasetCrs.equals(entry.getCrs())) continue;
            selectedEntry = entry;
            ++downloadCount;
        }
        return Pair.write((Object)downloadCount, selectedEntry);
    }
}

