/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.feature.type.Types;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.util.Cloneable;
import org.xml.sax.helpers.NamespaceSupport;

public class XPathUtil {
    private static final Logger LOGGER = Logging.getLogger(XPathUtil.class);

    private static List<String> splitPath(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuffer b = new StringBuffer();
        int insideIndex = 0;
        for (int pos = 0; pos < s.length(); ++pos) {
            if (s.charAt(pos) == '/' && insideIndex == 0) {
                parts.add(b.toString());
                b = new StringBuffer();
                continue;
            }
            if (s.charAt(pos) == '[') {
                ++insideIndex;
            } else if (s.charAt(pos) == ']') {
                --insideIndex;
            }
            b.append(s.charAt(pos));
        }
        parts.add(b.toString());
        return parts;
    }

    public static StepList rootElementSteps(AttributeDescriptor rootElement, NamespaceSupport namespaces) throws IllegalArgumentException {
        if (rootElement == null) {
            throw new NullPointerException("root");
        }
        StepList steps = new StepList();
        QName qName = Types.toQName(rootElement.getName(), namespaces);
        steps.add(new Step(qName, 1, false, false));
        return steps;
    }

    public static StepList steps(AttributeDescriptor root, String xpathExpression, NamespaceSupport namespaces) throws IllegalArgumentException {
        int startIndex;
        List<String> partialSteps;
        if (root == null) {
            throw new NullPointerException("root");
        }
        if (xpathExpression == null) {
            throw new NullPointerException("xpathExpression");
        }
        String expression = xpathExpression.trim();
        if ("".equals(expression)) {
            throw new IllegalArgumentException("expression is empty");
        }
        StepList steps = new StepList();
        if ("/".equals(expression)) {
            expression = root.getName().getLocalPart();
        }
        if (expression.startsWith("/")) {
            expression = expression.substring(1);
        }
        if ((partialSteps = XPathUtil.splitPath(expression)).size() == 0) {
            throw new IllegalArgumentException("no steps provided");
        }
        for (int i = startIndex = 0; i < partialSteps.size(); ++i) {
            String step = partialSteps.get(i);
            if ("..".equals(step)) {
                steps.remove(steps.size() - 1);
                continue;
            }
            if (".".equals(step)) continue;
            int index = 1;
            boolean isXmlAttribute = false;
            boolean isIndexed = false;
            String predicate = null;
            String stepName = step;
            if (step.indexOf(91) != -1) {
                int start = step.indexOf(91);
                int end = step.indexOf(93);
                stepName = step.substring(0, start);
                String s = step.substring(start + 1, end);
                try (Scanner scanner = new Scanner(s);){
                    if (scanner.hasNextInt()) {
                        index = scanner.nextInt();
                        isIndexed = true;
                    } else {
                        predicate = s;
                    }
                }
            }
            if (step.charAt(0) == '@') {
                isXmlAttribute = true;
                stepName = stepName.substring(1);
            }
            QName qName = XPathUtil.deglose(stepName, root, namespaces, isXmlAttribute);
            if (predicate == null) {
                steps.add(new Step(qName, index, isXmlAttribute, isIndexed));
                continue;
            }
            steps.add(new Step(qName, isXmlAttribute, predicate));
        }
        if (root != null && steps.size() > 1) {
            QName stepName;
            Step step = (Step)steps.get(0);
            Name rootName = root.getName();
            if (Types.equals(rootName, stepName = step.getName())) {
                LOGGER.fine("removing root name from xpath " + (Object)((Object)steps) + " as it is redundant");
                steps.remove(0);
            }
        }
        return steps;
    }

    private static QName deglose(String prefixedName, AttributeDescriptor root, NamespaceSupport namespaces, boolean isXmlAttribute) {
        String prefix;
        String namespaceUri;
        String localName;
        if (prefixedName == null) {
            throw new NullPointerException("prefixedName");
        }
        QName name = null;
        int prefixIdx = prefixedName.indexOf(58);
        if (prefixIdx == -1) {
            String defaultNamespace;
            localName = prefixedName;
            Name rootName = root.getName();
            namespaceUri = defaultNamespace = isXmlAttribute || localName.equals(ComplexFeatureConstants.FEATURE_CHAINING_LINK_NAME.getLocalPart()) || rootName.getNamespaceURI() == null ? "" : (namespaces.getURI("") == null ? rootName.getNamespaceURI() : namespaces.getURI(""));
            if ("".equals(defaultNamespace)) {
                prefix = "";
            } else {
                if (!localName.equals(rootName.getLocalPart())) {
                    LOGGER.fine("Using root's namespace " + defaultNamespace + " for step named '" + localName + "', as no prefix was stated");
                }
                if ((prefix = namespaces.getPrefix(defaultNamespace)) == null) {
                    prefix = "";
                }
            }
        } else {
            prefix = prefixedName.substring(0, prefixIdx);
            localName = prefixedName.substring(prefixIdx + 1);
            namespaceUri = namespaces.getURI(prefix);
        }
        name = new QName(namespaceUri, localName, prefix);
        return name;
    }

    public static boolean equals(Name targetNodeName, StepList targetXPath) {
        Step rootStep;
        QName stepName;
        return targetXPath.size() == 1 && Types.equals(targetNodeName, stepName = (rootStep = (Step)targetXPath.get(0)).getName());
    }

    public static class Step
    implements Cloneable {
        private int index;
        private String predicate = null;
        private QName attributeName;
        private boolean isXmlAttribute;
        private boolean isIndexed;

        public Step(QName name, int index) {
            this(name, index, false, false);
        }

        public Step(QName name, int index, boolean isXmlAttribute) {
            this(name, index, isXmlAttribute, false);
        }

        public Step(QName name, int index, boolean isXmlAttribute, boolean isIndexed) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (index < 1) {
                throw new IllegalArgumentException("index shall be >= 1");
            }
            this.attributeName = name;
            this.index = index;
            this.isXmlAttribute = isXmlAttribute;
            this.isIndexed = isIndexed;
        }

        public Step(QName name, boolean isXmlAttribute, String predicate) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.attributeName = name;
            this.index = 1;
            this.isIndexed = false;
            this.isXmlAttribute = isXmlAttribute;
            this.predicate = predicate;
        }

        public boolean equalsIgnoreIndex(Step other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return this.attributeName.equals(other.attributeName) && this.isXmlAttribute == other.isXmlAttribute;
        }

        public int getIndex() {
            return this.index;
        }

        public String getPredicate() {
            return this.predicate;
        }

        public boolean isIndexed() {
            return this.isIndexed;
        }

        public QName getName() {
            return this.attributeName;
        }

        @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
        public String toString() {
            StringBuffer sb = new StringBuffer(this.isXmlAttribute ? "@" : "");
            if ("" != this.attributeName.getPrefix()) {
                sb.append(this.attributeName.getPrefix()).append(':');
            }
            sb.append(this.attributeName.getLocalPart());
            if (this.isIndexed) {
                sb.append("[").append(this.index).append("]");
            } else if (this.predicate != null) {
                sb.append("[").append(this.predicate).append("]");
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Step)) {
                return false;
            }
            Step s = (Step)o;
            return this.attributeName.equals(s.attributeName) && this.index == s.index && this.isXmlAttribute == s.isXmlAttribute && Objects.equals(this.predicate, s.predicate);
        }

        public int hashCode() {
            return 17 * this.attributeName.hashCode() + 37 * this.index;
        }

        public Step clone() {
            return this.predicate == null ? new Step(this.attributeName, this.index, this.isXmlAttribute, this.isIndexed) : new Step(this.attributeName, this.isXmlAttribute, this.predicate);
        }

        public boolean isXmlAttribute() {
            return this.isXmlAttribute;
        }

        public void setIndex(int index) {
            this.index = index;
            this.isIndexed = true;
        }
    }

    public static class StepList
    extends CheckedArrayList<Step> {
        private static final long serialVersionUID = -5612786286175355862L;

        private StepList() {
            super(Step.class);
        }

        public StepList(StepList steps) {
            super(Step.class);
            this.addAll((Collection)((Object)steps));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Step s = (Step)it.next();
                sb.append(s.toString());
                if (!it.hasNext()) continue;
                sb.append("/");
            }
            return sb.toString();
        }

        public boolean containsPredicate() {
            for (int i = 0; i < this.size(); ++i) {
                if (((Step)this.get(i)).getPredicate() == null) continue;
                return true;
            }
            return false;
        }

        public boolean startsWith(StepList other) {
            if (other.size() > this.size()) {
                return false;
            }
            int i = 0;
            if (i < other.size()) {
                Step thisStep = (Step)this.get(i);
                Step otherStep = (Step)other.get(i);
                if (thisStep.isIndexed && otherStep.isIndexed) {
                    return thisStep.equals(otherStep);
                }
                return thisStep.equalsIgnoreIndex(otherStep);
            }
            return true;
        }

        public StepList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > this.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            StepList subList = new StepList();
            for (int i = fromIndex; i < toIndex; ++i) {
                subList.add(this.get(i));
            }
            return subList;
        }

        public StepList clone() {
            StepList copy = new StepList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Step step = (Step)iterator.next();
                copy.add(step.clone());
            }
            return copy;
        }

        public boolean equalsIgnoreIndex(StepList propertyName) {
            if (propertyName == null) {
                return false;
            }
            if (propertyName == this) {
                return true;
            }
            if (this.size() != propertyName.size()) {
                return false;
            }
            Iterator mine = this.iterator();
            Iterator him = propertyName.iterator();
            while (mine.hasNext()) {
                Step hisStep;
                Step myStep = (Step)mine.next();
                if (myStep.equalsIgnoreIndex(hisStep = (Step)him.next())) continue;
                return false;
            }
            return true;
        }

        public void setIndex(int index, String xpath, String separator) {
            if (this.toString().contains(xpath)) {
                for (int i = 0; i < this.size() - 1; ++i) {
                    String firstString = ((Step)this.get(i)).toString();
                    if (xpath.equals(firstString)) {
                        ((Step)this.get(i)).setIndex(index);
                        return;
                    }
                    if (!xpath.startsWith(firstString)) continue;
                    StringBuffer buf = new StringBuffer(firstString);
                    buf.append(separator);
                    for (int j = i + 1; j < this.size() - 1; ++j) {
                        buf.append(((Step)this.get(j)).toString());
                        if (buf.toString().equals(xpath)) {
                            ((Step)this.get(j)).setIndex(index);
                            return;
                        }
                        buf.append(separator);
                    }
                }
            }
        }
    }
}

