/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.xpath;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.geotools.data.complex.feature.xpath.DescriptorXmlAttributeNodeIterator;
import org.geotools.data.complex.feature.xpath.FeatureTypeAttributeIterator;
import org.geotools.data.complex.feature.xpath.SingleFeatureTypeAttributeIterator;
import org.geotools.feature.type.Types;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

public class FeatureTypeAttributePointer
extends NodePointer {
    private static final long serialVersionUID = -7238823373667263032L;
    protected ComplexType parentType;
    protected AttributeType attType;
    protected PropertyDescriptor descriptor;
    protected Name name;

    public FeatureTypeAttributePointer(NodePointer parent, ComplexType parentType, Name name) {
        super(parent);
        this.parentType = parentType;
        this.name = name;
        this.descriptor = this.getDescriptor();
        this.attType = (AttributeType)this.descriptor.getType();
    }

    public PropertyDescriptor getDescriptor() {
        return Types.findDescriptor(this.parentType, this.name);
    }

    public boolean isLeaf() {
        return !(this.attType instanceof ComplexType);
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public QName getName() {
        return new QName(this.name.getNamespaceURI(), this.name.getLocalPart());
    }

    public Object getBaseValue() {
        return this.parentType;
    }

    public Object getImmediateNode() {
        return this.descriptor;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Feature types are immutable");
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodeTypeTest nodeTypeTest;
        if (test instanceof NodeNameTest) {
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            if (!nodeNameTest.isWildcard()) {
                String localName = nodeNameTest.getNodeName().getName();
                String nameSpace = nodeNameTest.getNamespaceURI();
                if (nameSpace == null) {
                    nameSpace = this.getNamespaceResolver().getNamespaceURI("");
                }
                return new SingleFeatureTypeAttributeIterator(this, (ComplexType)this.attType, Types.typeName(nameSpace, localName));
            }
            return new FeatureTypeAttributeIterator(this, (ComplexType)this.attType);
        }
        if (test instanceof NodeTypeTest && (nodeTypeTest = (NodeTypeTest)test).getNodeType() == 1) {
            return new FeatureTypeAttributeIterator(this, (ComplexType)this.attType);
        }
        return super.childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName qname) {
        return new DescriptorXmlAttributeNodeIterator(this, Types.typeName(this.getNamespaceResolver().getNamespaceURI(qname.getPrefix()), qname.getName()));
    }
}

