/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.plugins.CombinedRequestHandler;
import springfox.documentation.spring.web.plugins.PathAndParametersEquivalence;

class DefaultRequestHandlerCombiner
implements RequestHandlerCombiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestHandlerCombiner.class);
    private static final PathAndParametersEquivalence EQUIVALENCE = new PathAndParametersEquivalence();

    DefaultRequestHandlerCombiner() {
    }

    public List<RequestHandler> combine(List<RequestHandler> source) {
        ArrayList<? extends RequestHandler> combined = new ArrayList<RequestHandler>();
        LinkedListMultimap byPath = LinkedListMultimap.create();
        for (RequestHandler each : BuilderDefaults.nullToEmptyList(source)) {
            byPath.put((Object)Orderings.patternsCondition((RequestHandler)each).toString(), (Object)each);
        }
        for (String key : byPath.keySet()) {
            combined.addAll(this.combined(byPath.get((Object)key)));
        }
        return Orderings.byPatternsCondition().sortedCopy(combined);
    }

    private Collection<? extends RequestHandler> combined(Collection<RequestHandler> requestHandlers) {
        ArrayList source = Lists.newArrayList(requestHandlers);
        if (source.size() == 0 || source.size() == 1) {
            return requestHandlers;
        }
        ImmutableListMultimap<Equivalence.Wrapper<RequestHandler>, RequestHandler> groupByEquality = this.safeGroupBy(source);
        ArrayList combined = Lists.newArrayList();
        for (Equivalence.Wrapper path : groupByEquality.keySet()) {
            List handlers = groupByEquality.get((Object)path);
            RequestHandler toCombine = (RequestHandler)path.get();
            if (handlers.size() > 1) {
                for (RequestHandler each : handlers) {
                    if (each.equals(toCombine)) continue;
                    toCombine = this.combine(toCombine, each);
                }
            }
            combined.add(toCombine);
        }
        return combined;
    }

    private ImmutableListMultimap<Equivalence.Wrapper<RequestHandler>, RequestHandler> safeGroupBy(List<RequestHandler> source) {
        try {
            return Multimaps.index(source, this.equivalenceAsKey());
        }
        catch (Exception e) {
            LOGGER.error("Unable to index request handlers {}. Request handlers with issues{}", (Object)e.getMessage(), (Object)this.keys(source));
            return ImmutableListMultimap.builder().build();
        }
    }

    private String keys(List<RequestHandler> source) {
        StringBuffer sb = new StringBuffer("Request Handlers with duplicate keys {");
        for (int i = 0; i < source.size(); ++i) {
            sb.append('\t').append(i).append(". ").append(source.get(i).key());
        }
        sb.append('}');
        return sb.toString();
    }

    private Function<RequestHandler, Equivalence.Wrapper<RequestHandler>> equivalenceAsKey() {
        return new Function<RequestHandler, Equivalence.Wrapper<RequestHandler>>(){

            public Equivalence.Wrapper<RequestHandler> apply(RequestHandler input) {
                return EQUIVALENCE.wrap(input);
            }
        };
    }

    private RequestHandler combine(RequestHandler first, RequestHandler second) {
        return new CombinedRequestHandler(first, second);
    }
}

