/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.springframework.core.Ordered;

public class Tag
implements Ordered {
    private final String name;
    private final String description;
    private final int order;

    public Tag(String name, String description) {
        this(name, description, Integer.MAX_VALUE);
    }

    public Tag(String name, String description, int order) {
        this.name = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)name));
        this.description = description;
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equal((Object)this.name, (Object)tag.name) && Objects.equal((Object)this.description, (Object)tag.description);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description});
    }
}

