/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestHandlerKey {
    private final Set<String> pathMappings;
    private final Set<RequestMethod> supportedMethods;
    private final Set<? extends MediaType> supportedMediaTypes;
    private final Set<? extends MediaType> producibleMediaTypes;

    public RequestHandlerKey(Set<String> pathMappings, Set<RequestMethod> supportedMethods, Set<? extends MediaType> supportedMediaTypes, Set<? extends MediaType> producibleMediaTypes) {
        this.pathMappings = pathMappings;
        this.supportedMethods = supportedMethods;
        this.supportedMediaTypes = supportedMediaTypes;
        this.producibleMediaTypes = producibleMediaTypes;
    }

    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    public Set<RequestMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public Set<? extends MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public Set<? extends MediaType> getProducibleMediaTypes() {
        return this.producibleMediaTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHandlerKey that = (RequestHandlerKey)o;
        return Sets.symmetricDifference(this.pathMappings, that.pathMappings).isEmpty() && Sets.symmetricDifference(this.supportedMethods, that.supportedMethods).isEmpty() && Sets.symmetricDifference(this.supportedMediaTypes, that.supportedMediaTypes).isEmpty() && Sets.symmetricDifference(this.producibleMediaTypes, that.producibleMediaTypes).isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pathMappings, this.supportedMethods, this.supportedMediaTypes, this.producibleMediaTypes});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestHandlerKey{");
        sb.append("pathMappings=").append(this.pathMappings);
        sb.append(", supportedMethods=").append(this.supportedMethods);
        sb.append(", supportedMediaTypes=").append(this.supportedMediaTypes);
        sb.append(", producibleMediaTypes=").append(this.producibleMediaTypes);
        sb.append('}');
        return sb.toString();
    }
}

