/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws;

import com.google.common.collect.Multimap;
import java.io.Closeable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.features.DirectionalGroupApi;
import org.jclouds.ultradns.ws.features.DirectionalPoolApi;
import org.jclouds.ultradns.ws.features.ResourceRecordApi;
import org.jclouds.ultradns.ws.features.RoundRobinPoolApi;
import org.jclouds.ultradns.ws.features.TaskApi;
import org.jclouds.ultradns.ws.features.TrafficControllerPoolApi;
import org.jclouds.ultradns.ws.features.ZoneApi;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.xml.AccountHandler;
import org.jclouds.ultradns.ws.xml.RegionListHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface UltraDNSWSApi
extends Closeable {
    @Named(value="getAccountsListOfUser")
    @POST
    @XMLResponseParser(value=AccountHandler.class)
    @Payload(value="<v01:getAccountsListOfUser/>")
    public IdAndName getCurrentAccount();

    @Named(value="getAvailableRegions")
    @POST
    @XMLResponseParser(value=RegionListHandler.class)
    @Payload(value="<v01:getAvailableRegions/>")
    public Multimap<IdAndName, String> getRegionsByIdAndName();

    @Delegate
    public ZoneApi getZoneApi();

    @Delegate
    public ResourceRecordApi getResourceRecordApiForZone(@PayloadParam(value="zoneName") String var1);

    @Delegate
    public RoundRobinPoolApi getRoundRobinPoolApiForZone(@PayloadParam(value="zoneName") String var1);

    @Delegate
    public TrafficControllerPoolApi getTrafficControllerPoolApiForZone(@PayloadParam(value="zoneName") String var1);

    @Delegate
    public DirectionalGroupApi getDirectionalGroupApiForAccount(@PayloadParam(value="accountId") String var1);

    @Delegate
    public DirectionalPoolApi getDirectionalPoolApiForZone(@PayloadParam(value="zoneName") String var1);

    @Delegate
    public TaskApi getTaskApi();
}

