/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.wms.Auto42001;
import org.geotools.referencing.factory.wms.Auto42002;
import org.geotools.referencing.factory.wms.Auto42003;
import org.geotools.referencing.factory.wms.Auto42004;
import org.geotools.referencing.factory.wms.Auto97001;
import org.geotools.referencing.factory.wms.Auto97002;
import org.geotools.referencing.factory.wms.Auto97003;
import org.geotools.referencing.factory.wms.Code;
import org.geotools.referencing.factory.wms.Factlet;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.util.InternationalString;

public class AutoCRSFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private static final Citation AUTHORITY;
    private final Map<Integer, Factlet> factlets = new TreeMap<Integer, Factlet>();

    public AutoCRSFactory() {
        this(null);
    }

    public AutoCRSFactory(Hints hints) {
        super(hints, 50);
        this.add(Auto42001.DEFAULT);
        this.add(Auto42002.DEFAULT);
        this.add(Auto42003.DEFAULT);
        this.add(Auto42004.DEFAULT);
        this.add(Auto97001.DEFAULT);
        this.add(Auto97002.DEFAULT);
        this.add(Auto97003.DEFAULT);
    }

    private void add(Factlet f) {
        int code = f.code();
        if (this.factlets.put(code, f) != null) {
            throw new IllegalArgumentException(String.valueOf(code));
        }
    }

    private Factlet findFactlet(Code code) throws NoSuchAuthorityCodeException {
        Integer key;
        Factlet fac;
        if ((code.authority.equalsIgnoreCase("AUTO") || code.authority.equalsIgnoreCase("AUTO2")) && (fac = this.factlets.get(key = Integer.valueOf(code.code))) != null) {
            return fac;
        }
        throw this.noSuchAuthorityCode(code.type, code.toString());
    }

    @Override
    public Citation getAuthority() {
        return AUTHORITY;
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        if (type.isAssignableFrom(ProjectedCRS.class)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Integer code : this.factlets.keySet()) {
                set.add(String.valueOf(code));
            }
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        Code c = new Code(code, ProjectedCRS.class);
        return new SimpleInternationalString(this.findFactlet(c).getName());
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.createProjectedCRS(code);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        Code c = new Code(code, ProjectedCRS.class);
        return this.findFactlet(c).create(c, this.factories);
    }

    static {
        CitationImpl c = new CitationImpl(Citations.AUTO2);
        c.getIdentifiers().addAll(Citations.AUTO.getIdentifiers());
        AUTHORITY = (Citation)c.unmodifiable();
    }
}

