/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import java.io.Serializable;
import org.geotools.referencing.operation.builder.LocalizationGrid;

public class NADConGridShift
extends LocalizationGrid
implements Serializable {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private double dx;
    private double dy;

    public NADConGridShift(double xmin, double ymin, double xmax, double ymax, double dx, double dy, int width, int height) {
        super(width, height);
        this.minX = xmin;
        this.maxX = xmax;
        this.minY = ymin;
        this.maxY = ymax;
        this.dx = dx;
        this.dy = dy;
    }

    public final int hashCode() {
        long code = Double.doubleToLongBits(this.minX) + 37L * (Double.doubleToLongBits(this.minY) + 37L * (Double.doubleToLongBits(this.maxX) + 37L * (Double.doubleToLongBits(this.maxY) + 37L * (Double.doubleToLongBits(this.dx) + 37L * Double.doubleToLongBits(this.dy)))));
        return (int)code ^ (int)(code >>> 32);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            NADConGridShift that = (NADConGridShift)object;
            return Double.doubleToLongBits(this.minX) == Double.doubleToLongBits(that.minX) && Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(that.minY) && Double.doubleToLongBits(this.maxX) == Double.doubleToLongBits(that.maxX) && Double.doubleToLongBits(this.maxY) == Double.doubleToLongBits(that.maxY) && Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(that.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(that.dy);
        }
        return false;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }
}

