/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.cs.ComparableAxisWrapper;
import org.geotools.referencing.cs.DefaultAffineCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCompoundCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

final class PredefinedCS
implements Comparator<CoordinateSystem> {
    private static Comparator<CoordinateSystem> csComparator;
    private final Class<? extends CoordinateSystem>[] types = new Class[]{CartesianCS.class, AffineCS.class, EllipsoidalCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, VerticalCS.class, TimeCS.class, LinearCS.class, UserDefinedCS.class};

    private PredefinedCS() {
    }

    @Override
    public int compare(CoordinateSystem object1, CoordinateSystem object2) {
        Class<?> type1 = object1.getClass();
        Class<?> type2 = object2.getClass();
        for (int i = 0; i < this.types.length; ++i) {
            Class<? extends CoordinateSystem> type = this.types[i];
            boolean a1 = type.isAssignableFrom(type1);
            boolean a2 = type.isAssignableFrom(type2);
            if (a1) {
                return a2 ? 0 : -1;
            }
            if (!a2) continue;
            return a1 ? 0 : 1;
        }
        return 0;
    }

    static CoordinateSystem standard(CoordinateSystem cs) throws IllegalArgumentException {
        int dimension = cs.getDimension();
        if (cs instanceof CartesianCS) {
            switch (dimension) {
                case 2: {
                    if (DefaultCartesianCS.PROJECTED.axisColinearWith(cs)) {
                        return DefaultCartesianCS.PROJECTED;
                    }
                    if (DefaultCartesianCS.GRID.axisColinearWith(cs)) {
                        return DefaultCartesianCS.GRID;
                    }
                    if (DefaultCartesianCS.GENERIC_2D.directionColinearWith(cs)) {
                        return DefaultCartesianCS.GENERIC_2D;
                    }
                    return PredefinedCS.rightHanded((AffineCS)((CartesianCS)cs));
                }
                case 3: {
                    if (DefaultCartesianCS.GEOCENTRIC.axisColinearWith(cs)) {
                        return DefaultCartesianCS.GEOCENTRIC;
                    }
                    if (DefaultCartesianCS.GENERIC_3D.directionColinearWith(cs)) {
                        return DefaultCartesianCS.GENERIC_3D;
                    }
                    return PredefinedCS.rightHanded((AffineCS)((CartesianCS)cs));
                }
            }
        }
        if (cs instanceof AffineCS) {
            return PredefinedCS.rightHanded((AffineCS)cs);
        }
        if (cs instanceof EllipsoidalCS) {
            switch (dimension) {
                case 2: {
                    return DefaultEllipsoidalCS.GEODETIC_2D;
                }
                case 3: {
                    return DefaultEllipsoidalCS.GEODETIC_3D;
                }
            }
        }
        if (cs instanceof SphericalCS) {
            switch (dimension) {
                case 3: {
                    return DefaultSphericalCS.GEOCENTRIC;
                }
            }
        }
        if (cs instanceof VerticalCS) {
            switch (dimension) {
                case 1: {
                    return DefaultVerticalCS.ELLIPSOIDAL_HEIGHT;
                }
            }
        }
        if (cs instanceof TimeCS) {
            switch (dimension) {
                case 1: {
                    return DefaultTimeCS.DAYS;
                }
            }
        }
        if (cs instanceof DefaultCompoundCS) {
            List<CoordinateSystem> components = ((DefaultCompoundCS)cs).getCoordinateSystems();
            Object[] user = new CoordinateSystem[components.size()];
            Object[] std = new CoordinateSystem[user.length];
            for (int i = 0; i < std.length; ++i) {
                user[i] = components.get(i);
                std[i] = PredefinedCS.standard((CoordinateSystem)user[i]);
            }
            if (csComparator == null) {
                csComparator = new PredefinedCS();
            }
            Arrays.sort(std, csComparator);
            return Arrays.equals(user, std) ? cs : new DefaultCompoundCS((CoordinateSystem[])std);
        }
        throw new IllegalArgumentException(Errors.format((int)196, (Object)cs.getName().getCode()));
    }

    private static AffineCS rightHanded(AffineCS cs) {
        boolean changed = false;
        int dimension = cs.getDimension();
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[dimension];
        for (int i = 0; i < dimension; ++i) {
            Unit unit;
            axis[i] = cs.getAxis(i);
            CoordinateSystemAxis axe = axis[i];
            DefaultCoordinateSystemAxis standard = DefaultCoordinateSystemAxis.getPredefined(axe);
            if (standard != null) {
                axe = standard;
            }
            if (!AbstractUnit.ONE.equals(unit = axe.getUnit()) && !SI.METRE.equals(unit)) {
                if (!(axe instanceof DefaultCoordinateSystemAxis)) {
                    axe = new DefaultCoordinateSystemAxis(axe);
                }
                axe = ((DefaultCoordinateSystemAxis)axe).usingUnit(SI.METRE);
            }
            changed |= axe != axis[i];
            axis[i] = axe;
        }
        if (!(changed |= ComparableAxisWrapper.sort(axis))) {
            return cs;
        }
        Map<String, Object> properties = DefaultAffineCS.getProperties((IdentifiedObject)cs, null);
        if (cs instanceof CartesianCS) {
            return new DefaultCartesianCS(properties, axis);
        }
        return new DefaultAffineCS(properties, axis);
    }
}

