/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordBuilder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.XMLSerializer;
import org.jzkit.search.util.RecordBuilder.RecordBuilder;
import org.jzkit.search.util.RecordBuilder.RecordBuilderException;
import org.jzkit.search.util.RecordBuilder.StringRecordFactory;
import org.marc4j.MarcStreamReader;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcXmlReader;
import org.marc4j.MarcXmlWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.marc.Record;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

@Service(value="org.jzkit.recordbuilder.iso2709")
public class iso2709RecordFactory
implements RecordBuilder,
ApplicationContextAware,
ApplicationListener,
Serializable {
    private static Log log = LogFactory.getLog(StringRecordFactory.class);
    private ApplicationContext ctx = null;

    public Object createFrom(Document input_dom, String esn) throws RecordBuilderException {
        byte[] result = null;
        log.debug((Object)"iso2709 from marcxml");
        try {
            log.debug((Object)"open pip output stream");
            PipedOutputStream pos = new PipedOutputStream();
            XMLSerializer serializer = new XMLSerializer();
            MarcXmlReader reader = new MarcXmlReader((InputStream)new PipedInputStream(pos));
            serializer.setOutputByteStream((OutputStream)pos);
            log.debug((Object)"Serialize dom to output stream");
            serializer.serialize(input_dom);
            log.debug((Object)"flush");
            pos.flush();
            pos.close();
            log.debug((Object)"attempt to read marcxml from pipe");
            if (reader.hasNext()) {
                Record record = reader.next();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MarcStreamWriter writer = new MarcStreamWriter((OutputStream)baos);
                writer.write(record);
                result = baos.toByteArray();
                log.debug((Object)("Result of transform to marc: " + new String(result)));
            } else {
                log.warn((Object)"No marc record found in reader stream");
            }
        }
        catch (IOException ioe) {
            throw new RecordBuilderException("Problem converting MARCXML to iso2709", ioe);
        }
        log.debug((Object)("result=" + result));
        return result;
    }

    public Document getCanonicalXML(Object native_object) throws RecordBuilderException {
        Document retval = null;
        try {
            MarcStreamReader reader = new MarcStreamReader((InputStream)new ByteArrayInputStream((byte[])native_object));
            DOMResult result = new DOMResult();
            MarcXmlWriter writer = new MarcXmlWriter((Result)result);
            writer.setConverter((CharConverter)new AnselToUnicode());
            if (reader.hasNext()) {
                Record record = reader.next();
                writer.write(record);
            }
            writer.close();
            retval = (Document)result.getNode();
        }
        catch (Exception e) {
            throw new RecordBuilderException("Problem creating marcxml from iso2709", e);
        }
        return retval;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void onApplicationEvent(ApplicationEvent evt) {
    }
}

