/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.Internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.HumanReadableQueryBundle;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.Internal.TermValueBundle;

public class HumanReadableVisitor {
    public static String toHumanReadableString(InternalModelRootNode rn) throws IOException {
        HumanReadableQueryBundle bundle = new HumanReadableQueryBundle();
        HumanReadableVisitor.visit(rn, bundle);
        return bundle.getHumanReadableQuery();
    }

    public static void toHumanReadableBundle(InternalModelRootNode rn, HumanReadableQueryBundle bundle) throws IOException {
        HumanReadableVisitor.visit(rn, bundle);
    }

    public static void visit(QueryNode qn, HumanReadableQueryBundle bundle) throws IOException {
        if (qn instanceof InternalModelRootNode) {
            HumanReadableVisitor.visit((InternalModelRootNode)qn, bundle);
        } else if (qn instanceof InternalModelNamespaceNode) {
            HumanReadableVisitor.visit((InternalModelNamespaceNode)qn, bundle);
        } else if (qn instanceof ComplexNode) {
            HumanReadableVisitor.visit((ComplexNode)qn, bundle);
        } else if (qn instanceof AttrPlusTermNode) {
            HumanReadableVisitor.visit((AttrPlusTermNode)qn, bundle);
        }
    }

    public static void visit(InternalModelRootNode rn, HumanReadableQueryBundle bundle) throws IOException {
        HumanReadableVisitor.visit(rn.getChild(), bundle);
    }

    public static void visit(InternalModelNamespaceNode rn, HumanReadableQueryBundle bundle) throws IOException {
        if (rn.getAttrset() != null) {
            // empty if block
        }
        HumanReadableVisitor.visit(rn.getChild(), bundle);
    }

    public static void visit(ComplexNode cn, HumanReadableQueryBundle bundle) throws IOException {
        int inumleft = 0;
        if (cn.getLHS() != null) {
            inumleft = cn.getLHS().countChildrenWithTerms();
        }
        int inumright = 0;
        if (cn.getRHS() != null) {
            inumright = cn.getRHS().countChildrenWithTerms();
        }
        if (inumleft > 0 && inumright > 0) {
            bundle.append(" ( ");
        }
        if (inumleft > 0) {
            HumanReadableVisitor.visit(cn.getLHS(), bundle);
        }
        if (inumleft > 0 && inumright > 0) {
            switch (cn.getOp()) {
                case 1: {
                    bundle.append(" and ");
                    break;
                }
                case 2: {
                    bundle.append(" or ");
                    break;
                }
                case 3: {
                    bundle.append(" andnot ");
                    break;
                }
                case 4: {
                    bundle.append(" Close to ");
                    break;
                }
                default: {
                    bundle.append(" ERROR ");
                }
            }
        }
        if (inumright > 0) {
            HumanReadableVisitor.visit(cn.getRHS(), bundle);
        }
        if (inumleft > 0 && inumright > 0) {
            bundle.append(" ) ");
        }
    }

    public static void visit(AttrPlusTermNode aptn, HumanReadableQueryBundle bundle) throws IOException {
        Object term = aptn.getTerm();
        TermValueBundle value_bundle = aptn.getTermValueBundle(true);
        if (term instanceof String) {
            bundle.append(" " + value_bundle.getStringValue() + " ");
        } else if (term instanceof Vector || term instanceof Object) {
            boolean multi_term_action = false;
            Object multi_term_action_val = aptn.getAttr("MultiTermOp");
            if (multi_term_action_val != null && multi_term_action_val.toString().equals("OR")) {
                multi_term_action = true;
            }
            if (multi_term_action) {
                bundle.append(" Matches one or more of ");
            } else {
                bundle.append(" Matches all of ");
            }
            bundle.append("[");
            bundle.append(" " + value_bundle.getStringValue() + " ");
            bundle.append("]");
        }
        Iterator i = value_bundle.getValueIterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (aptn.getAccessPoint() instanceof String) {
                bundle.addTerm(aptn.getAccessPoint().toString(), value);
                continue;
            }
            if (aptn.getAccessPoint() != null) {
                String triple = aptn.getAccessPoint().toString();
                int spot = triple.lastIndexOf(".");
                if (spot != -1) {
                    triple = triple.substring(spot + 1, triple.length());
                }
                bundle.addTerm(triple, value);
                continue;
            }
            bundle.addTerm("Unqualified", value);
        }
    }
}

