/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl;

import com.github.sardine.impl.methods.HttpPropFind;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class SardineRedirectStrategy
extends DefaultRedirectStrategy {
    protected boolean isRedirectable(String method) {
        if (super.isRedirectable(method)) {
            return true;
        }
        return method.equalsIgnoreCase("PROPFIND");
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("PROPFIND")) {
            return this.copyEntity(new HttpPropFind(this.getLocationURI(request, response, context)), request);
        }
        return super.getRedirect(request, response, context);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

