/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.Icon;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.VendorOptionParser;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Symbolizer;
import org.locationtech.jts.algorithm.MinimumDiameter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class RandomFillBuilder {
    private static final int MAX_RANDOM_COUNT = Integer.getInteger("org.geotools.render.random.maxCount", 1024);
    private static final int MAX_RANDOM_ATTEMPTS_MULTIPLIER = Integer.getInteger("org.geotools.render.random.maxAttemptsMultiplier", 5);
    private static final boolean RANDOM_VISUAL_DEBUGGER = Boolean.getBoolean("org.geotools.render.random.visualDebugger");
    private VendorOptionParser voParser;
    private SLDStyleFactory factory;

    public RandomFillBuilder(VendorOptionParser voParser, SLDStyleFactory factory) {
        this.voParser = voParser;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage buildRandomTilableImage(Symbolizer symbolizer, Graphic gr, Icon icon, Mark mark, Shape shape, double markSize, Object feature) {
        boolean randomRotation;
        PositionRandomizer randomizer = (PositionRandomizer)this.voParser.getEnumOption(symbolizer, "random", PositionRandomizer.NONE);
        int seed = this.voParser.getIntOption(symbolizer, "random-seed", 0);
        int tileSize = this.voParser.getIntOption(symbolizer, "random-tile-size", 256);
        int count = this.voParser.getIntOption(symbolizer, "random-symbol-count", 16);
        int spaceAround = this.voParser.getIntOption(symbolizer, "random-space-around", 0);
        RotationRandomizer rotation = (RotationRandomizer)this.voParser.getEnumOption(symbolizer, "random-rotation", RotationRandomizer.NONE);
        boolean bl = randomRotation = rotation == RotationRandomizer.FREE;
        if (tileSize <= 0) {
            throw new IllegalArgumentException("The random-tile-size parameter must be positive");
        }
        if (count > MAX_RANDOM_COUNT) {
            throw new IllegalArgumentException("The random-symbol-count exceeds the safety limit " + MAX_RANDOM_COUNT + ". You can override this limit by setting the org.geotools.render.random.maxCount system property");
        }
        if (icon != null && (icon.getIconWidth() > tileSize || icon.getIconHeight() > tileSize)) {
            throw new IllegalArgumentException("Cannot perform random image disposition, image size " + icon.getIconWidth() + "x" + icon.getIconHeight() + " exceeds randomized tile size: " + tileSize);
        }
        BufferedImage image = new BufferedImage(tileSize, tileSize, 6);
        Graphics2D g2d = image.createGraphics();
        Polygon tileBounds = new GeometryBuilder().box(0.0, 0.0, tileSize, tileSize);
        Geometry bounds = this.getGeometryBounds(icon, mark, shape, markSize, feature);
        Geometry conflictBounds = this.getConflictBounds(bounds, spaceAround);
        ReservedAreaCache rac = this.buildReservedAreaCache(conflictBounds);
        Rectangle targetArea = new Rectangle(0, 0, tileSize, tileSize);
        Random random = new Random(seed);
        PositionSequence ps = randomizer == PositionRandomizer.GRID ? new GridBasedPositionGenerator(random, rac, count, targetArea, randomRotation) : new FullyRandomizedPositionGenerator(random, rac, count, targetArea, randomRotation);
        Object oldInterpolationValue = g2d.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        if (randomRotation && icon != null) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        AffineTransform originalTransform = g2d.getTransform();
        try {
            try {
                Position p;
                AffineTransform at = new AffineTransform();
                while ((p = ps.getNextPosition()) != null) {
                    at.setToTranslation(p.x, p.y);
                    at.rotate(Math.toRadians(p.rotation));
                    ArrayList<AffineTransform2D> transforms = new ArrayList<AffineTransform2D>();
                    AffineTransform2D at2d = new AffineTransform2D(at);
                    transforms.add(at2d);
                    Geometry transformed = JTS.transform(bounds, (MathTransform)at2d);
                    if (tileBounds.intersects(transformed) && !tileBounds.contains(transformed)) {
                        for (int dx = -tileSize; dx <= tileSize; dx += tileSize) {
                            for (int dy = -tileSize; dy <= tileSize; dy += tileSize) {
                                if (dx == 0 && dy == 0) continue;
                                int mx = p.x + dx;
                                int my = p.y + dy;
                                at.setToTranslation(mx, my);
                                at.rotate(Math.toRadians(p.rotation));
                                AffineTransform2D tx2d = new AffineTransform2D(at);
                                Geometry translatedBounds = JTS.transform(bounds, (MathTransform)tx2d);
                                if (!tileBounds.intersects(translatedBounds) && !tileBounds.contains(translatedBounds)) continue;
                                transforms.add(tx2d);
                            }
                        }
                    }
                    if (!rac.checkAndReserve(transforms)) {
                        ps.lastPositionResults(true);
                        continue;
                    }
                    for (AffineTransform2D transform : transforms) {
                        if (icon != null) {
                            g2d.setTransform(originalTransform);
                            g2d.transform(transform);
                            icon.paintIcon(null, g2d, 0, 0);
                            continue;
                        }
                        if (shape == null) continue;
                        this.factory.fillDrawMark(g2d, transform.getTranslateX(), transform.getTranslateY(), mark, markSize, Math.toRadians(p.rotation), feature);
                    }
                    ps.lastPositionResults(false);
                }
            }
            catch (TransformException e) {
                throw new RuntimeException("Unexpected error happened while paining the random symbols", e);
            }
        }
        finally {
            g2d.setTransform(originalTransform);
            if (oldInterpolationValue != null) {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldInterpolationValue);
            }
        }
        if (RANDOM_VISUAL_DEBUGGER) {
            rac.paintReservedAreas(g2d);
        }
        g2d.dispose();
        return image;
    }

    private ReservedAreaCache buildReservedAreaCache(Geometry conflictBounds) {
        if (conflictBounds != null) {
            return new DefaultReservedAreaCache(conflictBounds);
        }
        return new NoOpReservedAreaCache();
    }

    private Geometry getConflictBounds(Geometry bounds, int spaceAround) {
        Object conflictBounds = bounds;
        if (spaceAround != 0) {
            conflictBounds = bounds.buffer((double)spaceAround);
            conflictBounds = conflictBounds.isEmpty() || conflictBounds.getArea() == 0.0 ? null : new MinimumDiameter(conflictBounds).getMinimumRectangle();
        }
        return conflictBounds;
    }

    private Geometry getGeometryBounds(Icon icon, Mark mark, Shape shape, double markSize, Object feature) {
        float width;
        Stroke stroke;
        Polygon bounds;
        if (icon != null) {
            bounds = new GeometryBuilder().box(0.0, 0.0, icon.getIconWidth(), icon.getIconHeight());
        } else {
            AffineTransform at = AffineTransform.getScaleInstance(markSize, -markSize);
            Shape ts = at.createTransformedShape(shape);
            Geometry shapeGeometry = JTS.toGeometry(ts);
            bounds = new MinimumDiameter(shapeGeometry).getMinimumRectangle();
        }
        if (icon == null && mark != null && (stroke = this.factory.getStroke(mark.getStroke(), feature)) instanceof BasicStroke && (width = ((BasicStroke)stroke).getLineWidth() / 2.0f + 1.0f) > 0.0f) {
            Geometry buffered = bounds.buffer((double)width);
            bounds = new MinimumDiameter(buffered).getMinimumRectangle();
        }
        return bounds;
    }

    static class GridBasedPositionGenerator
    implements PositionSequence {
        int attempts;
        int symbols;
        int targetSymbolCount;
        double deltaX;
        double deltaY;
        Random random;
        Rectangle targetArea;
        int rows;
        int cols;
        int r;
        int c;
        boolean retry;
        boolean randomRotation;
        Position position = new Position(0, 0, 0.0);

        public GridBasedPositionGenerator(Random random, ReservedAreaCache rac, int targetSymbolCount, Rectangle targetArea, boolean randomRotation) {
            this.targetSymbolCount = targetSymbolCount;
            this.random = random;
            this.targetArea = targetArea;
            this.rows = (int)Math.sqrt(targetSymbolCount);
            this.cols = targetSymbolCount / this.rows;
            this.deltaX = 1.0 * (double)targetArea.width / (double)this.cols;
            this.deltaY = 1.0 * (double)targetArea.height / (double)this.rows;
            this.rows = (int)Math.max(Math.round((double)targetArea.width / this.deltaX), 1L);
            this.cols = (int)Math.max(Math.round((double)targetArea.height / this.deltaY), 1L);
            this.randomRotation = randomRotation;
        }

        @Override
        public Position getNextPosition() {
            if (this.symbols > this.targetSymbolCount || this.r >= this.rows) {
                return null;
            }
            ++this.attempts;
            this.position.x = (int)Math.round(this.targetArea.getMinX() + (double)this.c * this.deltaX + this.random.nextDouble() * this.deltaX);
            this.position.y = (int)Math.round(this.targetArea.getMinY() + (double)this.r * this.deltaY + this.random.nextDouble() * this.deltaY);
            if (this.randomRotation) {
                this.position.rotation = this.random.nextDouble() * 360.0;
            }
            return this.position;
        }

        @Override
        public void lastPositionResults(boolean conflict) {
            if (!conflict) {
                ++this.symbols;
                this.moveToNextCell();
            } else if (this.attempts > MAX_RANDOM_ATTEMPTS_MULTIPLIER) {
                this.moveToNextCell();
            }
        }

        private void moveToNextCell() {
            ++this.c;
            if (this.c >= this.cols) {
                ++this.r;
                this.c = 0;
            }
            this.attempts = 0;
        }
    }

    static class FullyRandomizedPositionGenerator
    implements PositionSequence {
        int attempts;
        int symbols;
        int targetSymbolCount;
        Random random;
        Rectangle targetArea;
        boolean randomRotation;
        Position position = new Position(0, 0, 0.0);

        public FullyRandomizedPositionGenerator(Random random, ReservedAreaCache rac, int targetSymbolCount, Rectangle targetArea, boolean randomRotation) {
            this.targetSymbolCount = targetSymbolCount;
            this.random = random;
            this.targetArea = targetArea;
            this.randomRotation = randomRotation;
        }

        @Override
        public Position getNextPosition() {
            if (this.attempts > this.targetSymbolCount * MAX_RANDOM_ATTEMPTS_MULTIPLIER || this.symbols > this.targetSymbolCount) {
                return null;
            }
            ++this.attempts;
            this.position.x = this.targetArea.x + this.random.nextInt(this.targetArea.width);
            this.position.y = this.targetArea.y + this.random.nextInt(this.targetArea.height);
            if (this.randomRotation) {
                this.position.rotation = this.random.nextDouble() * 360.0;
            }
            return this.position;
        }

        @Override
        public void lastPositionResults(boolean conflict) {
            if (!conflict) {
                ++this.symbols;
            }
        }
    }

    static interface PositionSequence {
        public Position getNextPosition();

        public void lastPositionResults(boolean var1);
    }

    static final class Position {
        int x;
        int y;
        double rotation;

        public Position(int x, int y, double rotation) {
            this.x = x;
            this.y = y;
            this.rotation = rotation;
        }

        public String toString() {
            return "Position [x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + "]";
        }
    }

    private static class DefaultReservedAreaCache
    implements ReservedAreaCache {
        Quadtree qt = new Quadtree();
        Geometry conflictBounds;

        public DefaultReservedAreaCache(Geometry conflictBounds) {
            this.conflictBounds = conflictBounds;
        }

        @Override
        public boolean checkAndReserve(List<AffineTransform2D> transforms) throws MismatchedDimensionException, TransformException {
            ArrayList<Geometry> transformedConflictBounds = new ArrayList<Geometry>();
            boolean conflict = false;
            block0: for (AffineTransform2D tx2d : transforms) {
                if (conflict) break;
                Geometry cbTransformed = JTS.transform(this.conflictBounds, (MathTransform)tx2d);
                transformedConflictBounds.add(cbTransformed);
                List results = this.qt.query(cbTransformed.getEnvelopeInternal());
                for (Geometry candidate : results) {
                    if (!candidate.intersects(cbTransformed)) continue;
                    conflict = true;
                    continue block0;
                }
            }
            if (!conflict) {
                for (Geometry tcb : transformedConflictBounds) {
                    this.qt.insert(tcb.getEnvelopeInternal(), (Object)tcb);
                }
            }
            return !conflict;
        }

        @Override
        public void paintReservedAreas(Graphics2D g2d) {
            g2d.setStroke(new BasicStroke(0.5f));
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.setComposite(AlphaComposite.getInstance(12));
            for (Object bound : this.qt.queryAll()) {
                LiteShape ls = new LiteShape((Geometry)bound, new AffineTransform(), false);
                g2d.draw(ls);
            }
        }
    }

    private static class NoOpReservedAreaCache
    implements ReservedAreaCache {
        private NoOpReservedAreaCache() {
        }

        @Override
        public boolean checkAndReserve(List<AffineTransform2D> positions) {
            return true;
        }

        @Override
        public void paintReservedAreas(Graphics2D g2d) {
        }
    }

    static interface ReservedAreaCache {
        public boolean checkAndReserve(List<AffineTransform2D> var1) throws MismatchedDimensionException, TransformException;

        public void paintReservedAreas(Graphics2D var1);
    }

    public static enum RotationRandomizer {
        NONE,
        FREE;

    }

    public static enum PositionRandomizer {
        NONE,
        FREE,
        GRID;

    }
}

