/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.styling.SelectedChannelType;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

class BandSelectionNode
extends StyleVisitorCoverageProcessingNodeAdapter
implements CoverageProcessingNode {
    private int bandIndex = -1;

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(2);
    }

    public BandSelectionNode() {
        this((Hints)null);
    }

    public BandSelectionNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"BandSelectionNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a BandSelection following SLD 1.0 spec."));
    }

    protected GridCoverage2D execute() {
        assert (this.getSources().size() <= 1);
        List<CoverageProcessingNode> sources = this.getSources();
        if (sources != null && !sources.isEmpty()) {
            GridCoverage2D source = (GridCoverage2D)this.getSource(0).getOutput();
            GridCoverageRendererUtilities.ensureSourceNotNull(source, this.getName().toString());
            GridCoverage2D output = null;
            if (this.bandIndex != -1) {
                int numSampleDimensions = source.getNumSampleDimensions();
                if (this.bandIndex < 1 || this.bandIndex > numSampleDimensions) {
                    throw new IllegalArgumentException(Errors.format(7, this.bandIndex));
                }
                if (this.bandIndex == 1 && numSampleDimensions == 1) {
                    output = source;
                } else {
                    CoverageProcessor processor = new CoverageProcessor((RenderingHints)this.getHints());
                    ParameterValueGroup parameters = processor.getOperation("SelectSampleDimension").getParameters();
                    parameters.parameter("SampleDimensions").setValue((Object)new int[]{this.bandIndex - 1});
                    parameters.parameter("Source").setValue((Object)source);
                    Hints hints = new Hints((RenderingHints)this.getHints());
                    ImageLayout layout = new ImageLayout();
                    RenderedImage sourceRaster = source.getRenderedImage();
                    SampleModel oldSM = sourceRaster.getSampleModel();
                    ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, oldSM.getDataType());
                    layout.setColorModel((ColorModel)cm);
                    layout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(oldSM.getWidth(), oldSM.getHeight()));
                    hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                    output = (GridCoverage2D)new SelectSampleDimension().doOperation(parameters, hints);
                }
                assert (output.getNumSampleDimensions() == 1);
            } else {
                output = source;
            }
            return output;
        }
        throw new IllegalStateException("No source was set for this Node.");
    }

    @Override
    public void visit(SelectedChannelType sct) {
        if (sct != null) {
            try {
                this.bandIndex = (Integer)sct.getChannelName().evaluate(null, Integer.class);
            }
            catch (NumberFormatException e) {
                IllegalArgumentException iee = new IllegalArgumentException(Errors.format(7, this.bandIndex));
                iee.initCause(e);
                throw iee;
            }
            return;
        }
    }

    public int getBandIndex() {
        return this.bandIndex;
    }
}

