/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.renderer.VendorOptionParser;
import org.geotools.renderer.composite.BlendComposite;
import org.geotools.renderer.style.DynamicLineStyle2D;
import org.geotools.renderer.style.DynamicPolygonStyle2D;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.FontCache;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkAlongLine;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PointStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.RandomFillBuilder;
import org.geotools.renderer.style.RescaledIcon;
import org.geotools.renderer.style.Style;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.StyleAttributeExtractorTruncated;
import org.geotools.renderer.style.TTFMarkFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.util.Range;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.style.GraphicalSymbol;

public class SLDStyleFactory {
    private static final Logger LOGGER = Logging.getLogger(SLDStyleFactory.class);
    public static final String USE_LEGACY_ANCHOR_POINT_KEY = "org.geotools.renderer.style.legacyAnchorPoint";
    private static final int MAX_RASTERIZATION_SIZE = 512;
    private static final Map JOIN_LOOKUP = new HashMap();
    private static final Map CAP_LOOKUP = new HashMap();
    private static final Map FONT_STYLE_LOOKUP = new HashMap();
    private static final Map<String, Integer> ALPHA_COMPOSITE_LOOKUP = new LinkedHashMap<String, Integer>();
    private static final float MITER_LIMIT = 1.75f;
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final int DEFAULT_MARK_SIZE = 16;
    Map dynamicSymbolizers = new SoftValueHashMap();
    Map staticSymbolizers = new SoftValueHashMap();
    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    private boolean lineOptimizationEnabled = false;
    private boolean vectorRenderingEnabled = false;
    private long hits;
    private long requests;
    private double mapScaleDenominator = Double.NaN;
    VendorOptionParser voParser = new VendorOptionParser();
    RandomFillBuilder randomFillBuilder = new RandomFillBuilder(this.voParser, this);
    private static final Pattern WHITE_SPACE_SPLIT;

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            return;
        }
        this.renderingHints = renderingHints;
    }

    public boolean isLineOptimizationEnabled() {
        return this.lineOptimizationEnabled;
    }

    public void setLineOptimizationEnabled(boolean lineOptimizationEnabled) {
        this.lineOptimizationEnabled = lineOptimizationEnabled;
    }

    public boolean isVectorRenderingEnabled() {
        return this.vectorRenderingEnabled;
    }

    public void setVectorRenderingEnabled(boolean vectorRenderingEnabled) {
        this.vectorRenderingEnabled = vectorRenderingEnabled;
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public long getHits() {
        return this.hits;
    }

    public long getRequests() {
        return this.requests;
    }

    public Style2D createStyle(Object drawMe, Symbolizer symbolizer) {
        return this.createStyle(drawMe, symbolizer, null);
    }

    public Style2D createStyle(Object drawMe, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        SymbolizerKey key = new SymbolizerKey(symbolizer, scaleRange);
        style = (Style2D)this.staticSymbolizers.get(key);
        ++this.requests;
        if (style != null) {
            ++this.hits;
        } else {
            boolean noAttributes;
            style = this.createStyleInternal(drawMe, symbolizer, scaleRange);
            if (style == null) {
                return null;
            }
            if (this.dynamicSymbolizers.containsKey(key)) {
                return style;
            }
            StyleAttributeExtractorTruncated sae = new StyleAttributeExtractorTruncated();
            sae.visit(symbolizer);
            Set<String> nameSet = sae.getAttributeNameSet();
            boolean bl = noAttributes = nameSet == null || nameSet.size() == 0;
            if (noAttributes && !sae.isUsingVolatileFunctions()) {
                this.staticSymbolizers.put(key, style);
            } else {
                this.dynamicSymbolizers.put(key, Boolean.TRUE);
            }
        }
        return style;
    }

    private Style2D createStyleInternal(Object drawMe, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createPolygonStyle(drawMe, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createLineStyle(drawMe, (LineSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof PointSymbolizer) {
            style = this.createPointStyle(drawMe, (PointSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof TextSymbolizer) {
            style = this.createTextStyle(drawMe, (TextSymbolizer)symbolizer, scaleRange);
        }
        return style;
    }

    public Style2D createDynamicStyle(SimpleFeature f, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createDynamicPolygonStyle(f, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createDynamicLineStyle(f, (LineSymbolizer)symbolizer, scaleRange);
        } else {
            throw new UnsupportedOperationException("This kind of symbolizer is not yet supported");
        }
        return style;
    }

    PolygonStyle2D createPolygonStyle(Object feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        PolygonStyle2D style = new PolygonStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer, symbolizer.getStroke(), feature, scaleRange));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        this.setPolygonStyleFill(feature, style, symbolizer, scaleRange);
        return style;
    }

    void setPolygonStyleFill(Object feature, PolygonStyle2D style, PolygonSymbolizer symbolizer, Range scaleRange) {
        Composite composite;
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return;
        }
        if (fill.getGraphicFill() != null) {
            Style2D style2DFill;
            double size = this.evalToDouble(fill.getGraphicFill().getSize(), feature, 0.0);
            if ((this.isVectorRenderingEnabled() || size > 512.0) && !((style2DFill = this.createPointStyle(feature, symbolizer, fill.getGraphicFill(), scaleRange, false)) instanceof GraphicStyle2D)) {
                style.setGraphicFill(style2DFill);
                return;
            }
        }
        float opacity = 1.0f;
        if (symbolizer.getFill() != null) {
            opacity = this.evalOpacity(symbolizer.getFill().getOpacity(), feature);
        }
        if ((composite = SLDStyleFactory.getComposite(symbolizer.getOptions(), opacity)) == null) {
            composite = AlphaComposite.getInstance(3, opacity);
        }
        style.setFill(this.getPaint(symbolizer.getFill(), feature, symbolizer));
        style.setFillComposite(composite);
    }

    Style2D createDynamicPolygonStyle(SimpleFeature feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        DynamicPolygonStyle2D style = new DynamicPolygonStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createLineStyle(Object feature, LineSymbolizer symbolizer, Range scaleRange) {
        Composite composite;
        float opacity = 1.0f;
        if (symbolizer.getStroke() != null) {
            opacity = this.evalOpacity(symbolizer.getStroke().getOpacity(), feature);
        }
        if ((composite = SLDStyleFactory.getComposite(symbolizer.getOptions(), opacity)) == null) {
            composite = AlphaComposite.getInstance(3, opacity);
        }
        LineStyle2D style = new LineStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        if (!this.setMarkAlongLineStroke(style, symbolizer, (Feature)feature)) {
            style.setGraphicStroke(this.getGraphicStroke(symbolizer, symbolizer.getStroke(), feature, scaleRange));
        }
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(composite);
        style.setPerpendicularOffset(this.evalToDouble(symbolizer.getPerpendicularOffset(), feature, 0.0));
        return style;
    }

    Style2D createDynamicLineStyle(SimpleFeature feature, LineSymbolizer symbolizer, Range scaleRange) {
        DynamicLineStyle2D style = new DynamicLineStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createPointStyle(Object feature, PointSymbolizer symbolizer, Range scaleRange) {
        return this.createPointStyle(feature, symbolizer, symbolizer.getGraphic(), scaleRange, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Style2D createPointStyle(Object feature, Symbolizer symbolizer, Graphic sldGraphic, Range scaleRange, boolean forceVector) {
        void var6_13;
        void var6_11;
        Object var6_6 = null;
        float opacity = this.evalOpacity(sldGraphic.getOpacity(), feature);
        Composite composite = SLDStyleFactory.getComposite(symbolizer.getOptions(), opacity);
        if (composite == null) {
            composite = AlphaComposite.getInstance(3, opacity);
        }
        float displacementX = 0.0f;
        float displacementY = 0.0f;
        Displacement displacement = sldGraphic.getDisplacement();
        if (displacement != null) {
            displacementX = this.evalToFloat(displacement.getDisplacementX(), feature, 0.0f);
            displacementY = this.evalToFloat(displacement.getDisplacementY(), feature, 0.0f);
        }
        float anchorPointX = 0.5f;
        float anchorPointY = 0.5f;
        AnchorPoint anchorPoint = sldGraphic.getAnchorPoint();
        if (anchorPoint != null) {
            anchorPointX = this.evalToFloat(anchorPoint.getAnchorPointX(), feature, 0.5f);
            anchorPointY = this.evalToFloat(anchorPoint.getAnchorPointY(), feature, 0.5f);
        }
        double size = 0.0;
        try {
            if (sldGraphic.getSize() != null && !Expression.NIL.equals(sldGraphic.getSize())) {
                size = this.evalToDouble(sldGraphic.getSize(), feature, 0.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float rotation = (float)Math.toRadians(this.evalToDouble(sldGraphic.getRotation(), feature, 0.0));
        List<GraphicalSymbol> symbols = sldGraphic.graphicalSymbols();
        if (symbols == null || symbols.isEmpty()) {
            return null;
        }
        for (GraphicalSymbol symbol : symbols) {
            block21: {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("trying to render symbol " + symbol);
                }
                if (symbol instanceof ExternalGraphic) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("rendering External graphic");
                    }
                    ExternalGraphic eg = (ExternalGraphic)symbol;
                    if (this.vectorRenderingEnabled || forceVector || size > 512.0) {
                        Icon icon = this.getIcon(eg, feature, -1.0);
                        if (icon == null) continue;
                        if (icon instanceof ImageIcon) {
                            GraphicStyle2D g2d = this.getGraphicStyle(eg, feature, size, 1);
                            if (g2d != null) {
                                g2d.setRotation(rotation);
                                GraphicStyle2D graphicStyle2D = g2d;
                                break;
                            }
                            break block21;
                        } else {
                            if ((double)icon.getIconHeight() != size && size != 0.0) {
                                double scale = size / (double)icon.getIconHeight();
                                icon = new RescaledIcon(icon, scale);
                            }
                            IconStyle2D iconStyle2D = new IconStyle2D(icon, feature);
                            break;
                        }
                    }
                    GraphicStyle2D g2d = this.getGraphicStyle(eg, feature, size, 1);
                    if (g2d != null) {
                        g2d.setRotation(rotation);
                        GraphicStyle2D graphicStyle2D = g2d;
                        break;
                    }
                }
            }
            if (!(symbol instanceof Mark)) continue;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("rendering mark @ PointRenderer " + symbol.toString());
            }
            MarkStyle2D markStyle2D = this.createMarkStyle((Mark)symbol, feature, symbolizer, size);
            break;
        }
        if (var6_11 == null) {
            if (!this.voParser.getBooleanOption(symbolizer, "fallbackOnDefaultMark", true)) {
                return null;
            }
            StyleFactory sf = CommonFactoryFinder.getStyleFactory();
            Mark defaultMark = sf.mark((Expression)ff.literal((Object)"square"), (org.opengis.style.Fill)sf.fill(null, (Expression)ff.literal((Object)"#808080"), null), (org.opengis.style.Stroke)sf.createStroke((Expression)ff.literal((Object)"#000000"), (Expression)ff.literal(1)));
            if (size <= 0.0) {
                size = 6.0;
            }
            MarkStyle2D markStyle2D = this.createMarkStyle(defaultMark, feature, symbolizer, size);
        }
        this.setScaleRange((Style)var6_13, scaleRange);
        PointStyle2D ps = (PointStyle2D)var6_13;
        ps.setDisplacementX(displacementX);
        ps.setDisplacementY(displacementY);
        ps.setAnchorPointX(anchorPointX);
        ps.setAnchorPointY(anchorPointY);
        ps.setRotation(rotation);
        ps.setComposite(composite);
        return var6_13;
    }

    MarkStyle2D createMarkStyle(Mark mark, Object feature, Symbolizer symbolizer, double size) {
        Shape shape = this.getShape(mark, feature);
        if (shape == null) {
            throw new IllegalArgumentException("The specified mark " + mark.getWellKnownName() + " was not found!");
        }
        Composite composite = SLDStyleFactory.getComposite(symbolizer.getOptions());
        MarkStyle2D ms2d = new MarkStyle2D();
        ms2d.setShape(shape);
        ms2d.setFill(this.getPaint(mark.getFill(), feature, symbolizer));
        ms2d.setFillComposite(composite != null ? composite : this.getComposite(mark.getFill(), feature));
        ms2d.setStroke(this.getStroke(mark.getStroke(), feature));
        ms2d.setContour(this.getStrokePaint(mark.getStroke(), feature));
        ms2d.setContourComposite(composite != null ? composite : this.getStrokeComposite(mark.getStroke(), feature));
        if (size <= 0.0) {
            size = 16.0;
        }
        ms2d.setSize(size);
        return ms2d;
    }

    int toImageSize(double size) {
        if (size == -1.0) {
            return -1;
        }
        if (size > 0.0 && size < 0.5) {
            return 1;
        }
        return (int)Math.round(size);
    }

    Style2D createTextStyle(Object feature, TextSymbolizer symbolizer, Range scaleRange) {
        LabelPlacement p;
        TextStyle2D ts2d = new TextStyle2D();
        this.setScaleRange(ts2d, scaleRange);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("creating text style");
        }
        String geomName = symbolizer.getGeometryPropertyName();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("geomName = " + geomName);
        }
        String label = this.evalToString(symbolizer.getLabel(), feature, "");
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("label is " + label);
        }
        ts2d.setLabel(label);
        List<Font> fonts = symbolizer.fonts();
        java.awt.Font[] javaFonts = this.getFonts(feature, fonts, symbolizer);
        ts2d.setFonts(javaFonts);
        LabelPlacement placement = symbolizer.getLabelPlacement();
        double anchorX = (Double)PointPlacement.DEFAULT_ANCHOR_POINT.getAnchorPointX().evaluate(null, Double.class);
        double anchorY = (Double)PointPlacement.DEFAULT_ANCHOR_POINT.getAnchorPointY().evaluate(null, Double.class);
        double rotation = 0.0;
        double dispX = 0.0;
        double dispY = 0.0;
        if (Boolean.getBoolean(USE_LEGACY_ANCHOR_POINT_KEY)) {
            anchorX = 0.0;
            anchorY = 0.0;
        }
        if (placement instanceof PointPlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            if ((p = (PointPlacement)placement).getAnchorPoint() != null) {
                anchorX = this.evalToDouble(p.getAnchorPoint().getAnchorPointX(), feature, anchorX);
                anchorY = this.evalToDouble(p.getAnchorPoint().getAnchorPointY(), feature, anchorY);
            }
            if (p.getDisplacement() != null) {
                dispX = this.evalToDouble(p.getDisplacement().getDisplacementX(), feature, 0.0);
                dispY = this.evalToDouble(p.getDisplacement().getDisplacementY(), feature, 0.0);
            }
            rotation = symbolizer instanceof TextSymbolizer2 && ((TextSymbolizer2)symbolizer).getGraphic() != null ? 0.0 : Math.toRadians(this.evalToDouble(p.getRotation(), feature, 0.0));
            ts2d.setPointPlacement(true);
        } else if (placement instanceof LinePlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            ts2d.setPointPlacement(false);
            p = (LinePlacement)placement;
            int displace = this.evalToInt(p.getPerpendicularOffset(), feature, 0);
            ts2d.setPerpendicularOffset(displace);
        }
        ts2d.setAnchorX(anchorX);
        ts2d.setAnchorY(anchorY);
        ts2d.setRotation((float)rotation);
        ts2d.setDisplacementX(dispX);
        ts2d.setDisplacementY(dispY);
        ts2d.setFill(this.getPaint(symbolizer.getFill(), feature, symbolizer));
        ts2d.setComposite(this.getComposite(symbolizer.getFill(), feature));
        Halo halo = symbolizer.getHalo();
        if (halo != null) {
            ts2d.setHaloFill(this.getPaint(halo.getFill(), feature, symbolizer));
            ts2d.setHaloComposite(this.getComposite(halo.getFill(), feature));
            ts2d.setHaloRadius(this.evalToFloat(halo.getRadius(), feature, 1.0f));
        }
        Graphic graphicShield = null;
        if (symbolizer instanceof TextSymbolizer2 && (graphicShield = ((TextSymbolizer2)symbolizer).getGraphic()) != null) {
            Style2D shieldStyle = this.createPointStyle(feature, symbolizer, graphicShield, scaleRange, true);
            ts2d.setGraphic(shieldStyle);
        }
        return ts2d;
    }

    private java.awt.Font[] getFonts(Object feature, List<Font> fonts, TextSymbolizer symbolizer) {
        ArrayList<java.awt.Font> result = new ArrayList<java.awt.Font>();
        if (fonts != null) {
            for (Font curr : fonts) {
                for (Expression family : curr.getFamily()) {
                    List fontNames = this.evalToList(family, feature, null);
                    if (fontNames != null) {
                        for (String fontName : fontNames) {
                            this.collectFont(feature, symbolizer, result, curr, fontName);
                        }
                        continue;
                    }
                    String requestedFont = this.evalToString(family, feature, null);
                    this.collectFont(feature, symbolizer, result, curr, requestedFont);
                }
            }
        }
        if (result.isEmpty()) {
            java.awt.Font font = new java.awt.Font("Serif", 0, 12);
            font = fonts != null && !fonts.isEmpty() ? this.styleFont(feature, fonts.get(0), font, symbolizer) : this.applyKerning(font);
            result.add(font);
        }
        return result.toArray(new java.awt.Font[result.size()]);
    }

    private void collectFont(Object feature, TextSymbolizer symbolizer, List<java.awt.Font> result, Font curr, String requestedFont) {
        java.awt.Font javaFont = FontCache.getDefaultInstance().getFont(requestedFont);
        if (javaFont != null) {
            java.awt.Font font = this.styleFont(feature, curr, javaFont, symbolizer);
            result.add(font);
        }
    }

    private java.awt.Font applyKerning(java.awt.Font font) {
        return font.deriveFont(Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON));
    }

    private java.awt.Font applySpacing(java.awt.Font font, double spacing) {
        double tracking = spacing / (double)font.getSize();
        return font.deriveFont(Collections.singletonMap(TextAttribute.TRACKING, tracking));
    }

    private java.awt.Font styleFont(Object feature, Font curr, java.awt.Font javaFont, TextSymbolizer symbolizer) {
        double spacing;
        String reqStyle = this.evalToString(curr.getStyle(), feature, null);
        int styleCode = FONT_STYLE_LOOKUP.containsKey(reqStyle) ? (Integer)FONT_STYLE_LOOKUP.get(reqStyle) : 0;
        String reqWeight = this.evalToString(curr.getWeight(), feature, null);
        if ("Bold".equalsIgnoreCase(reqWeight)) {
            styleCode |= 1;
        }
        float size = this.evalToFloat(curr.getSize(), feature, 10.0f);
        javaFont = javaFont.deriveFont(styleCode, size);
        boolean kerning = this.voParser.getBooleanOption(symbolizer, "kerning", true);
        if (kerning) {
            javaFont = this.applyKerning(javaFont);
        }
        if ((spacing = this.voParser.getDoubleOption(symbolizer, "charSpacing", 0.0)) != 0.0) {
            javaFont = this.applySpacing(javaFont, spacing);
        }
        return javaFont;
    }

    void setScaleRange(Style style, Range scaleRange) {
        if (scaleRange != null) {
            double min = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
            double max = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
            style.setMinMaxScale(min, max);
        }
    }

    private Style2D getGraphicStroke(Symbolizer symbolizer, org.geotools.styling.Stroke stroke, Object feature, Range scaleRange) {
        if (stroke == null || stroke.getGraphicStroke() == null) {
            return null;
        }
        return this.createPointStyle(feature, symbolizer, stroke.getGraphicStroke(), scaleRange, false);
    }

    Stroke getStroke(org.geotools.styling.Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        String joinType = this.evalToString(stroke.getLineJoin(), feature, "miter");
        int joinCode = JOIN_LOOKUP.containsKey(joinType) ? (Integer)JOIN_LOOKUP.get(joinType) : 0;
        String capType = this.evalToString(stroke.getLineCap(), feature, "square");
        int capCode = CAP_LOOKUP.containsKey(capType) ? (Integer)CAP_LOOKUP.get(capType) : 2;
        float[] dashes = SLDStyleFactory.evaluateDashArray(stroke, feature);
        float width = this.evalToFloat(stroke.getWidth(), feature, 1.0f);
        float dashOffset = this.evalToFloat(stroke.getDashOffset(), feature, 0.0f);
        if ((double)width < 1.5 && this.lineOptimizationEnabled) {
            width = 0.0f;
        }
        BasicStroke stroke2d = dashes != null && dashes.length > 0 && !this.allZeroes(dashes) ? new BasicStroke(width, capCode, joinCode, 1.75f, dashes, dashOffset) : new BasicStroke(width, capCode, joinCode, 1.75f);
        return stroke2d;
    }

    private boolean allZeroes(float[] dashes) {
        for (float dash : dashes) {
            if (dash == 0.0f) continue;
            return false;
        }
        return true;
    }

    public static float[] evaluateDashArray(org.geotools.styling.Stroke stroke, Object feature) throws NumberFormatException {
        if (stroke.dashArray() != null && !stroke.dashArray().isEmpty()) {
            ArrayList<Float> dashArrayValues = new ArrayList<Float>();
            for (Expression expression : stroke.dashArray()) {
                dashArrayValues.addAll(SLDStyleFactory.dashArrayExpressionToFloatList(expression, feature));
            }
            float[] dashArray = new float[dashArrayValues.size()];
            for (int i = 0; i < dashArray.length; ++i) {
                dashArray[i] = ((Float)dashArrayValues.get(i)).floatValue();
            }
            return dashArray;
        }
        return null;
    }

    private static List<Float> dashArrayExpressionToFloatList(Expression expression, Object feature) {
        String dashString = (String)expression.evaluate(feature, String.class);
        if (dashString == null || dashString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Float> dashValues = new ArrayList<Float>();
        for (String dashItem : WHITE_SPACE_SPLIT.split(dashString)) {
            dashValues.add(Float.valueOf(Float.parseFloat(dashItem)));
        }
        return dashValues;
    }

    private Paint getStrokePaint(org.geotools.styling.Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        Paint contourPaint = this.evalToColor(stroke.getColor(), feature, Color.BLACK);
        Graphic gr = stroke.getGraphicFill();
        if (gr != null && gr.graphicalSymbols() != null && gr.graphicalSymbols().size() > 0) {
            contourPaint = this.getTexturePaint(gr, feature, null);
        }
        return contourPaint;
    }

    private Composite getStrokeComposite(org.geotools.styling.Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        float opacity = this.evalOpacity(stroke.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    public Paint getPaint(Fill fill, Object feature, Symbolizer symbolizer) {
        if (fill == null) {
            return null;
        }
        Paint fillPaint = this.evalToColor(fill.getColor(), feature, null);
        Graphic gr = fill.getGraphicFill();
        if (gr != null && gr.graphicalSymbols() != null && gr.graphicalSymbols().size() > 0) {
            fillPaint = this.getTexturePaint(gr, feature, symbolizer);
        }
        return fillPaint;
    }

    public Composite getComposite(Fill fill, Object feature) {
        if (fill == null) {
            return null;
        }
        float opacity = this.evalOpacity(fill.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    TexturePaint getTexturePaint(Graphic gr, Object feature, Symbolizer symbolizer) {
        BufferedImage image;
        double graphicSize = this.evalToDouble(gr.getSize(), feature, -1.0);
        Icon icon = null;
        Mark mark = null;
        Shape shape = null;
        for (GraphicalSymbol symbol : gr.graphicalSymbols()) {
            ExternalGraphic eg;
            if (symbol instanceof ExternalGraphic ? (icon = this.getIcon(eg = (ExternalGraphic)symbol, feature, graphicSize)) != null : symbol instanceof Mark && (shape = this.getShape(mark = (Mark)symbol, feature)) != null) break;
        }
        if (icon == null && shape == null) {
            return null;
        }
        RandomFillBuilder.PositionRandomizer randomizer = (RandomFillBuilder.PositionRandomizer)this.voParser.getEnumOption(symbolizer, "random", RandomFillBuilder.PositionRandomizer.NONE);
        if (randomizer != null && randomizer != RandomFillBuilder.PositionRandomizer.NONE) {
            image = this.randomFillBuilder.buildRandomTilableImage(symbolizer, gr, icon, mark, shape, graphicSize, feature);
        } else {
            int[] margin = this.voParser.getGraphicMargin(symbolizer, "graphic-margin");
            GraphicStyle2D gs = this.getGraphicStyle(icon, 1);
            if (gs != null) {
                image = gs.getImage();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("got an image in graphic fill");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("going for the mark from graphic fill");
                }
                image = this.markToTilableImage(gr, feature, mark, shape);
            }
            if (margin != null) {
                int extraY = margin[0] + margin[2];
                int extraX = margin[1] + margin[3];
                int type = image.getType() == 0 ? 6 : image.getType();
                BufferedImage imageWithMargin = new BufferedImage(image.getWidth() + extraX, image.getHeight() + extraY, type);
                int tx = margin[1];
                int ty = margin[0];
                AffineTransform at = AffineTransform.getTranslateInstance(tx, ty);
                Graphics2D graphics = imageWithMargin.createGraphics();
                graphics.drawRenderedImage(image, at);
                graphics.dispose();
                image = imageWithMargin;
            }
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
        TexturePaint imagePaint = new TexturePaint(image, rect);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("applied TexturePaint " + imagePaint);
        }
        return imagePaint;
    }

    private BufferedImage markToTilableImage(Graphic gr, Object feature, Mark mark, Shape shape) {
        double sizeY;
        int repeat;
        Rectangle2D shapeBounds = shape.getBounds2D();
        double shapeAspectRatio = shapeBounds.getHeight() > 0.0 && shapeBounds.getWidth() > 0.0 ? shapeBounds.getWidth() / shapeBounds.getHeight() : 1.0;
        double size = this.evalToDouble(gr.getSize(), feature, 16.0);
        double sizeX = size * shapeAspectRatio;
        if (sizeX * (double)(repeat = 3) * ((sizeY = size) * (double)repeat) > 2.147483647E9) {
            LOGGER.warning("Size of graphic (" + sizeX + " * " + sizeY + ") is too large");
            if (sizeX * sizeY > 2.147483647E9) {
                LOGGER.severe("Size of graphic (" + sizeX + " * " + sizeY + ") is too large will not draw");
                return new BufferedImage(10, 10, 2);
            }
            LOGGER.fine("Size of metatiled graphic (" + (double)repeat * sizeX + " * " + (double)repeat * sizeY + ") is too large, not metatiling it");
            repeat = 1;
        }
        BufferedImage image = new BufferedImage((int)Math.ceil(sizeX * (double)repeat), (int)Math.ceil(sizeY * (double)repeat), 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHints(this.renderingHints);
        double rotation = Math.toRadians(this.evalToDouble(gr.getRotation(), feature, 0.0));
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                double tx = sizeX * ((double)repeat / 2.0) + sizeX * (double)i;
                double ty = sizeY * ((double)repeat / 2.0) + sizeY * (double)j;
                this.fillDrawMark(g2d, tx, ty, mark, size, rotation, feature);
            }
        }
        g2d.dispose();
        int iSizeX = (int)Math.floor(sizeX);
        int iSizeY = (int)Math.floor(sizeY);
        image = image.getSubimage(iSizeX, iSizeY, Math.max(iSizeX, 1), Math.max(iSizeY, 1));
        return image;
    }

    private GraphicStyle2D getGraphicStyle(ExternalGraphic eg, Object feature, double size, int border) {
        Icon icon = this.getIcon(eg, feature, this.toImageSize(size));
        return this.getGraphicStyle(icon, border);
    }

    private GraphicStyle2D getGraphicStyle(Icon icon, int border) {
        ImageIcon img;
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon && (img = (ImageIcon)icon).getImage() instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)img.getImage();
            return new GraphicStyle2D(image, 0.0f, 0);
        }
        BufferedImage result = new BufferedImage(icon.getIconWidth() + border * 2, icon.getIconHeight() + border * 2, 6);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setRenderingHints(this.renderingHints);
        icon.paintIcon(null, g, 1, 1);
        g.dispose();
        return new GraphicStyle2D(result, 0.0f, border);
    }

    private Icon getIcon(ExternalGraphic eg, Object feature, double size) {
        Expression location;
        String strLocation;
        if (eg == null) {
            return null;
        }
        Icon inlineContent = eg.getInlineContent();
        if (inlineContent != null) {
            return inlineContent;
        }
        try {
            strLocation = eg.getLocation().toExternalForm();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.INFO, "Malformed URL processing external graphic", e);
            return null;
        }
        try {
            location = ExpressionExtractor.extractCqlExpressions(strLocation);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not parse cql expressions out of " + strLocation, e);
            }
            location = ff.literal((Object)strLocation);
        }
        Iterator<ExternalGraphicFactory> it = DynamicSymbolFactoryFinder.getExternalGraphicFactories(new Hints(this.renderingHints));
        while (it.hasNext()) {
            ExternalGraphicFactory egf = it.next();
            try {
                Icon icon;
                String format = null;
                if (eg.getFormat() != null) {
                    Expression formatExpression = ExpressionExtractor.extractCqlExpressions(eg.getFormat());
                    format = (String)formatExpression.evaluate(feature, String.class);
                }
                if ((icon = egf.getIcon((Feature)feature, location, format, this.toImageSize(size))) == null) continue;
                return icon;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
            }
        }
        return null;
    }

    private Shape getShape(Mark mark, Object feature) {
        String expression;
        Shape shape;
        if (mark == null) {
            return null;
        }
        if (mark.getExternalMark() != null && (shape = TTFMarkFactory.INSTANCE.getShape(mark.getExternalMark())) != null) {
            return shape;
        }
        Expression name = mark.getWellKnownName();
        if (name instanceof Literal && (expression = this.evalToString(name, null, null)) != null) {
            name = ExpressionExtractor.extractCqlExpressions(expression);
        }
        Iterator<MarkFactory> it = DynamicSymbolFactoryFinder.getMarkFactories();
        while (it.hasNext()) {
            MarkFactory factory = it.next();
            try {
                Shape shape2 = factory.getShape(null, name, (Feature)feature);
                if (shape2 == null) continue;
                return shape2;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception while scanning for the appropriate mark factory", e);
            }
        }
        return null;
    }

    void fillDrawMark(Graphics2D g2d, double tx, double ty, Mark mark, double size, double rotation, Object feature) {
        if (mark == null) {
            return;
        }
        Shape originalShape = this.getShape(mark, feature);
        AffineTransform markAT = new AffineTransform();
        markAT.translate(tx, ty);
        markAT.rotate(rotation);
        markAT.scale(size, -size);
        Shape shape = markAT.createTransformedShape(originalShape);
        g2d.setRenderingHints(this.renderingHints);
        if (mark.getFill() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying fill to mark");
            }
            g2d.setPaint(this.getPaint(mark.getFill(), feature, null));
            g2d.setComposite(this.getComposite(mark.getFill(), feature));
            g2d.fill(shape);
        }
        if (mark.getStroke() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying stroke to mark");
            }
            g2d.setPaint(this.getStrokePaint(mark.getStroke(), feature));
            g2d.setComposite(this.getStrokeComposite(mark.getStroke(), feature));
            g2d.setStroke(this.getStroke(mark.getStroke(), feature));
            g2d.draw(shape);
        }
    }

    public static int lookUpJoin(String joinType) {
        if (JOIN_LOOKUP.containsKey(joinType)) {
            return (Integer)JOIN_LOOKUP.get(joinType);
        }
        return 0;
    }

    public static int lookUpCap(String capType) {
        if (CAP_LOOKUP.containsKey(capType)) {
            return (Integer)CAP_LOOKUP.get(capType);
        }
        return 2;
    }

    public static Composite getComposite(Map<String, String> options) {
        return SLDStyleFactory.getComposite(options, 1.0f);
    }

    public static Composite getComposite(Map<String, String> options, float defaultOpacity) {
        String name;
        String spec = options.get("composite");
        if (spec == null) {
            return null;
        }
        float opacity = defaultOpacity;
        if (spec.indexOf(44) != -1) {
            String[] split = spec.split("\\s*,\\s*");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid syntax for composite key, expecting 'name' or 'name,opacity' but got " + spec);
            }
            name = split[0].trim();
            boolean invalidOpacity = false;
            try {
                opacity = Float.parseFloat(split[1]);
            }
            catch (NumberFormatException e) {
                invalidOpacity = true;
            }
            if (invalidOpacity || opacity < 0.0f || opacity > 1.0f) {
                throw new IllegalArgumentException("Invalid value for composite opacity, expecting a number between 0 and 1, but got '" + split[1] + "' instead");
            }
        } else {
            name = spec;
        }
        if (ALPHA_COMPOSITE_LOOKUP.containsKey(name)) {
            Integer rule = ALPHA_COMPOSITE_LOOKUP.get(name);
            return AlphaComposite.getInstance(rule, opacity);
        }
        BlendComposite.BlendingMode blend = BlendComposite.BlendingMode.lookupByName(name);
        if (blend == null) {
            throw new IllegalArgumentException("Invalid composite name, not part of the supported alpha composite ones " + ALPHA_COMPOSITE_LOOKUP.keySet() + ", nor the blending ones " + BlendComposite.BlendingMode.getStandardNames());
        }
        return BlendComposite.getInstance(blend, opacity);
    }

    public static SortBy[] getSortBy(Map<String, String> options) {
        String[] attributeSpecs;
        String sortBySpec = options.get("sortBy");
        if (sortBySpec == null) {
            return null;
        }
        ArrayList<SortBy> result = new ArrayList<SortBy>();
        for (String attributeSpec : attributeSpecs = sortBySpec.split("\\s*,\\s*")) {
            String[] items = attributeSpec.split("\\s+");
            if (items.length < 1 || items.length > 2) {
                throw new IllegalArgumentException("Invalid sortBy specification, it should be either in the form 'attribute' or 'attribute direction' but instead it is: '" + attributeSpec + "'");
            }
            String attribute = items[0];
            SortOrder order = SortOrder.ASCENDING;
            if (items.length == 2) {
                String direction = items[1];
                if ("D".equalsIgnoreCase(direction) || "DESC".equalsIgnoreCase(direction)) {
                    order = SortOrder.DESCENDING;
                } else if (!"A".equalsIgnoreCase(direction) || "ASC".equalsIgnoreCase(direction)) {
                    throw new IllegalArgumentException("Unknown sort order '" + direction + "' in: '" + attributeSpec + "'");
                }
            }
            SortBy sort = ff.sort(attribute, order);
            result.add(sort);
        }
        return result.toArray(new SortBy[result.size()]);
    }

    public double getMapScaleDenominator() {
        return this.mapScaleDenominator;
    }

    public void setMapScaleDenominator(double mapScaleDenominator) {
        this.mapScaleDenominator = mapScaleDenominator;
    }

    private <T> List<T> evalToList(Expression exp, Object f, List<T> fallback) {
        if (exp == null) {
            return fallback;
        }
        List l = (List)exp.evaluate(f, List.class);
        if (l != null) {
            return l;
        }
        return fallback;
    }

    private String evalToString(Expression exp, Object f, String fallback) {
        if (exp == null) {
            return fallback;
        }
        String s = (String)exp.evaluate(f, String.class);
        if (s != null) {
            return s;
        }
        return fallback;
    }

    private float evalToFloat(Expression exp, Object f, float fallback) {
        if (exp == null) {
            return fallback;
        }
        Float fo = (Float)exp.evaluate(f, Float.class);
        if (fo != null) {
            return fo.floatValue();
        }
        return fallback;
    }

    private double evalToDouble(Expression exp, Object f, double fallback) {
        if (exp == null) {
            return fallback;
        }
        Double d = (Double)exp.evaluate(f, Double.class);
        if (d != null && !Double.isNaN(d)) {
            return d;
        }
        return fallback;
    }

    private int evalToInt(Expression exp, Object f, int fallback) {
        if (exp == null) {
            return fallback;
        }
        Integer i = (Integer)exp.evaluate(f, Integer.class);
        if (i != null) {
            return i;
        }
        return fallback;
    }

    private Color evalToColor(Expression exp, Object f, Color fallback) {
        if (exp == null) {
            return fallback;
        }
        Color color = (Color)exp.evaluate(f, Color.class);
        if (color != null) {
            return color;
        }
        return fallback;
    }

    private float evalOpacity(Expression e, Object f) {
        return this.evalToFloat(e, f, 1.0f);
    }

    private boolean setMarkAlongLineStroke(LineStyle2D style, LineSymbolizer symbolizer, Feature feature) {
        if (!Boolean.parseBoolean(symbolizer.getOptions().getOrDefault("markAlongLine", "false"))) {
            return false;
        }
        org.geotools.styling.Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return false;
        }
        if (stroke.getGraphicStroke() == null) {
            return false;
        }
        if (stroke.getGraphicStroke().graphicalSymbols().isEmpty()) {
            return false;
        }
        if (!(stroke.getGraphicStroke().graphicalSymbols().get(0) instanceof Mark)) {
            return false;
        }
        MarkImpl mark = (MarkImpl)stroke.getGraphicStroke().graphicalSymbols().get(0);
        if (mark.getWellKnownName() == null) {
            return false;
        }
        Iterator<MarkFactory> it = DynamicSymbolFactoryFinder.getMarkFactories();
        Shape shape = null;
        while (it.hasNext()) {
            MarkFactory factory = it.next();
            try {
                shape = factory.getShape(null, mark.getWellKnownName(), feature);
                if (shape == null) continue;
                break;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception while scanning for the appropriate mark factory", e);
            }
        }
        double size = (Double)stroke.getGraphicStroke().getSize().evaluate(null, Double.class);
        MarkAlongLine markAlongLine = new MarkAlongLine(style.getStroke(), size, JTS.toGeometry(shape));
        if (symbolizer.getOptions().containsKey("markAlongLineScaleLimit")) {
            markAlongLine.setScaleImit(Float.parseFloat((String)symbolizer.getOptions().get("markAlongLineScaleLimit")));
        }
        if (symbolizer.getOptions().containsKey("markAlongLineSimplify")) {
            markAlongLine.setSimplicationFactor(Float.parseFloat((String)symbolizer.getOptions().get("markAlongLineSimplify")));
        }
        style.setStroke(markAlongLine);
        return true;
    }

    static {
        JOIN_LOOKUP.put("miter", 0);
        JOIN_LOOKUP.put("bevel", 2);
        JOIN_LOOKUP.put("round", 1);
        CAP_LOOKUP.put("butt", 0);
        CAP_LOOKUP.put("round", 1);
        CAP_LOOKUP.put("square", 2);
        FONT_STYLE_LOOKUP.put("normal", 0);
        FONT_STYLE_LOOKUP.put("italic", 2);
        FONT_STYLE_LOOKUP.put("oblique", 2);
        FONT_STYLE_LOOKUP.put("bold", 1);
        ALPHA_COMPOSITE_LOOKUP.put("copy", 2);
        ALPHA_COMPOSITE_LOOKUP.put("destination", 9);
        ALPHA_COMPOSITE_LOOKUP.put("source-over", 3);
        ALPHA_COMPOSITE_LOOKUP.put("destination-over", 4);
        ALPHA_COMPOSITE_LOOKUP.put("source-in", 5);
        ALPHA_COMPOSITE_LOOKUP.put("destination-in", 6);
        ALPHA_COMPOSITE_LOOKUP.put("source-out", 7);
        ALPHA_COMPOSITE_LOOKUP.put("destination-out", 8);
        ALPHA_COMPOSITE_LOOKUP.put("source-atop", 10);
        ALPHA_COMPOSITE_LOOKUP.put("destination-atop", 11);
        ALPHA_COMPOSITE_LOOKUP.put("xor", 12);
        WHITE_SPACE_SPLIT = Pattern.compile("\\s+");
    }

    static class SymbolizerKey {
        private Symbolizer symbolizer;
        private double minScale;
        private double maxScale;

        public SymbolizerKey(Symbolizer symbolizer, Range scaleRange) {
            this.symbolizer = symbolizer;
            if (scaleRange == null) {
                this.minScale = 0.0;
                this.maxScale = Double.POSITIVE_INFINITY;
            } else {
                this.minScale = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
                this.maxScale = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SymbolizerKey)) {
                return false;
            }
            SymbolizerKey other = (SymbolizerKey)obj;
            return other.symbolizer == this.symbolizer && other.minScale == this.minScale && other.maxScale == this.maxScale;
        }

        public int hashCode() {
            return ((17 + System.identityHashCode(this.symbolizer)) * 37 + this.doubleHash(this.minScale)) * 37 + this.doubleHash(this.maxScale);
        }

        private int doubleHash(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }
    }
}

