/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;

public class VendorOptionParser {
    static final Pattern SPACES = Pattern.compile("\\s+");

    public <T extends Enum<T>> Enum<T> getEnumOption(Symbolizer symbolizer, String optionName, Enum<T> defaultValue) {
        String value = this.getOption(symbolizer, optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            T enumValue = Enum.valueOf(defaultValue.getDeclaringClass(), value.toUpperCase());
            return enumValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String getOption(Symbolizer symbolizer, String optionName) {
        if (symbolizer == null) {
            return null;
        }
        Map<String, String> options = symbolizer.getOptions();
        if (options == null) {
            return null;
        }
        return options.get(optionName);
    }

    public int getIntOption(Symbolizer symbolizer, String optionName, int defaultValue) {
        String value = this.getOption(symbolizer, optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDoubleOption(Symbolizer symbolizer, String optionName, double defaultValue) {
        String value = this.getOption(symbolizer, optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBooleanOption(Symbolizer symbolizer, String optionName, boolean defaultValue) {
        String value = this.getOption(symbolizer, optionName);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    public int[] getGraphicMargin(Symbolizer symbolizer, String optionName) {
        String value = this.getOption(symbolizer, optionName);
        if (value == null) {
            return null;
        }
        String[] values = SPACES.split(value.trim());
        if (values.length == 0) {
            return null;
        }
        if (values.length > 4) {
            throw new IllegalArgumentException("The graphic margin is to be specified with 1, 2 or 4 values");
        }
        int[] parsed = new int[values.length];
        boolean allZeroMargin = false;
        for (int i = 0; i < parsed.length; ++i) {
            int margin = Integer.parseInt(values[i]);
            allZeroMargin = allZeroMargin && margin == 0;
            parsed[i] = margin;
        }
        if (allZeroMargin) {
            return null;
        }
        if (parsed.length == 4) {
            return parsed;
        }
        if (parsed.length == 3) {
            return new int[]{parsed[0], parsed[1], parsed[2], parsed[1]};
        }
        if (parsed.length == 2) {
            return new int[]{parsed[0], parsed[1], parsed[0], parsed[1]};
        }
        return new int[]{parsed[0], parsed[0], parsed[0], parsed[0]};
    }

    public int[] getDisplacementAngles(Symbolizer symbolizer, String optionName) {
        String value = this.getOption(symbolizer, optionName);
        if (value == null) {
            return null;
        }
        String[] values = value.trim().split(",");
        if (values.length == 0) {
            return null;
        }
        int[] parsed = new int[values.length];
        for (int i = 0; i < parsed.length; ++i) {
            try {
                TextSymbolizer.DisplacementMode mode = TextSymbolizer.DisplacementMode.valueOf(values[i].trim().toUpperCase());
                parsed[i] = mode.getAngle();
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(values[i] + " is not legal. The values of displacement mode must be one of the following: " + Arrays.toString((Object[])TextSymbolizer.DisplacementMode.values()));
            }
        }
        return parsed;
    }
}

