/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.FaultyNode;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.InlineContent;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SingleImportSolver {
    private final ProblemsHandler problemsHandler;
    private final LessCompiler.Configuration configuration;
    private TypesConversionUtils conversionUtils = new TypesConversionUtils();
    private ASTManipulator astManipulator = new ASTManipulator();
    private Set<LessSource> importedSources = new HashSet<LessSource>();

    public SingleImportSolver(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
    }

    public void solveImports(StyleSheet node, LessSource source) {
        this.doSolveImports(node, source);
    }

    private void doSolveImports(StyleSheet node, LessSource source) {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode kid : childs) {
            if (kid.getType() != ASTCssNodeType.IMPORT) continue;
            this.importEncountered((Import)kid, source);
        }
    }

    public ASTCssNode importEncountered(Import node, LessSource source) {
        String importedContent;
        LessSource importedSource;
        String filename = this.conversionUtils.extractFilename(node.getUrlExpression(), this.problemsHandler, this.configuration);
        if (filename == null) {
            this.problemsHandler.errorWrongImport(node.getUrlExpression());
            return null;
        }
        String urlParams = "";
        int paramsIndx = filename.lastIndexOf("?");
        if (paramsIndx != -1) {
            urlParams = filename.substring(paramsIndx);
            filename = filename.substring(0, paramsIndx);
        }
        if (this.treatAsCss(node, filename)) {
            return null;
        }
        filename = this.addLessSuffixIfNeeded(filename, urlParams);
        try {
            importedSource = source.relativeSource(filename);
        }
        catch (LessSource.FileNotFound ex) {
            this.problemsHandler.errorFileNotFound(node, filename);
            return null;
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorFileCanNotBeRead(node, filename);
            return null;
        }
        catch (LessSource.StringSourceException ex) {
            this.problemsHandler.warnLessImportNoBaseDirectory(node.getUrlExpression());
            return null;
        }
        if (this.isImportOnce(node) && this.alreadyVisited(importedSource)) {
            this.astManipulator.removeFromBody(node);
            return null;
        }
        this.importedSources.add(importedSource);
        try {
            importedContent = importedSource.getContent();
        }
        catch (LessSource.FileNotFound e) {
            this.problemsHandler.errorFileNotFound(node, filename);
            return null;
        }
        catch (LessSource.CannotReadFile e) {
            this.problemsHandler.errorFileCanNotBeRead(node, filename);
            return null;
        }
        if (node.isInline()) {
            HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
            StyleSheet result = new StyleSheet(underlyingStructure);
            InlineContent content = new InlineContent(underlyingStructure, importedContent);
            result.addMember(content);
            result.configureParentToAllChilds();
            this.astManipulator.replaceInBody((ASTCssNode)node, content);
            return result;
        }
        StyleSheet importedAst = this.buildImportedAst(node, importedSource, importedContent);
        if (node.isReferenceOnly() || node.isSilent()) {
            this.astManipulator.setTreeSilentness(importedAst, true);
        }
        this.astManipulator.replaceInBody((ASTCssNode)node, importedAst.getChilds());
        return importedAst;
    }

    private StyleSheet buildImportedAst(Import node, LessSource source, String content) {
        StyleSheet importedAst = this.parseContent(node, content, source);
        if (node.hasMediums()) {
            HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
            StyleSheet result = new StyleSheet(underlyingStructure);
            Media media = new Media(underlyingStructure);
            result.addMember(media);
            media.setParent(result);
            media.setMediums(node.getMediums());
            GeneralBody mediaBody = new GeneralBody(underlyingStructure, importedAst.getMembers());
            media.setBody(mediaBody);
            media.configureParentToAllChilds();
            mediaBody.configureParentToAllChilds();
            return result;
        }
        return importedAst;
    }

    private boolean isImportOnce(Import node) {
        return node.getMultiplicity() == Import.ImportMultiplicity.IMPORT || node.getMultiplicity() == Import.ImportMultiplicity.IMPORT_ONCE;
    }

    private boolean alreadyVisited(LessSource importedSource) {
        return this.importedSources.contains(importedSource);
    }

    public Set<LessSource> getImportedSources() {
        return this.importedSources;
    }

    private StyleSheet parseContent(Import importNode, String importedContent, LessSource source) {
        ANTLRParser parser = new ANTLRParser();
        ANTLRParser.ParseResult parsedSheet = parser.parseStyleSheet(importedContent, source);
        if (parsedSheet.hasErrors()) {
            StyleSheet result = new StyleSheet(importNode.getUnderlyingStructure());
            result.addMember(new FaultyNode(importNode));
            this.problemsHandler.addErrors(parsedSheet.getErrors());
            return result;
        }
        ASTBuilder astBuilder = new ASTBuilder(this.problemsHandler);
        StyleSheet lessStyleSheet = astBuilder.parse(parsedSheet.getTree());
        return lessStyleSheet;
    }

    private String addLessSuffixIfNeeded(String filename, String urlParams) {
        if (new File(filename).getName().contains(".")) {
            return filename;
        }
        return filename + ".less" + urlParams;
    }

    private boolean treatAsCss(Import node, String filename) {
        Import.ImportContent contentKind = node.getContentKind();
        return contentKind == Import.ImportContent.CSS || contentKind == Import.ImportContent.SUFFIX_BASED && this.isCssFile(filename);
    }

    private boolean isCssFile(String filename) {
        String lowerCase = filename.toLowerCase();
        return lowerCase.endsWith(".css") || lowerCase.endsWith("/css");
    }
}

