/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jaitools.CollectionFactory;
import org.jaitools.imageutils.FloodFiller;

public class FillResult {
    private int id;
    private double value;
    private Rectangle bounds;
    private List<FloodFiller.ScanSegment> segments;
    private Map<Integer, List<Integer>> index;
    private int numPixels;

    public FillResult(int id, double value, List<FloodFiller.ScanSegment> segments) {
        this.id = id;
        this.value = value;
        this.segments = segments;
        this.index = CollectionFactory.map();
        if (segments.isEmpty()) {
            this.numPixels = 0;
            this.bounds = new Rectangle();
        } else {
            Collections.sort(segments);
            FloodFiller.ScanSegment segment = segments.get(0);
            int minx = segment.startX;
            int maxx = segment.endX;
            int miny = segment.y;
            int maxy = segment.y;
            this.numPixels = segment.endX - segment.startX + 1;
            this.addToIndex(segment, 0);
            if (segments.size() > 1) {
                ListIterator<FloodFiller.ScanSegment> iter = segments.listIterator(1);
                int k = 1;
                while (iter.hasNext()) {
                    segment = iter.next();
                    maxy = segment.y;
                    if (segment.startX < minx) {
                        minx = segment.startX;
                    }
                    if (segment.endX > maxx) {
                        maxx = segment.endX;
                    }
                    this.numPixels += segment.endX - segment.startX + 1;
                    this.addToIndex(segment, k++);
                }
            }
            this.bounds = new Rectangle(minx, miny, maxx - minx + 1, maxy - miny + 1);
        }
    }

    public boolean contains(int x, int y) {
        if (!this.bounds.contains(x, y)) {
            return false;
        }
        List<Integer> indices = this.index.get(y);
        for (Integer i : indices) {
            FloodFiller.ScanSegment segment = this.segments.get(i);
            if (!segment.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public void expand(FillResult other) {
        this.bounds = this.bounds.union(other.bounds);
        for (FloodFiller.ScanSegment otherSeg : other.segments) {
            this.segments.add(otherSeg);
            this.addToIndex(otherSeg, this.segments.size() - 1);
        }
        this.numPixels += other.numPixels;
    }

    public int getID() {
        return this.id;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public int getNumPixels() {
        return this.numPixels;
    }

    public double getValue() {
        return this.value;
    }

    private void addToIndex(FloodFiller.ScanSegment segment, int segmentListPos) {
        List<Integer> indices = this.index.get(segment.y);
        if (indices == null) {
            indices = CollectionFactory.list();
            this.index.put(segment.y, indices);
        }
        indices.add(segmentListPos);
    }
}

