/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import com.google.common.base.Optional;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.OperationAllowed_;
import org.fao.geonet.repository.OperationAllowedRepositoryCustom;
import org.springframework.data.jpa.domain.Specification;

public class OperationAllowedRepositoryImpl
implements OperationAllowedRepositoryCustom {
    @PersistenceContext
    EntityManager _entityManager;

    @Override
    public List<OperationAllowed> findByMetadataId(String metadataId) {
        CriteriaBuilder builder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OperationAllowed.class);
        int iMdId = Integer.parseInt(metadataId);
        Root root = query.from(OperationAllowed.class);
        ParameterExpression idParameter = builder.parameter(Integer.class, "id");
        query.where((Expression)builder.equal((Expression)idParameter, (Expression)root.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId)));
        return this._entityManager.createQuery(query).setParameter("id", (Object)iMdId).getResultList();
    }

    @Override
    public List<OperationAllowed> findAllWithOwner(int userId, Optional<Specification<OperationAllowed>> specification) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(OperationAllowed.class);
        Root operationAllowedRoot = query.from(OperationAllowed.class);
        Root metadataRoot = query.from(Metadata.class);
        query.select((Selection)operationAllowedRoot);
        Predicate userEqualsPredicate = cb.equal((Expression)metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.owner), (Object)userId);
        Predicate mdIdEquals = cb.equal((Expression)metadataRoot.get(Metadata_.id), (Expression)operationAllowedRoot.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId));
        if (specification.isPresent()) {
            Predicate otherPredicate = ((Specification)specification.get()).toPredicate(operationAllowedRoot, query, cb);
            query.where(new Predicate[]{mdIdEquals, userEqualsPredicate, otherPredicate});
        } else {
            query.where(new Predicate[]{mdIdEquals, userEqualsPredicate});
        }
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public List<Integer> findAllIds(Specification<OperationAllowed> spec, SingularAttribute<OperationAllowedId, Integer> idAttribute) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Integer.class);
        Root root = query.from(OperationAllowed.class);
        query.where((Expression)spec.toPredicate(root, query, cb));
        query.select((Selection)root.get(OperationAllowed_.id).get(idAttribute));
        query.distinct(true);
        return this._entityManager.createQuery(query).getResultList();
    }
}

