/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.StatusValue_;
import org.fao.geonet.repository.MetadataStatusRepositoryCustom;
import org.fao.geonet.repository.SortUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class MetadataStatusRepositoryImpl
implements MetadataStatusRepositoryCustom {
    @PersistenceContext
    EntityManager _entityManager;

    @Override
    @Nonnull
    public List<MetadataStatus> findAllByMetadataIdAndByType(int metadataId, StatusValueType type, Sort sort) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(MetadataStatus.class);
        Root metadataStatusRoot = query.from(MetadataStatus.class);
        Root statusValueRoot = query.from(StatusValue.class);
        query.select((Selection)metadataStatusRoot);
        Predicate metadataIdEqualsPredicate = cb.equal((Expression)metadataStatusRoot.get(MetadataStatus_.metadataId), (Object)metadataId);
        Predicate mdIdEquals = cb.equal((Expression)metadataStatusRoot.get(MetadataStatus_.statusValue), (Expression)statusValueRoot.get(StatusValue_.id));
        Predicate statusTypePredicate = cb.equal((Expression)statusValueRoot.get(StatusValue_.type), (Object)type);
        query.where(new Predicate[]{mdIdEquals, metadataIdEqualsPredicate, statusTypePredicate});
        if (sort != null) {
            List<Order> orders = SortUtils.sortToJpaOrders(cb, sort, metadataStatusRoot);
            query.orderBy(orders);
        }
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public List<MetadataStatus> searchStatus(List<Integer> ids, List<String> uuids, List<StatusValueType> types, List<Integer> ownerIds, List<Integer> authorIds, List<Integer> recordIds, List<String> statusIds, String dateFrom, String dateTo, @Nullable Pageable pageable) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(MetadataStatus.class);
        Root metadataStatusRoot = cbQuery.from(MetadataStatus.class);
        Root statusValueRoot = cbQuery.from(StatusValue.class);
        Path statusIdInMetadataPath = metadataStatusRoot.get(MetadataStatus_.statusValue);
        Path statusIdDatePath = metadataStatusRoot.get(MetadataStatus_.changeDate);
        Path statusIdPath = statusValueRoot.get(StatusValue_.id);
        Path statusTypePath = statusValueRoot.get(StatusValue_.type);
        Predicate statusIdJoin = cb.equal((Expression)statusIdInMetadataPath, (Expression)statusIdPath);
        Predicate idPredicate = null;
        Predicate uuidPredicate = null;
        Predicate typeFilter = null;
        Predicate authorPredicate = null;
        Predicate ownerPredicate = null;
        Predicate recordPredicate = null;
        Predicate statusIdPredicate = null;
        if (CollectionUtils.isNotEmpty(ids)) {
            Path idPath = metadataStatusRoot.get(MetadataStatus_.id);
            idPredicate = idPath.in(ids);
        }
        if (CollectionUtils.isNotEmpty(uuids)) {
            Path uuidPath = metadataStatusRoot.get(MetadataStatus_.uuid);
            uuidPredicate = uuidPath.in(uuids);
        }
        if (CollectionUtils.isNotEmpty(types)) {
            Predicate typePredicate = statusTypePath.in(types);
            typeFilter = cb.and((Expression)statusIdJoin, (Expression)typePredicate);
        }
        if (CollectionUtils.isNotEmpty(authorIds)) {
            Path authorIdPath = metadataStatusRoot.get(MetadataStatus_.userId);
            authorPredicate = authorIdPath.in(authorIds);
        }
        if (CollectionUtils.isNotEmpty(ownerIds)) {
            Path ownerIdPath = metadataStatusRoot.get(MetadataStatus_.owner);
            ownerPredicate = ownerIdPath.in(ownerIds);
        }
        if (CollectionUtils.isNotEmpty(recordIds)) {
            Path recordIdPath = metadataStatusRoot.get(MetadataStatus_.metadataId);
            recordPredicate = recordIdPath.in(recordIds);
        }
        if (CollectionUtils.isNotEmpty(statusIds)) {
            statusIdPredicate = statusIdPath.in(statusIds);
        }
        Predicate whereClause = cb.and(new Predicate[]{statusIdJoin});
        if (idPredicate != null) {
            whereClause.getExpressions().add(idPredicate);
        }
        if (uuidPredicate != null) {
            whereClause.getExpressions().add(uuidPredicate);
        }
        if (typeFilter != null) {
            whereClause.getExpressions().add(typeFilter);
        }
        if (authorPredicate != null) {
            whereClause.getExpressions().add(authorPredicate);
        }
        if (ownerPredicate != null) {
            whereClause.getExpressions().add(ownerPredicate);
        }
        if (recordPredicate != null) {
            whereClause.getExpressions().add(recordPredicate);
        }
        if (statusIdPredicate != null) {
            whereClause.getExpressions().add(statusIdPredicate);
        }
        if (StringUtils.isNotBlank((String)dateFrom)) {
            whereClause.getExpressions().add(cb.greaterThanOrEqualTo((Expression)statusIdDatePath, (Comparable)new ISODate(dateFrom)));
        }
        if (StringUtils.isNotBlank((String)dateTo)) {
            whereClause.getExpressions().add(cb.lessThanOrEqualTo((Expression)statusIdDatePath, (Comparable)new ISODate(dateTo)));
        }
        cbQuery.select((Selection)metadataStatusRoot).where((Expression)whereClause);
        if (pageable != null && pageable.getSort() != null) {
            Sort sort = pageable.getSort();
            List<Order> orders = SortUtils.sortToJpaOrders(cb, sort, metadataStatusRoot);
            cbQuery.orderBy(orders);
        }
        TypedQuery query = this._entityManager.createQuery(cbQuery);
        if (pageable != null) {
            query.setFirstResult(pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }
}

