/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.MetadataNotification;
import org.fao.geonet.domain.MetadataNotificationAction;
import org.fao.geonet.domain.MetadataNotificationId_;
import org.fao.geonet.domain.MetadataNotification_;
import org.fao.geonet.repository.MetadataNotificationRepositoryCustom;
import org.springframework.transaction.annotation.Transactional;

public class MetadataNotificationRepositoryImpl
implements MetadataNotificationRepositoryCustom {
    @PersistenceContext
    EntityManager _entityManager;

    @Override
    public List<MetadataNotification> findAllNotNotifiedForNotifier(int notifierId, MetadataNotificationAction ... actions) {
        Predicate fullClause;
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(MetadataNotification.class);
        Root notificationRoot = cbQuery.from(MetadataNotification.class);
        Path notifierIdPath = notificationRoot.get(MetadataNotification_.id).get(MetadataNotificationId_.notifierId);
        Predicate correctNotifier = cb.equal((Expression)notifierIdPath, (Object)notifierId);
        Path notifiedPath = notificationRoot.get(MetadataNotification_.notified_JPAWorkaround);
        Predicate notifiedIsNull = cb.isNull((Expression)notifiedPath);
        Predicate notNotified = cb.equal((Expression)notifiedPath, (Object)Character.valueOf('n'));
        Path actionPath = notificationRoot.get(MetadataNotification_.action);
        if (actions != null && actions.length > 0) {
            Predicate actionsPredicate = actionPath.in((Object[])actions);
            fullClause = cb.and(new Predicate[]{correctNotifier, cb.or((Expression)notifiedIsNull, (Expression)notNotified), actionsPredicate});
        } else {
            fullClause = cb.and((Expression)correctNotifier, (Expression)cb.or((Expression)notifiedIsNull, (Expression)notNotified));
        }
        cbQuery.where((Expression)fullClause);
        return this._entityManager.createQuery(cbQuery).getResultList();
    }

    @Override
    @Transactional
    public int deleteAllWithNotifierId(int notifierId) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(MetadataNotification.class);
        Root notificationRoot = delete.from(MetadataNotification.class);
        delete.where((Expression)cb.equal((Expression)notificationRoot.get(MetadataNotification_.id).get(MetadataNotificationId_.notifierId), (Object)notifierId));
        return this._entityManager.createQuery(delete).executeUpdate();
    }
}

