/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.api.records.model.MetadataPublicationNotificationInfo;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.metadata.DefaultStatusActions;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataPublicationMailNotifier {
    @Autowired
    SettingManager settingManager;
    @Autowired
    GroupRepository groupRepository;

    public void notifyPublication(ResourceBundle messages, String mailLanguage, List<MetadataPublicationNotificationInfo> metadataListToNotifyPublication) {
        StatusValueNotificationLevel notificationLevel;
        String notificationSetting = this.settingManager.getValue("system/metadataprivs/publication/notificationLevel");
        if (StringUtils.isNotEmpty((CharSequence)notificationSetting) && (notificationLevel = StatusValueNotificationLevel.valueOf((String)notificationSetting)) != null) {
            if (notificationLevel == StatusValueNotificationLevel.recordProfileReviewer) {
                Map<Integer, List<MetadataPublicationNotificationInfo>> metadataListToNotifyPublicationPerGroup = metadataListToNotifyPublication.stream().collect(Collectors.groupingBy(MetadataPublicationNotificationInfo::getGroupId));
                metadataListToNotifyPublicationPerGroup.forEach((groupId, metadataNotificationInfoList) -> {
                    Set metadataIds = metadataNotificationInfoList.stream().map(MetadataPublicationNotificationInfo::getMetadataId).collect(Collectors.toSet());
                    List userToNotify = DefaultStatusActions.getUserToNotify((StatusValueNotificationLevel)notificationLevel, metadataIds, null);
                    List<String> toAddress1 = userToNotify.stream().map(User::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    this.sendMailPublicationNotification(messages, mailLanguage, toAddress1, (List<MetadataPublicationNotificationInfo>)metadataNotificationInfoList);
                });
            } else {
                List<String> toAddress;
                if (notificationLevel == StatusValueNotificationLevel.recordGroupEmail) {
                    List groupToNotify = DefaultStatusActions.getGroupToNotify((StatusValueNotificationLevel)notificationLevel, Arrays.asList(this.settingManager.getValue("system/metadataprivs/publication/notificationGroups").split("\\|")));
                    toAddress = groupToNotify.stream().map(Group::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                } else {
                    Set metadataIds = metadataListToNotifyPublication.stream().map(MetadataPublicationNotificationInfo::getMetadataId).collect(Collectors.toSet());
                    List userToNotify = DefaultStatusActions.getUserToNotify((StatusValueNotificationLevel)notificationLevel, metadataIds, null);
                    toAddress = userToNotify.stream().map(User::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                }
                this.sendMailPublicationNotification(messages, mailLanguage, toAddress, metadataListToNotifyPublication);
            }
        }
    }

    private void sendMailPublicationNotification(ResourceBundle messages, String mailLanguage, List<String> toAddress, List<MetadataPublicationNotificationInfo> metadataListToNotifyPublication) {
        if (toAddress.isEmpty()) {
            return;
        }
        String subject = String.format(messages.getString("metadata_published_subject"), this.settingManager.getSiteName());
        String message = messages.getString("metadata_published_text");
        String linkRecordTemplate = "{{link}}";
        String linkRecordUrlTemplate = this.settingManager.getNodeURL() + "api/records/{{index:_uuid}}";
        String recordPublishedMessage = messages.getString("metadata_published_record_text").replace(linkRecordTemplate, linkRecordUrlTemplate);
        String recordUnpublishedMessage = messages.getString("metadata_unpublished_record_text").replace(linkRecordTemplate, linkRecordUrlTemplate);
        String recordReapprovedPublishedMessage = messages.getString("metadata_approved_published_record_text").replace(linkRecordTemplate, linkRecordUrlTemplate);
        StringBuilder listOfProcessedMetadataMessage = new StringBuilder();
        metadataListToNotifyPublication.forEach(metadata -> {
            Group group = (Group)this.groupRepository.findOne((Serializable)metadata.getGroupId());
            if (Boolean.TRUE.equals(metadata.getPublished())) {
                String recordPublishedMessageAux = !metadata.isReapproval() ? this.replaceMessageValues(recordPublishedMessage, (MetadataPublicationNotificationInfo)metadata, group) : this.replaceMessageValues(recordReapprovedPublishedMessage, (MetadataPublicationNotificationInfo)metadata, group);
                listOfProcessedMetadataMessage.append(MailUtil.compileMessageWithIndexFields((String)recordPublishedMessageAux, (String)metadata.getMetadataUuid(), (String)mailLanguage));
            } else {
                String recordUnpublishedMessageAux = this.replaceMessageValues(recordUnpublishedMessage, (MetadataPublicationNotificationInfo)metadata, group);
                listOfProcessedMetadataMessage.append(MailUtil.compileMessageWithIndexFields((String)recordUnpublishedMessageAux, (String)metadata.getMetadataUuid(), (String)mailLanguage));
            }
        });
        String htmlMessage = String.format(message, listOfProcessedMetadataMessage);
        try {
            MailUtil.sendHtmlMail(toAddress, (String)subject, (String)htmlMessage, (SettingManager)this.settingManager);
        }
        catch (IllegalArgumentException ex) {
            Log.warning((String)"geonetwork.api", (Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private String replaceMessageValues(String message, MetadataPublicationNotificationInfo metadata, Group group) {
        String messageAux = message.replace("{{publisherUser}}", metadata.getPublisherUser()).replace("{{submitterUser}}", metadata.getSubmitterUser()).replace("{{reviewerUser}}", metadata.getReviewerUser()).replace("{{timeStamp}}", metadata.getPublicationDateStamp().getDateAndTime());
        if (group != null) {
            messageAux = messageAux.replace("{{group}}", group.getName());
        }
        return messageAux;
    }
}

