/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

@Deprecated
public class Upload
implements Service {
    private Path stylePath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xsl");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        long start = System.currentTimeMillis();
        Element uploadResult = this.upload(params, context);
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploaded in " + duration + " s."));
        }
        Element response = new Element("response");
        response.setAttribute("time", duration + "");
        if (uploadResult != null) {
            response.addContent((Content)uploadResult);
        }
        return response;
    }

    private Element upload(Element params, ServiceContext context) throws Exception {
        Path uploadDir = context.getUploadDir();
        String fname = null;
        Path rdfFile = null;
        Element param = params.getChild("fname");
        if (param == null) {
            String url = Util.getParam((Element)params, (String)"url", (String)"");
            if (!"".equals(url)) {
                if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
                    Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus: " + url));
                }
                URI uri = new URI(url);
                rdfFile = Files.createTempFile("thesaurus", ".rdf", new FileAttribute[0]);
                XmlRequest httpReq = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(uri.toURL());
                httpReq.setAddress(uri.getPath());
                Lib.net.setupProxy(context, httpReq);
                httpReq.executeLarge(rdfFile);
                fname = url.substring(url.lastIndexOf("/") + 1, url.length()).replaceAll("\\s+", "");
                if (fname.lastIndexOf(46) == -1) {
                    fname = fname + ".rdf";
                }
            } else if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
                Log.debug((String)"geonetwork.thesaurus", (Object)"No URL or file name provided for thesaurus upload.");
            }
        } else {
            fname = param.getTextTrim();
            FilePathChecker.verify((String)fname);
            rdfFile = uploadDir.resolve(fname);
            fname = fname.replaceAll("\\s+", "");
        }
        if (fname == null || "".equals(fname)) {
            throw new OperationAbortedEx("File upload from URL or file return null.");
        }
        if (rdfFile == null || !Files.exists(rdfFile, new LinkOption[0])) {
            throw new OperationAbortedEx("Thesaurus file doesn't exist");
        }
        long fsize = Files.size(rdfFile);
        if (fsize == 0L) {
            throw new OperationAbortedEx("Thesaurus file has zero size");
        }
        String type = Util.getParam((Element)params, (String)"type", (String)"external");
        String dir = Util.getParam((Element)params, (String)"dir", (String)"theme");
        String style = Util.getParam((Element)params, (String)"styleSheet", (String)"_none_");
        int extensionIdx = fname.lastIndexOf(46);
        String extension = fname.substring(extensionIdx).toLowerCase();
        if (extension.equals(".rdf") || extension.equals(".xml")) {
            if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
                Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus: " + fname));
            }
        } else {
            if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
                Log.debug((String)"geonetwork.thesaurus", (Object)("Incorrect extension for thesaurus named: " + fname));
            }
            throw new Exception("Incorrect extension for thesaurus named: " + fname);
        }
        fname = fname.substring(0, extensionIdx) + ".rdf";
        Element eTSResult = this.uploadThesaurus(rdfFile, style, context, fname, type, dir);
        Element uploadResult = new Element("record").setText("Thesaurus uploaded");
        uploadResult.addContent((Content)eTSResult);
        return uploadResult;
    }

    private Element uploadThesaurus(Path rdfFile, String style, ServiceContext context, String fname, String type, String dir) throws Exception {
        Path path;
        ThesaurusManager thesaurusMan;
        Element tsXml;
        Element xml = Xml.loadFile((Path)rdfFile);
        xml.detach();
        if (!style.equals("_none_")) {
            FilePathChecker.verify((String)style);
            tsXml = Xml.transform((Element)xml, (Path)this.stylePath.resolve(style));
            tsXml.detach();
        } else {
            tsXml = xml;
        }
        if (tsXml.getNamespacePrefix().equals("rdf") && tsXml.getName().equals("RDF")) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            thesaurusMan = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
            path = thesaurusMan.buildThesaurusFilePath(fname, type, dir);
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                Xml.writeResponse((Document)new Document(tsXml), (OutputStream)out);
            }
        } else {
            IO.deleteFile((Path)rdfFile, (boolean)false, (String)"geonetwork.thesaurus");
            throw new Exception("Unknown format (Must be in SKOS format).");
        }
        String siteURL = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
        IsoLanguagesMapper isoLanguageMapper = (IsoLanguagesMapper)context.getBean(IsoLanguagesMapper.class);
        Thesaurus gst = new Thesaurus(isoLanguageMapper, fname, type, dir, path, siteURL);
        thesaurusMan.addThesaurus(gst, false);
        return new Element("Thesaurus").setText(fname);
    }
}

