/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.register;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.sql.SQLException;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.exceptions.ServiceNotAllowedEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.PasswordUtil;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

@Deprecated
public class SelfRegister
extends NotInReadOnlyModeService {
    private static final String PROFILE_TEMPLATE = "profileTemplate";
    private static final String PROFILE = "RegisteredUser";
    private static final String PASSWORD_EMAIL_XSLT = "registration-pwd-email.xsl";
    private static final String PROFILE_EMAIL_XSLT = "registration-prof-email.xsl";
    private static String FS = File.separator;
    private Path stylePath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        boolean isEnabled = sm.getValueAsBool("system/userSelfRegistration/enable");
        if (!isEnabled) {
            throw new ServiceNotAllowedEx("User self-registration is disabled");
        }
        GeonetworkDataDirectory dataDir = (GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class);
        this.stylePath = dataDir.resolveWebResource("xslt").resolve("services").resolve("account");
        String surname = Util.getParam((Element)params, (String)"surname");
        String name = Util.getParam((Element)params, (String)"name");
        String email = Util.getParam((Element)params, (String)"email");
        String profile = Util.getParam((Element)params, (String)"profile");
        String address = Util.getParam((Element)params, (String)"address", (String)"");
        String city = Util.getParam((Element)params, (String)"city", (String)"");
        String state = Util.getParam((Element)params, (String)"state", (String)"");
        String zip = Util.getParam((Element)params, (String)"zip", (String)"");
        String country = Util.getParam((Element)params, (String)"country", (String)"");
        String organ = Util.getParam((Element)params, (String)"org", (String)"");
        String kind = Util.getParam((Element)params, (String)"kind", (String)"");
        String username = email;
        String password = this.getInitPassword();
        String catalogAdminEmail = sm.getValue("system/feedback/email");
        String thisSite = sm.getSiteName();
        Element element = new Element("response");
        element.setAttribute("surname", surname);
        element.setAttribute("name", name);
        element.setAttribute("email", email);
        element.setAttribute("username", username);
        UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
        if (userRepository.findOneByEmail(email) != null) {
            return element.addContent((Content)new Element("result").setText("errorEmailAddressAlreadyRegistered"));
        }
        if (userRepository.findByUsernameIgnoreCase(username).size() != 0) {
            return element.addContent((Content)new Element("result").setText("errorEmailAddressAlreadyRegistered"));
        }
        Group group = this.getGroup(context);
        String passwordHash = PasswordUtil.encode((ServiceContext)context, (String)password);
        User user = new User().setKind(kind).setName(name).setOrganisation(organ).setProfile(Profile.RegisteredUser).setSurname(surname).setUsername(username);
        user.getSecurity().setPassword(passwordHash);
        user.getEmailAddresses().add(email);
        user.getAddresses().add(new Address().setAddress(address).setCountry(country).setCity(city).setState(state).setZip(zip));
        userRepository.save((Object)user);
        UserGroup userGroup = new UserGroup().setUser(user).setGroup(group).setProfile(Profile.RegisteredUser);
        ((UserGroupRepository)context.getBean(UserGroupRepository.class)).save((Object)userGroup);
        SettingInfo si = (SettingInfo)context.getBean(SettingInfo.class);
        String siteURL = si.getSiteUrl() + context.getBaseUrl();
        if (!this.sendRegistrationEmail(params, password, catalogAdminEmail, thisSite, siteURL, sm)) {
            return element.addContent((Content)new Element("result").setText("errorEmailToAddressFailed"));
        }
        if (!profile.equalsIgnoreCase(Profile.RegisteredUser.name()) && !this.sendProfileRequest(params, catalogAdminEmail, thisSite, siteURL, sm)) {
            return element.addContent((Content)new Element("result").setText("errorProfileRequestFailed"));
        }
        return element;
    }

    private boolean sendRegistrationEmail(Element params, String password, String from, String thisSite, String siteURL, SettingManager sm) throws Exception, SQLException {
        Element root = new Element("root");
        root.addContent((Content)new Element("site").setText(thisSite));
        root.addContent((Content)new Element("siteURL").setText(siteURL));
        root.addContent((Content)((Element)params.clone()));
        root.addContent((Content)new Element("password").setText(password));
        String template = Util.getParam((Element)params, (String)"template", (String)PASSWORD_EMAIL_XSLT);
        FilePathChecker.verify((String)template);
        Path emailXslt = this.stylePath.resolve(template);
        Element elEmail = Xml.transform((Element)root, (Path)emailXslt);
        String email = Util.getParam((Element)params, (String)"email");
        String subject = elEmail.getChildText("subject");
        String message = elEmail.getChildText("content");
        return MailUtil.sendMail((String)email, (String)subject, (String)message, null, (SettingManager)sm);
    }

    private boolean sendProfileRequest(Element params, String from, String thisSite, String siteURL, SettingManager sm) throws Exception {
        Element root = new Element("root");
        root.addContent((Content)new Element("site").setText(thisSite));
        root.addContent((Content)new Element("siteURL").setText(siteURL));
        root.addContent((Content)((Element)params.clone()));
        String profileTemplate = Util.getParam((Element)params, (String)PROFILE_TEMPLATE, (String)PROFILE_EMAIL_XSLT);
        FilePathChecker.verify((String)profileTemplate);
        Path emailXslt = this.stylePath.resolve(profileTemplate);
        Element elEmail = Xml.transform((Element)root, (Path)emailXslt);
        String subject = elEmail.getChildText("subject");
        String message = elEmail.getChildText("content");
        return MailUtil.sendMail((String)from, (String)subject, (String)message, null, (SettingManager)sm);
    }

    Group getGroup(ServiceContext context) throws SQLException {
        GroupRepository bean = (GroupRepository)context.getBean(GroupRepository.class);
        return (Group)bean.findOne((Serializable)Integer.valueOf(ReservedGroup.guest.getId()));
    }

    String getInitPassword() {
        StringKeyGenerator generator = KeyGenerators.string();
        return generator.generateKey().substring(0, 8);
    }
}

