/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.notifications;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.MetadataNotifier;
import org.fao.geonet.repository.MetadataNotificationRepository;
import org.fao.geonet.repository.MetadataNotifierRepository;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.services.notifications.domain.NotificationTarget;
import org.jdom.Element;

public class Save
extends NotInReadOnlyModeService {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        HashMap<String, NotificationTarget> notificationTargets = new HashMap<String, NotificationTarget>();
        List parameters = params.getChildren();
        for (Element parameter : parameters) {
            NotificationTarget notificationTarget;
            String identifier = parameter.getName().substring(parameter.getName().lastIndexOf(45) + 1);
            if (notificationTargets.containsKey(identifier)) {
                notificationTarget = (NotificationTarget)notificationTargets.get(identifier);
                notificationTarget = this.parameterToNotificationTarget(parameter, notificationTarget);
                continue;
            }
            notificationTarget = new NotificationTarget();
            notificationTarget.setId(identifier);
            notificationTarget = this.parameterToNotificationTarget(parameter, notificationTarget);
            notificationTargets.put(identifier, notificationTarget);
        }
        MetadataNotificationRepository notificationRepository = (MetadataNotificationRepository)context.getBean(MetadataNotificationRepository.class);
        MetadataNotifierRepository notifierRepository = (MetadataNotifierRepository)context.getBean(MetadataNotifierRepository.class);
        for (NotificationTarget notificationTarget : notificationTargets.values()) {
            MetadataNotifier metadataNotifier = new MetadataNotifier();
            metadataNotifier.setName(notificationTarget.getName());
            metadataNotifier.setUsername(notificationTarget.getUsername());
            metadataNotifier.setPassword(notificationTarget.getPassword());
            metadataNotifier.setUrl(notificationTarget.getUrl());
            metadataNotifier.setEnabled(notificationTarget.isEnabled());
            if (!notificationTarget.isPreExisting() && StringUtils.isNotBlank((String)notificationTarget.getName()) && StringUtils.isNotBlank((String)notificationTarget.getUrl())) {
                notifierRepository.save((Object)metadataNotifier);
                continue;
            }
            if (!notificationTarget.isPreExisting()) continue;
            String id = notificationTarget.getId();
            if (notificationTarget.getName() == null) {
                int iid = Integer.parseInt(id);
                notificationRepository.deleteAllWithNotifierId(iid);
                notifierRepository.delete((Serializable)Integer.valueOf(iid));
                continue;
            }
            notifierRepository.save((Object)metadataNotifier);
        }
        return new Element("ok");
    }

    private NotificationTarget parameterToNotificationTarget(Element parameter, NotificationTarget notificationTarget) {
        String member = parameter.getName().substring(0, parameter.getName().lastIndexOf(45));
        if (member.equals("id")) {
            notificationTarget.setId(parameter.getText());
            notificationTarget.setPreExisting(true);
        } else if (member.equals("name")) {
            notificationTarget.setName(parameter.getText());
        } else if (member.equals("url")) {
            notificationTarget.setUrl(parameter.getText());
        } else if (member.equals("username")) {
            notificationTarget.setUsername(parameter.getText());
        } else if (member.equals("password")) {
            notificationTarget.setPassword(parameter.getText());
        } else if (member.equals("enabled")) {
            notificationTarget.setEnabled(true);
        }
        return notificationTarget;
    }
}

