/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.net.URL;
import java.nio.file.Path;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.BadServerResponseEx;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.geonet.GeonetParams;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.services.Utils;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

@Deprecated
public class Rate
extends NotInReadOnlyModeService {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        HarvestManager hm = (HarvestManager)gc.getBean(HarvestManager.class);
        String id = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
        String rat = Util.getParam((Element)params, (String)"rating");
        String ip = context.getIpAddress();
        int iLocalId = Integer.parseInt(id);
        if (!dm.existsMetadata(iLocalId)) {
            throw new IllegalArgumentException("Metadata not found --> " + id);
        }
        if (ip == null) {
            ip = "???.???.???.???";
        }
        if (!Lib.type.isInteger(rat)) {
            throw new BadParameterEx("rating", (Object)rat);
        }
        int rating = Integer.parseInt(rat);
        if (rating < 0 || rating > 5) {
            throw new BadParameterEx("rating", (Object)rat);
        }
        String harvUuid = this.getHarvestingUuid(context, id);
        SettingManager settingManager = (SettingManager)gc.getBean(SettingManager.class);
        String localRating = settingManager.getValue("system/localrating/enable");
        if (localRating.equals("basic") || harvUuid == null) {
            rating = dm.rateMetadata(Integer.valueOf(id).intValue(), ip, rating);
        } else {
            AbstractHarvester ah = hm.getHarvester(harvUuid);
            if (ah.getType().equals("geonetwork")) {
                String uuid = dm.getMetadataUuid(id);
                rating = this.setRemoteRating(context, (GeonetParams)ah.getParams(), uuid, rating);
            } else {
                rating = -1;
            }
        }
        return new Element("rating").setText(Integer.toString(rating));
    }

    private String getHarvestingUuid(ServiceContext context, String id) throws Exception {
        AbstractMetadata metadata = ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findOne(id);
        if (metadata == null) {
            throw new MetadataNotFoundEx("id:" + id);
        }
        String harvUuid = metadata.getHarvestInfo().getUuid();
        return harvUuid == null || harvUuid.length() == 0 ? null : harvUuid;
    }

    private int setRemoteRating(ServiceContext context, GeonetParams params, String uuid, int rating) throws Exception {
        if (context.isDebugEnabled()) {
            context.debug("Rating remote metadata with uuid:" + uuid);
        }
        XmlRequest req = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(params.host));
        Lib.net.setupProxy(context, req);
        req.setAddress(params.getServletPath() + "/srv/eng/" + "xml.metadata.rate");
        req.clearParams();
        req.addParam("uuid", (Object)uuid);
        req.addParam("rating", (Object)rating);
        Element response = req.execute();
        if (!response.getName().equals("rating")) {
            throw new BadServerResponseEx((Object)response);
        }
        return Integer.parseInt(response.getText());
    }
}

