/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.services.metadata.View;
import org.jdom.Content;
import org.jdom.Element;

public class Home
implements Service {
    private ServiceConfig _config;
    private Path _appPath;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this._config = config;
        this._appPath = appPath;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String location = context.getBaseUrl() + "/srv/" + context.getLanguage() + "/search";
        StringBuilder parameters = new StringBuilder();
        parameters.append("?");
        String tabs = "#";
        Element result = params;
        boolean forward = false;
        Element tmp = new Element("tmp");
        for (Object e : params.getChildren()) {
            String uuid = ((Element)e).getText();
            if (((Element)e).getName().equalsIgnoreCase("uuid")) {
                forward = true;
                tabs = tabs + "|" + uuid;
                this.addNewUUID(tmp, uuid);
                continue;
            }
            parameters.append(((Element)e).getName() + "=" + uuid + "&");
        }
        result.addContent((Content)tmp);
        UserSession session = context.getUserSession();
        if (forward) {
            session.setProperty("metadata.uuids", (Object)params);
            this.forwardTo(context, location, parameters.toString(), tabs);
        } else {
            result = (Element)session.getProperty("metadata.uuids");
            if (result != null) {
                session.removeProperty("metadata.uuids");
                for (Object e : result.getChildren()) {
                    Element el = (Element)e;
                    if (!el.getName().equalsIgnoreCase("tmp")) continue;
                    tmp = el;
                }
                View view = new View();
                view.init(this._appPath, this._config);
                result = view.exec(result, context);
                for (Object e : tmp.getChildren()) {
                    Element el = (Element)e;
                    result.addContent((Content)((Element)el.clone()));
                }
            } else {
                result = params;
            }
            this.setUser(result, session);
        }
        return result;
    }

    private void forwardTo(ServiceContext context, String location, String parameters, String tabs) {
        context.setStatusCode(Integer.valueOf(302));
        context.getResponseHeaders().put("Location", location + parameters + tabs);
    }

    private void setUser(Element result, UserSession session) {
        Element user = new Element("user");
        user.setText("user");
        result.addContent((Content)user);
        if (session.isAuthenticated()) {
            Element authenticated = new Element("authenticated");
            authenticated.setText("true");
            user.addContent((Content)authenticated);
            Element name = new Element("name");
            name.setText(session.getName());
            user.addContent((Content)name);
            Element username = new Element("username");
            username.setText(session.getUsername());
            user.addContent((Content)username);
            Element profile = new Element("profile");
            profile.setText(session.getProfile().name());
            user.addContent((Content)profile);
        } else {
            Element authenticated = new Element("authenticated");
            authenticated.setText("false");
            user.addContent((Content)authenticated);
        }
    }

    private void addNewUUID(Element result, String uuid) {
        Element articleEl2 = new Element("record");
        articleEl2.setText("record");
        Element uuidEl2 = new Element("uuid");
        uuidEl2.setText(uuid);
        articleEl2.addContent((Content)uuidEl2);
        result.addContent((Content)articleEl2);
    }
}

