/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.logo;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.imageio.ImageIO;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.FilePathChecker;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Set
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        block89: {
            Resources resources = (Resources)context.getBean(Resources.class);
            Path harvestingLogoDirectory = resources.locateHarvesterLogosDir(context);
            Path nodeLogoDirectory = resources.locateLogosDir(context);
            String file = Util.getParam((Element)params, (String)"fname");
            String asFavicon = Util.getParam((Element)params, (String)"favicon", (String)"0");
            FilePathChecker.verify((String)file);
            if (StringUtils.isEmpty((String)file)) {
                throw new Exception("Logo name is not defined.");
            }
            SettingManager settingMan = (SettingManager)context.getBean(SettingManager.class);
            String nodeUuid = settingMan.getSiteId();
            try (Resources.ResourceHolder logoResource = resources.getImage(context, file, harvestingLogoDirectory);){
                Path logoFilePath = logoResource == null ? context.getAppPath().resolve("images/harvesting/" + file) : logoResource.getPath();
                try (InputStream inputStream = Files.newInputStream(logoFilePath, new OpenOption[0]);){
                    BufferedImage source = ImageIO.read(inputStream);
                    if ("1".equals(asFavicon)) {
                        try (Resources.ResourceHolder logo = resources.getWritableImage(context, "favicon.png", nodeLogoDirectory);){
                            this.createFavicon(source, logo.getPath());
                            break block89;
                        }
                    }
                    try (Resources.ResourceHolder logo = resources.getWritableImage(context, nodeUuid + ".png", nodeLogoDirectory);
                         Resources.ResourceHolder defaultLogo = resources.getWritableImage(context, "logo.png", nodeLogoDirectory);){
                        if (!file.endsWith(".png")) {
                            try (OutputStream logoOut = Files.newOutputStream(logo.getPath(), new OpenOption[0]);
                                 OutputStream defLogoOut = Files.newOutputStream(defaultLogo.getPath(), new OpenOption[0]);){
                                ImageIO.write((RenderedImage)source, "png", logoOut);
                                ImageIO.write((RenderedImage)source, "png", defLogoOut);
                                break block89;
                            }
                        }
                        Files.copy(logoFilePath, logo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                        Files.copy(logoFilePath, defaultLogo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to move uploaded thumbnail to destination directory. Error: " + e.getMessage());
            }
        }
        Element response = new Element("response");
        response.addContent((Content)new Element("status").setText("Logo set."));
        return response;
    }

    private void createFavicon(Image img, Path outFile) throws IOException {
        int width = 32;
        int height = 32;
        String type = "png";
        Image thumb = img.getScaledInstance(width, height, 4);
        BufferedImage bimg = new BufferedImage(width, height, 3);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(thumb, 0, 0, null);
        g.dispose();
        try (OutputStream out = Files.newOutputStream(outFile, new OpenOption[0]);){
            ImageIO.write((RenderedImage)bimg, type, out);
        }
    }
}

