/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.crs;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.utils.Log;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.jdom.Content;
import org.jdom.Element;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public class GetCRS
implements Service {
    protected static Element formatCRS(String authorityTitle, String authorityEdition, String authorityCodeSpace, String code, String description) {
        Element crs = new Element("crs");
        crs.addContent((Content)new Element("code").setText(code));
        crs.addContent((Content)new Element("authority").setText(authorityTitle));
        crs.addContent((Content)new Element("version").setText(authorityEdition));
        crs.addContent((Content)new Element("codeSpace").setText(authorityCodeSpace));
        crs.addContent((Content)new Element("description").setText(description));
        return crs;
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String id = Util.getParam((Element)params, (String)"id");
        Element crs = this.get(id);
        return crs;
    }

    private Element get(String crsId) {
        Element crsList = new Element("crsList");
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            try {
                Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
                for (Object codeObj : codes) {
                    String description;
                    String code = (String)codeObj;
                    if (!code.equals(crsId)) continue;
                    String authorityTitle = factory.getAuthority().getTitle() == null ? "" : factory.getAuthority().getTitle().toString();
                    String authorityEdition = factory.getAuthority().getEdition() == null ? "" : factory.getAuthority().getEdition().toString();
                    String authorityCodeSpace = "";
                    Collection ids = factory.getAuthority().getIdentifiers();
                    for (Identifier id : ids) {
                        authorityCodeSpace = id.getCode();
                    }
                    try {
                        description = factory.getDescriptionText(code).toString();
                    }
                    catch (Exception e1) {
                        description = "-";
                    }
                    description = description + " (" + authorityCodeSpace + ":" + code + ")";
                    Element crs = GetCRS.formatCRS(authorityTitle, authorityEdition, authorityCodeSpace, code, description);
                    crsList.addContent((Content)crs);
                    return crsList;
                }
            }
            catch (FactoryException e) {
                Log.error((String)"geonetwork", (Object)("CRS Authority:" + e.getMessage()), (Throwable)e);
            }
        }
        return crsList;
    }

    protected boolean matchesFilter(String input, String[] filter) {
        for (String match : filter) {
            if (input.contains(match)) continue;
            return false;
        }
        return true;
    }
}

