/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.util;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;

public class GetCsvFileName
implements Service {
    private String fileName;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.fileName = params.getValue("fileName", "metadata_{datetime}.csv");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String documentName = this.fileName;
        if (StringUtils.isEmpty((String)documentName)) {
            documentName = "document.csv";
        } else {
            if (!documentName.endsWith(".csv")) {
                documentName = documentName + ".csv";
            }
            Calendar c = Calendar.getInstance();
            documentName = documentName.replace("{year}", c.get(1) + "");
            documentName = documentName.replace("{month}", c.get(2) + "");
            documentName = documentName.replace("{day}", c.get(5) + "");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            documentName = documentName.replace("{date}", dateFormat.format(c.getTime()));
            documentName = documentName.replace("{datetime}", datetimeFormat.format(c.getTime()));
        }
        return new Element("a").setText(documentName);
    }
}

