/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.usersearches;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.usersearches.model.PaginatedUserSearchResponse;
import org.fao.geonet.api.usersearches.model.UserSearchDto;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UserSearch;
import org.fao.geonet.domain.UserSearchFeaturedType;
import org.fao.geonet.domain.UserSearch_;
import org.fao.geonet.domain.converter.UserSearchFeaturedTypeConverter;
import org.fao.geonet.exceptions.ResourceNotFoundEx;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserSearchRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSearchSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.annotations.ApiIgnore;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/usersearches", "/{portal}/api/0.1/usersearches"})
@Api(value="usersearches", tags={"usersearches"}, description="User custom searches operations")
public class UserSearchesApi {
    public static final String API_PARAM_USERSEARCH_DETAILS = "User search details";
    public static final String API_PARAM_USERSEARCH_IDENTIFIER = "User search identifier";
    public static final String MSG_USERSEARCH_WITH_IDENTIFIER_NOT_FOUND = "User search with identifier '%d' not found";
    @Autowired
    UserSearchRepository userSearchRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    GroupRepository groupRepository;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(UserSearchFeaturedType.class, (PropertyEditor)new UserSearchFeaturedTypeConverter());
    }

    @ApiOperation(value="Get user custom searches", notes="", nickname="getUserCustomSearches")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public List<UserSearchDto> getUserCustomSearches(@ApiIgnore HttpSession httpSession) {
        List userSearchesList;
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        if (myProfile.equals((Object)Profile.Administrator)) {
            userSearchesList = this.userSearchRepository.findAll();
        } else {
            List userGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)session.getPrincipal().getId()));
            HashSet groups = new HashSet();
            userGroups.forEach(us -> groups.add(us.getGroup()));
            userSearchesList = this.userSearchRepository.findAllByGroupsInOrCreator(groups, session.getPrincipal());
        }
        ArrayList<UserSearchDto> customSearchDtoList = new ArrayList<UserSearchDto>();
        userSearchesList.forEach(u -> customSearchDtoList.add(UserSearchDto.from(u)));
        return customSearchDtoList;
    }

    @ApiOperation(value="Get user custom searches for all users (no paginated)", notes="", nickname="getAllUserCustomSearches")
    @RequestMapping(value={"/all"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseBody
    public List<UserSearchDto> getAllUserCustomSearches(@ApiParam(value="Featured type search.") @RequestParam(required=false) UserSearchFeaturedType featuredType) {
        List userSearchesList = featuredType == null ? this.userSearchRepository.findAll() : this.userSearchRepository.findAllByFeaturedType(featuredType);
        ArrayList<UserSearchDto> customSearchDtoList = new ArrayList<UserSearchDto>();
        userSearchesList.forEach(u -> customSearchDtoList.add(UserSearchDto.from(u)));
        return customSearchDtoList;
    }

    @ApiOperation(value="Get user custom searches for all users (paginated)", notes="", nickname="getAllUserCustomSearchesPaginated")
    @RequestMapping(value={"/allpaginated"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseBody
    public PaginatedUserSearchResponse getAllUserCustomSearchesPage(@ApiParam(value="Featured  type search.") @RequestParam(required=false) UserSearchFeaturedType featuredType, @RequestParam(required=false, defaultValue="") String search, @ApiParam(value="From page", required=false) @RequestParam(required=false, defaultValue="0") Integer offset, @ApiParam(value="Number of records to return", required=false) @RequestParam(required=false, defaultValue="10") Integer limit) {
        List userSearchesList;
        PaginatedUserSearchResponse response = new PaginatedUserSearchResponse();
        Sort sortBy = SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{UserSearch_.creationDate});
        int page = offset / limit;
        PageRequest pageRequest = new PageRequest(page, limit.intValue(), sortBy);
        Specification searchSpec = null;
        if (StringUtils.isNotEmpty((String)search)) {
            searchSpec = UserSearchSpecs.containsTextInCreatorOrTranslations((String)search);
        }
        long count = 0L;
        if (featuredType == null) {
            userSearchesList = this.userSearchRepository.findAll(searchSpec, (Pageable)pageRequest).getContent();
            count = this.userSearchRepository.count();
        } else {
            userSearchesList = this.userSearchRepository.findAllByFeaturedType(featuredType, searchSpec, (Pageable)pageRequest);
            count = this.userSearchRepository.countByFeaturedType(featuredType);
        }
        ArrayList<UserSearchDto> customSearchDtoList = new ArrayList<UserSearchDto>();
        userSearchesList.forEach(u -> customSearchDtoList.add(UserSearchDto.from(u)));
        response.setRows(customSearchDtoList);
        response.setTotal(count);
        return response;
    }

    @ApiOperation(value="Get featured user custom searches", notes="", nickname="getFeaturedUserCustomSearches")
    @RequestMapping(value={"/featured"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<UserSearchDto> getFeaturedUserCustomSearches(@ApiParam(value="Number of records to return", required=false) @RequestParam(required=false) UserSearchFeaturedType type) {
        if (type == null) {
            type = UserSearchFeaturedType.HOME;
        }
        List userSearchesList = this.userSearchRepository.findAllByFeaturedType(type);
        ArrayList<UserSearchDto> customSearchDtoList = new ArrayList<UserSearchDto>();
        userSearchesList.forEach(u -> customSearchDtoList.add(UserSearchDto.from(u)));
        return customSearchDtoList;
    }

    @ApiOperation(value="Get custom search", notes="", nickname="getUserCustomSearch")
    @RequestMapping(value={"/{searchIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public UserSearchDto getUserCustomSearch(@ApiParam(value="User search identifier") @PathVariable Integer searchIdentifier, @ApiIgnore HttpSession httpSession) {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        UserSearch userSearch = this.retrieveUserSearch(this.userSearchRepository, searchIdentifier);
        if (myProfile.equals((Object)Profile.Administrator)) {
            return UserSearchDto.from(userSearch);
        }
        if (userSearch.getCreator().getId() == session.getUserIdAsInt()) {
            return UserSearchDto.from(userSearch);
        }
        throw new IllegalArgumentException("You don't have rights to access the user search");
    }

    @ApiOperation(value="Creates a user search", notes="Creates a user search.", nickname="createUserCustomSearch")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ApiResponses(value={@ApiResponse(code=201, message="User search created.")})
    @ResponseBody
    public ResponseEntity<Integer> createUserCustomSearch(@ApiParam(value="User search details") @RequestBody UserSearchDto userSearchDto, @ApiIgnore HttpSession httpSession) {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        UserSearch userSearch = userSearchDto.asUserSearch();
        userSearch.setCreator(session.getPrincipal());
        if (!myProfile.equals((Object)Profile.Administrator)) {
            List userGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)session.getPrincipal().getId()));
            HashSet groups = new HashSet();
            userGroups.forEach(us -> groups.add(us.getGroup()));
            if (!groups.containsAll(userSearch.getGroups())) {
                throw new IllegalArgumentException("Not all the groups associated with the user search are groups of the user " + session.getUsername());
            }
        }
        if (!myProfile.equals((Object)Profile.Administrator)) {
            userSearch.setFeaturedType(null);
        }
        userSearch = (UserSearch)this.userSearchRepository.save((Object)userSearch);
        return new ResponseEntity((Object)userSearch.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Update a user search", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="updateCustomUserSearch")
    @RequestMapping(value={"/{searchIdentifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=204, message="User search  updated."), @ApiResponse(code=404, message="Resource not found.")})
    @ResponseBody
    public void updateCustomUserSearch(@ApiParam(value="User search identifier") @PathVariable Integer searchIdentifier, @ApiParam(value="User search details") @RequestBody UserSearchDto userSearchDto, @ApiIgnore HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        UserSearch existing = (UserSearch)this.userSearchRepository.findOne((Serializable)searchIdentifier);
        if (existing == null) {
            throw new ResourceNotFoundException(String.format(MSG_USERSEARCH_WITH_IDENTIFIER_NOT_FOUND, searchIdentifier));
        }
        UserSearch userSearch = userSearchDto.asUserSearch();
        if (myProfile.equals((Object)Profile.Administrator)) {
            this.userSearchRepository.save((Object)userSearch);
        } else if (userSearch.getCreator().getId() == session.getUserIdAsInt()) {
            userSearch.setFeaturedType(null);
            this.userSearchRepository.save((Object)userSearch);
        } else {
            throw new IllegalArgumentException("You don't have rights to update the user search");
        }
    }

    @ApiOperation(value="Delete a user search", notes="Deletes a user search by identifier.", nickname="deleteUserCustomSearch")
    @RequestMapping(value={"/{searchIdentifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public ResponseEntity<String> deleteUserCustomSerach(@ApiParam(value="Search identifier.") @PathVariable Integer searchIdentifier, @ApiIgnore HttpSession httpSession) {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        UserSearch userSearch = this.retrieveUserSearch(this.userSearchRepository, searchIdentifier);
        if (myProfile.equals((Object)Profile.Administrator)) {
            this.userSearchRepository.delete((Serializable)searchIdentifier);
        } else if (userSearch.getCreator().getId() == session.getUserIdAsInt()) {
            this.userSearchRepository.delete((Serializable)searchIdentifier);
        } else {
            throw new IllegalArgumentException("You don't have rights to delete the user search");
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private UserSearch retrieveUserSearch(UserSearchRepository userSearchRepository, Integer searchIdentifier) throws ResourceNotFoundEx {
        UserSearch userSearch = (UserSearch)userSearchRepository.findOne((Serializable)searchIdentifier);
        if (userSearch == null) {
            throw new ResourceNotFoundEx("User search not found");
        }
        return userSearch;
    }
}

