/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.users.model.MeResponse;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.AccessManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/me", "/{portal}/api/0.1/me"})
@Api(value="me", tags={"me"}, description="Me operations")
@Controller(value="me")
public class MeApi {
    @Autowired
    AccessManager accessManager;

    @ApiOperation(value="Get information about me", notes="If not authenticated, return status 204 (NO_CONTENT), else return basic user information. This operation is usually used to know if current user is authenticated or not.It returns also info about groups and profiles.", nickname="getMe")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ApiResponses(value={@ApiResponse(code=200, message="Authenticated. Return user details."), @ApiResponse(code=204, message="Not authenticated.")})
    @ResponseBody
    public ResponseEntity<MeResponse> getMe(@ApiIgnore @ApiParam(hidden=true) HttpSession session) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        if (userSession.isAuthenticated()) {
            MeResponse myInfos = new MeResponse().setId(userSession.getUserId()).setProfile(userSession.getProfile().name()).setUsername(userSession.getUsername()).setName(userSession.getName()).setSurname(userSession.getSurname()).setEmail(userSession.getEmailAddr()).setOrganisation(userSession.getOrganisation()).setAdmin(userSession.getProfile().equals((Object)Profile.Administrator)).setGroupsWithRegisteredUser(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.RegisteredUser)).setGroupsWithEditor(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).setGroupsWithReviewer(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Reviewer)).setGroupsWithUserAdmin(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.UserAdmin));
            return new ResponseEntity((Object)myInfos, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

