/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.selections;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.kernel.SelectionManager;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/selections", "/{portal}/api/0.1/selections"})
@Api(value="selections", tags={"selections"}, description="Selection related operations")
@Controller(value="selections")
public class SelectionsApi {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get current selection", nickname="getSelection")
    @RequestMapping(method={RequestMethod.GET}, value={"/{bucket}"}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> get(@ApiParam(value="Bucket name", required=true, example="metadata") @PathVariable String bucket, @ApiIgnore HttpSession httpSession) throws Exception {
        SelectionManager selectionManager = SelectionManager.getManager((UserSession)ApiUtils.getUserSession(httpSession));
        Set set = selectionManager.getSelection(bucket);
        synchronized (set) {
            return selectionManager.getSelection(bucket);
        }
    }

    @ApiOperation(value="Select one or more items", nickname="addToSelection")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{bucket}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Integer> add(@ApiParam(value="Bucket name", required=true, example="metadata") @PathVariable String bucket, @ApiParam(value="One or more record UUIDs. If null, select all in current search if bucket name is 'metadata' (TODO: remove this limitation?).", required=false) @RequestParam(required=false) String[] uuid, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            UserSession session = ApiUtils.getUserSession(httpSession);
            int nbSelected = SelectionManager.updateSelection((String)bucket, (UserSession)session, (String)(uuid != null ? "add" : "add-all"), uuid != null ? Arrays.asList(uuid) : null, (ServiceContext)context);
            ResponseEntity responseEntity = new ResponseEntity((Object)nbSelected, HttpStatus.CREATED);
            return responseEntity;
        }
    }

    @ApiOperation(value="Clear selection or remove items", nickname="clearSelection")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{bucket}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Integer> clear(@ApiParam(value="Selection bucket name", required=true, example="metadata") @PathVariable String bucket, @ApiParam(value="One or more record UUIDs", required=false) @RequestParam(required=false) String[] uuid, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            int nbSelected = SelectionManager.updateSelection((String)bucket, (UserSession)ApiUtils.getUserSession(httpSession), (String)(uuid != null ? "remove" : "remove-all"), uuid != null ? Arrays.asList(uuid) : null, (ServiceContext)context);
            ResponseEntity responseEntity = new ResponseEntity((Object)nbSelected, HttpStatus.OK);
            return responseEntity;
        }
    }
}

