/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.util.Arrays;
import java.util.List;

public enum FormatType {
    txt("text/plain"),
    html("text/html"),
    xml("application/xml"),
    json("application/json"),
    jsonld("application/vnd.schemaorg.ld+json"),
    pdf("application/pdf"),
    testpdf("application/test-pdf");

    public final String contentType;

    private FormatType(String contentType) {
        this.contentType = contentType;
    }

    public static FormatType find(String acceptHeader) {
        if (acceptHeader != null) {
            List<String> accept = Arrays.asList(acceptHeader.toLowerCase().split(","));
            for (String h : accept) {
                for (FormatType c : FormatType.values()) {
                    if (!h.startsWith(c.contentType)) continue;
                    return c;
                }
            }
        }
        return null;
    }
}

