/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.extent.ExtentDto;
import org.fao.geonet.api.regions.MetadataRegionDAO;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.XPath;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordExtent")
@ReadWriteController
public class MetadataExtentApi {
    public static final String MAP_SRS_PARAM = "mapsrs";
    public static final String GEOM_SRS_PARAM = "geomsrs";
    public static final String WIDTH_PARAM = "width";
    public static final String GEOM_PARAM = "geom";
    public static final String GEOM_TYPE_PARAM = "geomtype";
    public static final String HEIGHT_PARAM = "height";
    public static final String BACKGROUND_PARAM = "background";
    public static final String SETTING_BACKGROUND = "settings";
    public static final String WIDTH_AND_HEIGHT_BOTH_DEFINED_MESSAGE = String.format("Only one of %s and %s can be defined currently.  Future versions may support this but it is not supported at the moment", "width", "height");
    public static final String WIDTH_AND_HEIGHT_BOTH_MISSING_MESSAGE = String.format("One of %s or %s parameters must be included in the request", "width", "height");
    private static final String API_EXTENT_DESCRIPTION = "A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n";
    private static final String API_PARAM_MAP_SRS_DESCRIPTION = "(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326";
    private static final String API_PARAM_WIDTH_DESCRIPTION = "(optional) width of the image that is created. Only one of width and height are permitted";
    private static final String API_PARAM_HEIGHT_DESCRIPTION = "(optional) height of the image that is created. Only one of width and height are permitted";
    private static final String API_PARAM_BG_DESCRIPTION = "(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS GetMap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height";
    private static final String API_PARAM_FILL_DESCRIPTION = "(optional) Fill color with format RED,GREEN,BLUE,ALPHA";
    private static final String API_PARAM_STROKE_DESCRIPTION = "(optional) Stroke color with format RED,GREEN,BLUE,ALPHA";
    private static final String EXTENT_XPATH = ".//*[local-name() ='extent']/*/*[local-name() = 'geographicElement']/*";
    private static final String EXTENT_DESCRIPTION_XPATH = "ancestor::*[local-name() = 'EX_Extent']/*[local-name() = 'description']/*/text()";
    @Autowired
    private MetadataRegionDAO metadataRegionDAO;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private SettingManager settingManager;
    @Value(value="${metadata.extentApi.disableFullUrlBackgroundMapServices:true}")
    private boolean disableFullUrlBackgroundMapServices;

    @ApiOperation(value="Get all record extents as image", notes="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n", nickname="getAllRecordExtents")
    @RequestMapping(value={"/{metadataUuid}/extents.png"}, produces={"image/png"}, method={RequestMethod.GET})
    public HttpEntity<byte[]> getAllRecordExtentAsImage(@ApiParam(value="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @ApiParam(value="(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326") @RequestParam(value="mapsrs", required=false) String mapSrs, @ApiParam(value="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @ApiParam(value="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @ApiParam(value="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS GetMap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @ApiParam(value="(optional) Fill color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,50") String fillColor, @ApiParam(value="(optional) Stroke color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,255") String strokeColor, @ApiIgnore NativeWebRequest nativeWebRequest, @ApiIgnore HttpServletRequest request) throws Exception {
        String srs = mapSrs;
        if (StringUtils.isBlank((CharSequence)srs)) {
            srs = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("region/getmap/mapproj", true), (CharSequence)"EPSG:4326");
        }
        return this.getExtent(metadataUuid, srs, width, height, background, fillColor, strokeColor, null, nativeWebRequest, request);
    }

    @ApiOperation(value="Get list of record extents", notes="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n", nickname="getAllRecordExtentsAsJson")
    @RequestMapping(value={"/{metadataUuid}/extents.json"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ExtentDto> getAllRecordExtentAsJson(@ApiParam(value="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @ApiIgnore HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
            String schemaId = metadata.getDataInfo().getSchemaId();
            MetadataSchema schema = this.schemaManager.getSchema(schemaId);
            Element xmlData = metadata.getXmlData(false);
            List extentList = Xml.selectNodes((Element)xmlData, (String)EXTENT_XPATH, (List)schema.getNamespaces());
            ArrayList<ExtentDto> response = new ArrayList<ExtentDto>(extentList.size() + 1);
            if (!"iso19110".equals(schemaId)) {
                response.add(new ExtentDto(String.format("%sapi/records/%s/extents.png", this.settingManager.getNodeURL(), metadataUuid), "ALL", "", ""));
            }
            int index = 1;
            for (Object extent : extentList) {
                if (!(extent instanceof Element)) continue;
                Element extentElement = (Element)extent;
                String description = Xml.selectString((Element)extentElement, (String)EXTENT_DESCRIPTION_XPATH, (List)schema.getNamespaces());
                response.add(new ExtentDto(String.format("%sapi/records/%s/extents/%d.png", this.settingManager.getNodeURL(), metadataUuid, index), extentElement.getName(), XPath.getXPath((Element)xmlData, (Object)((Element)extent)), description));
                ++index;
            }
            ArrayList<ExtentDto> arrayList = response;
            return arrayList;
        }
    }

    @ApiOperation(value="Get one record extent as image", notes="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n", nickname="getOneRecordExtent")
    @RequestMapping(value={"/{metadataUuid}/extents/{geometryIndex}.png"}, produces={"image/png"}, method={RequestMethod.GET})
    public HttpEntity<byte[]> getOneRecordExtentAsImage(@ApiParam(value="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @ApiParam(value="Index of the geometry or bounding box to display. Starts at 1.") @PathVariable(value="geometryIndex") Integer geometryIndex, @ApiParam(value="(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326") @RequestParam(value="mapsrs", required=false) String mapSrs, @ApiParam(value="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @ApiParam(value="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @ApiParam(value="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS GetMap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @ApiParam(value="(optional) Fill color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,50") String fillColor, @ApiParam(value="(optional) Stroke color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,255") String strokeColor, @ApiIgnore NativeWebRequest nativeWebRequest, @ApiIgnore HttpServletRequest request) throws Exception {
        String srs = mapSrs;
        if (StringUtils.isBlank((CharSequence)srs)) {
            srs = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("region/getmap/mapproj", true), (CharSequence)"EPSG:4326");
        }
        return this.getExtent(metadataUuid, srs, width, height, background, fillColor, strokeColor, geometryIndex, nativeWebRequest, request);
    }

    /*
     * Exception decompiling
     */
    private HttpEntity<byte[]> getExtent(String metadataUuid, String srs, Integer width, Integer height, String background, String fillColor, String strokeColor, Integer extentOrderOfAppearance, NativeWebRequest nativeWebRequest, HttpServletRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

