/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.base.Joiner;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Source;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.schema.AssociatedResource;
import org.fao.geonet.kernel.schema.AssociatedResourcesSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.services.metadata.Show;
import org.fao.geonet.services.relations.Get;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtils {
    public static final boolean forEditing = false;
    public static final boolean withValidationErrors = false;
    public static final boolean keepXlinkAttributes = false;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.search");
    private static final String ORIGIN_PORTAL = "portal";
    private static final String ORIGIN_CATALOG = "catalog";
    private static final String ORIGIN_REMOTE = "remote";

    public static Element getRelated(ServiceContext context, int iId, String uuid, RelatedItemType[] type, int from_, int to_, boolean fast_) throws Exception {
        String origin;
        Element searchResult;
        String joinedUUIDs;
        Set<String> listOfUUIDs;
        Source portal;
        String id = String.valueOf(iId);
        String from = "" + from_;
        String to = "" + to_;
        String fast = "" + fast_;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        Element relatedRecords = new Element("relations");
        String portalFilter = "";
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        if (node != null && !"srv".equals(node.getId()) && (portal = (Source)sourceRepository.findOne((Serializable)((Object)node.getId()))) != null) {
            portalFilter = portal.getFilter();
        }
        if (type == null || type.length == 0) {
            type = (RelatedItemType[])RelatedItemType.class.getEnumConstants();
        }
        ArrayList<RelatedItemType> listOfTypes = new ArrayList<RelatedItemType>(Arrays.asList(type));
        Element md = Show.getCached(context.getUserSession(), id);
        if (md == null) {
            md = dm.getMetadata(context, id, false, false, false);
        }
        String schemaIdentifier = dm.getMetadataSchema(id);
        SchemaPlugin instance = SchemaManager.getSchemaPlugin((String)schemaIdentifier);
        AssociatedResourcesSchemaPlugin schemaPlugin = null;
        if (instance instanceof AssociatedResourcesSchemaPlugin) {
            schemaPlugin = (AssociatedResourcesSchemaPlugin)instance;
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.children)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(uuid, "children", context, from, to, fast, null, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.parent)) && (listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(md)).size() > 0) {
            joinedUUIDs = Joiner.on((String)" or ").join((Iterable)listOfUUIDs);
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "parent", context, from, to, fast, null, null, portalFilter));
        }
        if (schemaPlugin != null && listOfTypes.contains((Object)RelatedItemType.brothersAndSisters) && (listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(md)).size() > 0) {
            joinedUUIDs = Joiner.on((String)" or ").join((Iterable)listOfUUIDs);
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, RelatedItemType.brothersAndSisters.value(), context, from, to, fast, uuid, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.siblings))) {
            Element response = new Element("response");
            Set listOfAssociatedResources = schemaPlugin.getAssociatedResourcesUUIDs(md);
            if (listOfAssociatedResources != null) {
                for (AssociatedResource resource : listOfAssociatedResources) {
                    searchResult = MetadataUtils.search(resource.getUuid(), RelatedItemType.siblings.value(), context, from, to, fast, null, false);
                    origin = MetadataUtils.hasResult(searchResult) ? ORIGIN_PORTAL : ORIGIN_CATALOG;
                    Element sibContent = MetadataUtils.getRecord(resource.getUuid(), context, dm);
                    if (sibContent == null) continue;
                    Element sibling = new Element("sibling");
                    sibling.setAttribute("origin", origin);
                    sibling.setAttribute("initiative", resource.getInitiativeType());
                    sibling.setAttribute("association", resource.getAssociationType());
                    response.addContent((Content)sibling.addContent((Content)sibContent));
                }
            }
            relatedRecords.addContent((Content)new Element("siblings").addContent((Content)response));
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.associated)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(uuid, "associated", context, from, to, fast, null, null, portalFilter));
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.services)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(uuid, "services", context, from, to, fast, null, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.datasets) || listOfTypes.contains((Object)RelatedItemType.fcats) || listOfTypes.contains((Object)RelatedItemType.sources))) {
            if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.datasets)) {
                listOfUUIDs = new HashSet();
                HashSet<String> listOfRemoteDatasets = new HashSet<String>();
                Element result = MetadataUtils.search(uuid, "uuid", context, from, to, fast, null, "operatesOn", true);
                Element response = (Element)result.getChildren().get(0);
                Element mdResult = (Element)response.getChildren().get(0);
                List datasets = mdResult.getChildren("operatesOn");
                for (Element dataset : datasets) {
                    String refType;
                    String[] datasetInfo;
                    String datasetUuid;
                    if (!StringUtils.isNotEmpty((String)dataset.getValue()) || !StringUtils.isNotEmpty((String)(datasetUuid = (datasetInfo = dataset.getValue().split("\\|"))[0]))) continue;
                    String string = refType = datasetInfo.length > 1 ? datasetInfo[1] : "L";
                    if (!refType.equals("R")) {
                        listOfUUIDs.add(datasetUuid);
                        continue;
                    }
                    listOfRemoteDatasets.add(dataset.getValue());
                }
                if (!listOfUUIDs.isEmpty()) {
                    String joinedUUIDs2 = Joiner.on((String)" or ").join(listOfUUIDs);
                    relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs2, "datasets", context, from, to, fast, null, null, portalFilter));
                }
                if (!listOfRemoteDatasets.isEmpty()) {
                    if (relatedRecords.getChild("datasets") == null) {
                        relatedRecords.addContent((Content)new Element("datasets").addContent((Content)new Element("response")));
                    }
                    for (String remoteDataset : listOfRemoteDatasets) {
                        String[] remoteDatasetInfo = remoteDataset.split("\\|");
                        if (remoteDatasetInfo.length > 4) {
                            Element metadata = new Element("metadata");
                            metadata.setAttribute("origin", ORIGIN_REMOTE);
                            metadata.addContent((Content)new Element("uuid").setText(remoteDatasetInfo[0]));
                            metadata.addContent((Content)new Element("title").setText(remoteDatasetInfo[2]));
                            metadata.addContent((Content)new Element("abstract").setText(remoteDatasetInfo[3]));
                            metadata.addContent((Content)new Element("url").setText(remoteDatasetInfo[4]));
                            relatedRecords.getChild("datasets").getChild("response").addContent((Content)metadata);
                            continue;
                        }
                        Log.warning((String)"geonetwork.search", (Object)("Remote dataset incomplete for uuid : " + uuid + " " + remoteDataset));
                    }
                }
            }
            if ((listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.sources)) && (listOfUUIDs = schemaPlugin.getAssociatedSourceUUIDs(md)) != null && listOfUUIDs.size() > 0) {
                joinedUUIDs = Joiner.on((String)" or ").join(listOfUUIDs);
                relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "sources", context, from, to, fast, null, null, portalFilter));
            }
            if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.fcats)) {
                listOfUUIDs = schemaPlugin.getAssociatedFeatureCatalogueUUIDs(md);
                Element fcat = null;
                if (listOfUUIDs != null && listOfUUIDs.size() > 0) {
                    fcat = new Element("fcats");
                    for (String fcat_uuid : listOfUUIDs) {
                        searchResult = MetadataUtils.search(fcat_uuid, RelatedItemType.fcats.value(), context, from, to, fast, null, false);
                        origin = MetadataUtils.hasResult(searchResult) ? ORIGIN_PORTAL : ORIGIN_CATALOG;
                        Element metadata = new Element("metadata");
                        Element response = new Element("response");
                        Element current = MetadataUtils.getRecord(fcat_uuid, context, dm);
                        if (current != null) {
                            metadata.setAttribute("origin", origin);
                            metadata.addContent((Content)current);
                        } else {
                            LOGGER.error("Feature catalogue with UUID {} referenced in {} was not found.", (Object)fcat_uuid, (Object)uuid);
                        }
                        response.addContent((Content)metadata);
                        fcat.addContent((Content)response);
                    }
                }
                if (fcat != null) {
                    relatedRecords.addContent(fcat);
                }
            }
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.hassources)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(uuid, "hassources", context, from, to, fast, null, null, portalFilter));
        }
        if (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.related)) {
            relatedRecords.addContent((Content)new Element("related").addContent((Content)Get.getRelation(iId, "full", context)));
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(uuid, "hasfeaturecats", context, from, to, fast, null, null, portalFilter));
        }
        if (md != null && (listOfTypes.size() == 0 || listOfTypes.contains((Object)RelatedItemType.onlines) || listOfTypes.contains((Object)RelatedItemType.thumbnails))) {
            relatedRecords.addContent((Content)new Element("metadata").addContent((Content)md.clone()));
        }
        return relatedRecords;
    }

    private static Element search(String uuid, String type, ServiceContext context, String from, String to, String fast, String exclude, boolean ignorePortalFilter) throws Exception {
        return MetadataUtils.search(uuid, type, context, from, to, fast, exclude, null, ignorePortalFilter);
    }

    private static Element search(String uuid, String type, ServiceContext context, String from, String to, String fast, String exclude, String extraDumpFields, boolean ignorePortalFilter) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Searching for: " + type));
        }
        try (MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
            Element parameters = new Element("request");
            if ("children".equals(type)) {
                parameters.addContent((Content)new Element("parentUuid").setText(uuid));
            } else if ("brothersAndSisters".equals(type)) {
                parameters.addContent((Content)new Element("parentUuid").setText(uuid));
            } else if ("services".equals(type)) {
                parameters.addContent((Content)new Element("operatesOn").setText(uuid + " or " + uuid + "|*"));
            } else if ("hasfeaturecats".equals(type)) {
                parameters.addContent((Content)new Element("hasfeaturecat").setText(uuid));
            } else if ("hassources".equals(type)) {
                parameters.addContent((Content)new Element("hassource").setText(uuid));
            } else if ("associated".equals(type)) {
                parameters.addContent((Content)new Element("agg_associated").setText(uuid));
                parameters.addContent((Content)new Element("extraDumpFields").setText("agg_*"));
            } else if ("datasets".equals(type) || "fcats".equals(type) || "sources".equals(type) || "siblings".equals(type) || "parent".equals(type) || "uuid".equals(type)) {
                parameters.addContent((Content)new Element("uuid").setText(uuid));
            }
            if (exclude != null) {
                parameters.addContent((Content)new Element("without__uuid").setText(exclude));
            }
            if (StringUtils.isNotEmpty((String)extraDumpFields)) {
                parameters.addContent((Content)new Element("extraDumpFields").addContent(extraDumpFields));
            }
            parameters.addContent((Content)new Element("fast").addContent("index"));
            parameters.addContent((Content)new Element("sortBy").addContent("title"));
            parameters.addContent((Content)new Element("sortOrder").addContent("reverse"));
            parameters.addContent((Content)new Element("buildSummary").addContent("false"));
            parameters.addContent((Content)new Element("from").addContent(from));
            parameters.addContent((Content)new Element("to").addContent(to));
            ServiceConfig config = new ServiceConfig();
            config.setValue("ignorePortalFilter", ignorePortalFilter + "");
            searcher.search(context, parameters, config);
            Element response = new Element(type.equals("brothersAndSisters") ? "siblings" : type);
            Element relatedElement = searcher.present(context, parameters, config);
            response.addContent((Content)relatedElement);
            Element element = response;
            return element;
        }
    }

    /*
     * Exception decompiling
     */
    public static Set<String> getUuidsToExport(String uuid, HttpServletRequest request, Element query) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Element getRecord(String uuid, ServiceContext context, DataManager dm) {
        Element content;
        block2: {
            content = null;
            try {
                String id = dm.getMetadataId(uuid);
                Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
                content = dm.getMetadata(context, id, false, false, false);
            }
            catch (Exception e) {
                if (!Log.isDebugEnabled((String)"geonetwork.search")) break block2;
                Log.debug((String)"geonetwork.search", (Object)("Metadata " + uuid + " record is not visible for user."));
            }
        }
        return content;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void backupRecord(AbstractMetadata metadata, ServiceContext context) {
        Path outFile;
        Log.trace((String)"geonetwork.datamanager", (Object)("Backing up record " + metadata.getId()));
        Path outDir = Lib.resource.getRemovedDir(metadata.getId());
        try {
            outFile = outDir.resolve(URLEncoder.encode(metadata.getUuid(), Constants.ENCODING) + ".zip");
        }
        catch (UnsupportedEncodingException e1) {
            outFile = outDir.resolve(String.format("backup-%s-%s.mef", new Date(), metadata.getUuid()));
        }
        Path file = null;
        try {
            file = MEFLib.doExport((ServiceContext)context, (String)metadata.getUuid(), (String)"full", (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            Files.createDirectories(outDir, new FileAttribute[0]);
            try (InputStream is = IO.newInputStream((Path)file);
                 OutputStream os = Files.newOutputStream(outFile, new OpenOption[0]);){
                BinaryFile.copy((InputStream)is, (OutputStream)os);
            }
            if (file == null) return;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Error performing backup on record '" + metadata.getUuid() + "'. Contact the system administrator if the problem persists: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (file == null) throw throwable;
                IO.deleteFile(file, (boolean)false, (String)"geonetwork.mef");
                throw throwable;
            }
        }
        IO.deleteFile((Path)file, (boolean)false, (String)"geonetwork.mef");
        return;
    }

    public static boolean retrieveMetadataValidationStatus(AbstractMetadata metadata, ServiceContext context) throws Exception {
        boolean hasValidation;
        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
        IMetadataValidator validator = (IMetadataValidator)context.getBean(IMetadataValidator.class);
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        boolean bl = hasValidation = metadataValidationRepository.count(MetadataValidationSpecs.hasMetadataId((int)metadata.getId())) > 0L;
        if (!hasValidation) {
            validator.doValidate(metadata, context.getLanguage());
            dataManager.indexMetadata(metadata.getId() + "", true, null);
        }
        boolean isInvalid = metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)metadata.getId())) > 0L;
        return isInvalid;
    }

    private static boolean hasResult(Element searchResponse) {
        Element containerResults;
        return searchResponse.getChildren().size() > 0 && (containerResults = (Element)searchResponse.getChildren().get(0)).getChildren().size() > 0;
    }

    private static Element calculateResults(String uuid, String type, ServiceContext context, String from, String to, String fast, String exclude, String extraDumpFields, String portalFilter) throws Exception {
        Element results = MetadataUtils.search(uuid, type, context, from, to, fast, exclude, extraDumpFields, true);
        if (StringUtils.isNotEmpty((String)portalFilter)) {
            Element resultsForPortal = MetadataUtils.search(uuid, type, context, from, to, fast, exclude, null, false);
            HashSet<String> portalResultsUuids = new HashSet<String>();
            for (Element r : resultsForPortal.getChild("response").getChildren()) {
                String uuidValue = r.getChild("info", Geonet.Namespaces.GEONET).getChildText("uuid");
                portalResultsUuids.add(uuidValue);
            }
            for (Element r : results.getChild("response").getChildren()) {
                String origin = ORIGIN_CATALOG;
                String uuidValue = r.getChild("info", Geonet.Namespaces.GEONET).getChildText("uuid");
                if (portalResultsUuids.contains(uuidValue)) {
                    origin = ORIGIN_PORTAL;
                }
                r.setAttribute("origin", origin);
            }
        } else {
            for (Element r : results.getChild("response").getChildren()) {
                r.setAttribute("origin", ORIGIN_PORTAL);
            }
        }
        return results;
    }
}

