/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jeeves.server.context.ServiceContext;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.records.editing.InspireValidatorUtils;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterApi;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.transaction.TransactionStatus;

@ManagedResource
public class MInspireEtfValidateProcess
implements SelfNaming {
    private final ApplicationContext appContext;
    private ServiceContext validationServiceContext;
    private final String URL;
    private final String URL_QUERY;
    private ObjectName probeName;
    private int metadataToAnalyseCount = -1;
    private int metadataAnalysed = 0;
    private int metadataNotInspire = 0;
    private int metadataNotAllowed = 0;
    private int metadataAnalysedInError = 0;
    private long deleteAllDate = Long.MAX_VALUE;
    private long analyseMdDate = Long.MAX_VALUE;

    @ManagedAttribute
    public int getMetadataToAnalyseCount() {
        return this.metadataToAnalyseCount;
    }

    @ManagedAttribute
    public int getMetadataAnalysed() {
        return this.metadataAnalysed;
    }

    @ManagedAttribute
    public int getMetadataNotInspire() {
        return this.metadataNotInspire;
    }

    @ManagedAttribute
    public int getMetadataNotAllowed() {
        return this.metadataNotAllowed;
    }

    @ManagedAttribute
    public int getMetadataAnalysedInError() {
        return this.metadataAnalysedInError;
    }

    @ManagedAttribute
    public long getDeleteAllDate() {
        return this.deleteAllDate;
    }

    @ManagedAttribute
    public long getAnalyseMdDate() {
        return this.analyseMdDate;
    }

    @ManagedAttribute
    public ObjectName getObjectName() {
        return this.probeName;
    }

    public MInspireEtfValidateProcess(String URL2, String URL_QUERY, ServiceContext serviceContext, ApplicationContext appContext) {
        this.URL = URL2;
        this.URL_QUERY = URL_QUERY;
        this.validationServiceContext = serviceContext;
        this.appContext = appContext;
        try {
            this.probeName = new ObjectName(String.format("geonetwork:name=batch-etf-inspire,idx=%s", this.hashCode()));
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
    }

    public void deleteAll() {
        this.runInNewTransaction("minspireetfvalidate-deleteall", new TransactionTask<Object>(){

            public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                MInspireEtfValidateProcess.this.deleteAllDate = System.currentTimeMillis();
                return null;
            }
        });
    }

    protected ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.get();
        return context != null ? context : this.validationServiceContext;
    }

    public void processMetadata(Set<String> uuids) throws Exception {
        IMetadataUtils metadataRepository = (IMetadataUtils)this.appContext.getBean(IMetadataUtils.class);
        final MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)this.appContext.getBean(MetadataValidationRepository.class);
        AccessManager accessManager = (AccessManager)this.appContext.getBean(AccessManager.class);
        final InspireValidatorUtils inspireValidatorUtils = (InspireValidatorUtils)this.appContext.getBean(InspireValidatorUtils.class);
        final SchemaManager schemaManager = (SchemaManager)this.appContext.getBean(SchemaManager.class);
        final DataManager dataManager = (DataManager)this.appContext.getBean(DataManager.class);
        final IMetadataSchemaUtils metadataSchemaUtils = (IMetadataSchemaUtils)this.appContext.getBean(IMetadataSchemaUtils.class);
        this.metadataToAnalyseCount = uuids.size();
        this.analyseMdDate = System.currentTimeMillis();
        final ServiceContext context = this.getServiceContext();
        for (String uuid : uuids) {
            if (!metadataRepository.existsMetadataUuid(uuid)) {
                ++this.metadataAnalysed;
                ++this.metadataNotAllowed;
                continue;
            }
            for (final AbstractMetadata record : metadataRepository.findAllByUuid(uuid)) {
                try {
                    if (!accessManager.canEdit(context, String.valueOf(record.getId()))) {
                        ++this.metadataAnalysed;
                        ++this.metadataNotAllowed;
                        continue;
                    }
                    this.runInNewTransaction("minspireetfvalidate-process-metadata", new TransactionTask<Object>(){

                        public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                            Map<String, String> testsuiteConditions = inspireValidatorUtils.calculateTestsuitesToApply(record.getDataInfo().getSchemaId(), metadataSchemaUtils);
                            boolean reindexMetadata = false;
                            String mdToValidate = MInspireEtfValidateProcess.this.retrieveMetadataToValidate(context, record);
                            try {
                                boolean inspireMetadata = false;
                                if (StringUtils.isNotEmpty((String)mdToValidate)) {
                                    for (Map.Entry<String, String> entry : testsuiteConditions.entrySet()) {
                                        boolean applyCondition = false;
                                        try {
                                            applyCondition = Xml.selectBoolean((Element)record.getXmlData(false), (String)entry.getValue(), (List)schemaManager.getSchema(record.getDataInfo().getSchemaId()).getNamespaces());
                                        }
                                        catch (Exception ex) {
                                            Log.error((String)"geonetwork.api", (Object)String.format("Error checking INSPIRE rule %s to apply to metadata: %s", entry.getKey(), record.getUuid()), (Throwable)ex);
                                        }
                                        if (!applyCondition) continue;
                                        String testId = inspireValidatorUtils.submitFile(context, MInspireEtfValidateProcess.this.URL, MInspireEtfValidateProcess.this.URL_QUERY, new ByteArrayInputStream(mdToValidate.getBytes()), entry.getKey(), record.getUuid());
                                        inspireValidatorUtils.waitUntilReady(context, MInspireEtfValidateProcess.this.URL, testId);
                                        String reportUrl = inspireValidatorUtils.getReportUrl(MInspireEtfValidateProcess.this.URL, testId);
                                        String reportXmlUrl = InspireValidatorUtils.getReportUrlXML(MInspireEtfValidateProcess.this.URL, testId);
                                        String reportXml = inspireValidatorUtils.retrieveReport(context, reportXmlUrl);
                                        String validationStatus = inspireValidatorUtils.isPassed(context, MInspireEtfValidateProcess.this.URL, testId);
                                        MetadataValidationStatus metadataValidationStatus = inspireValidatorUtils.calculateValidationStatus(validationStatus);
                                        MetadataValidation metadataValidation = new MetadataValidation().setId(new MetadataValidationId(record.getId(), "inspire")).setStatus(metadataValidationStatus).setRequired(Boolean.valueOf(false)).setReportUrl(reportUrl).setReportContent(reportXml);
                                        metadataValidationRepository.save((Object)metadataValidation);
                                        reindexMetadata = true;
                                        inspireMetadata = true;
                                    }
                                }
                                if (!inspireMetadata) {
                                    MInspireEtfValidateProcess.this.metadataNotInspire++;
                                    MetadataValidation metadataValidation = new MetadataValidation().setId(new MetadataValidationId(record.getId(), "inspire")).setStatus(MetadataValidationStatus.DOES_NOT_APPLY).setRequired(Boolean.valueOf(false));
                                    metadataValidationRepository.save((Object)metadataValidation);
                                    reindexMetadata = true;
                                }
                                if (reindexMetadata) {
                                    dataManager.indexMetadata(new ArrayList<String>(Arrays.asList(record.getId() + "")));
                                }
                            }
                            catch (Exception ex) {
                                MInspireEtfValidateProcess.this.metadataAnalysedInError++;
                                Log.error((String)"geonetwork.api", (Object)String.format("Error validating metadata %s in INSPIRE validator: %s", record.getUuid(), ex.getMessage()), (Throwable)ex);
                            }
                            MInspireEtfValidateProcess.this.metadataAnalysed++;
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    ++this.metadataAnalysedInError;
                    Log.error((String)"geonetwork.api", (Object)String.format("Error validating metadata %s in INSPIRE validator: %s", record.getUuid(), ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    private final void runInNewTransaction(String name, TransactionTask<Object> transactionTask) {
        TransactionManager.runInTransaction((String)name, (ApplicationContext)this.appContext, (TransactionManager.TransactionRequirement)TransactionManager.TransactionRequirement.CREATE_NEW, (TransactionManager.CommitBehavior)TransactionManager.CommitBehavior.ALWAYS_COMMIT, (boolean)false, transactionTask);
    }

    private String retrieveMetadataToValidate(ServiceContext context, AbstractMetadata record) {
        String mdToValidate = null;
        if (!record.getDataInfo().getSchemaId().equals("iso19139")) {
            try {
                Key key = new Key(record.getId(), "eng", FormatType.xml, "iso19139", true, FormatterWidth._100);
                FormatterApi formatterApi = new FormatterApi();
                formatterApi.getClass();
                FormatterApi.FormatMetadata formatMetadata = formatterApi.new FormatterApi.FormatMetadata(context, key, null);
                byte[] data = formatMetadata.call().data;
                mdToValidate = new String(data, StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                Log.error((String)"geonetwork.api", (Object)String.format("Error converting metadata %s to ISO19139 for INSPIRE validator: %s", record.getUuid(), ex.getMessage()), (Throwable)ex);
            }
        } else {
            mdToValidate = record.getData();
        }
        return mdToValidate;
    }
}

