/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.links;

import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.management.MalformedObjectNameException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.links.EmptySlot;
import org.fao.geonet.api.links.LinkAnalysisReport;
import org.fao.geonet.api.links.MAnalyseProcess;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.exceptions.OperationNotAllowedEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.url.UrlAnalyzer;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.specification.LinkSpecs;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.annotations.ApiIgnore;

@EnableWebMvc
@Service
@RestController
@RequestMapping(value={"/{portal}/api/records/links", "/{portal}/api/0.1/records/links"})
@Api(value="links", tags={"links"}, description="Record link operations")
public class LinksApi {
    private static final int NUMBER_OF_SUBSEQUENT_PROCESS_MBEAN_TO_KEEP = 5;
    @Autowired
    protected ApplicationContext appContext;
    @Autowired
    LinkRepository linkRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    DataManager dataManager;
    @Autowired
    UrlAnalyzer urlAnalyser;
    @Autowired
    MBeanExporter mBeanExporter;
    @Autowired
    AccessManager accessManager;
    private ArrayDeque<SelfNaming> mAnalyseProcesses = new ArrayDeque(5);

    @PostConstruct
    public void iniMBeansSlidingWindowWithEmptySlot() {
        for (int i = 0; i < 5; ++i) {
            EmptySlot emptySlot = new EmptySlot(i);
            this.mAnalyseProcesses.addFirst(emptySlot);
            try {
                this.mBeanExporter.registerManagedResource((Object)emptySlot, emptySlot.getObjectName());
                continue;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
    }

    @ApiOperation(value="Get record links", notes="", nickname="getRecordLinks")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", dataType="integer", paramType="query", value="Results page you want to retrieve (0..N)"), @ApiImplicitParam(name="size", dataType="integer", paramType="query", value="Number of records per page."), @ApiImplicitParam(name="sort", allowMultiple=false, dataType="string", paramType="query", value="Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. ")})
    @GetMapping(produces={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Page<Link> getRecordLinks(@ApiParam(value="Filter, e.g. \"{url: 'png', lastState: 'ko', records: 'e421', groupId: 12}\", lastState being 'ok'/'ko'/'unknown'", required=false) @RequestParam(required=false) JSONObject filter, @ApiParam(value="Optional, filter links to records published in that group.", required=false) @RequestParam(required=false) Integer[] groupIdFilter, @ApiParam(value="Optional, filter links to records created in that group.", required=false) @RequestParam(required=false) Integer[] groupOwnerIdFilter, @ApiIgnore Pageable pageRequest, @ApiParam(hidden=true) @ApiIgnore HttpSession session, @ApiParam(hidden=true) @ApiIgnore HttpServletRequest request) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        return this.getLinks(filter, groupIdFilter, groupOwnerIdFilter, pageRequest, userSession);
    }

    private Page<Link> getLinks(JSONObject filter, Integer[] groupIdFilter, Integer[] groupOwnerIdFilter, Pageable pageRequest, UserSession userSession) throws SQLException, JSONException {
        List editingGroupList;
        Integer[] editingGroups = null;
        if (userSession.getProfile() != Profile.Administrator && (editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).size() > 0) {
            editingGroups = editingGroupList.toArray(new Integer[editingGroupList.size()]);
        }
        if (filter == null && (groupIdFilter != null || groupOwnerIdFilter != null || editingGroups != null)) {
            return this.linkRepository.findAll(LinkSpecs.filter(null, null, null, (Integer[])groupIdFilter, (Integer[])groupOwnerIdFilter, editingGroups), pageRequest);
        }
        if (filter != null) {
            Integer stateToMatch = null;
            String url = null;
            String associatedRecord = null;
            if (filter.has("lastState")) {
                stateToMatch = 0;
                if (filter.getString("lastState").equalsIgnoreCase("ok")) {
                    stateToMatch = 1;
                } else if (filter.getString("lastState").equalsIgnoreCase("ko")) {
                    stateToMatch = -1;
                }
            }
            if (filter.has("url")) {
                url = filter.getString("url");
            }
            if (filter.has("records")) {
                associatedRecord = filter.getString("records");
            }
            return this.linkRepository.findAll(LinkSpecs.filter((String)url, (Integer)stateToMatch, (String)associatedRecord, (Integer[])groupIdFilter, (Integer[])groupOwnerIdFilter, (Integer[])editingGroups), pageRequest);
        }
        return this.linkRepository.findAll(pageRequest);
    }

    @ApiOperation(value="Get record links as CSV", notes="", nickname="getRecordLinksAsCSV")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", dataType="integer", paramType="query", value="Results page you want to retrieve (0..N)"), @ApiImplicitParam(name="size", dataType="integer", paramType="query", value="Number of records per page."), @ApiImplicitParam(name="sort", allowMultiple=false, dataType="string", paramType="query", value="Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. ")})
    @RequestMapping(path={"/csv"}, method={RequestMethod.GET}, produces={"text/plain"})
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public void getRecordLinksAsCsv(@ApiParam(value="Filter, e.g. \"{url: 'png', lastState: 'ko', records: 'e421', groupId: 12}\", lastState being 'ok'/'ko'/'unknown'", required=false) @RequestParam(required=false) JSONObject filter, @ApiParam(value="Optional, filter links to records published in that group.", required=false) @RequestParam(required=false) Integer[] groupIdFilter, @ApiParam(value="Optional, filter links to records created in that group.", required=false) @RequestParam(required=false) Integer[] groupOwnerIdFilter, @ApiIgnore Pageable pageRequest, @ApiParam(hidden=true) @ApiIgnore HttpSession session, @ApiParam(hidden=true) @ApiIgnore HttpServletResponse response) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        Page<Link> links = this.getLinks(filter, groupIdFilter, groupOwnerIdFilter, pageRequest, userSession);
        response.setHeader("Content-disposition", "attachment; filename=links.csv");
        LinkAnalysisReport.create(links, response.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Analyze records links", notes="One of uuids or bucket parameter is required if not an Administrator. Only records that you can edit will be validated.", nickname="analyzeRecordLinks")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport analyzeRecordLinks(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Only allowed if Administrator.") @RequestParam(required=false, defaultValue="true") boolean removeFirst, @RequestParam(required=false, defaultValue="false") boolean analyze, @ApiIgnore HttpSession httpSession, @ApiIgnore HttpServletRequest request) throws IOException, JDOMException {
        try (ServiceContext serviceContext = ApiUtils.createServiceContext(request);){
            boolean isAdministrator;
            MAnalyseProcess registredMAnalyseProcess = this.getRegistredMAnalyseProcess();
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean bl = isAdministrator = session.getProfile() == Profile.Administrator;
            if (isAdministrator && removeFirst) {
                registredMAnalyseProcess.deleteAll();
            }
            SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
            HashSet ids = Sets.newHashSet();
            if (uuids != null || StringUtils.isNotEmpty((String)bucket)) {
                try {
                    Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
                    for (String uuid : records) {
                        if (!this.metadataUtils.existsMetadataUuid(uuid)) {
                            report.incrementNullRecords();
                        }
                        for (AbstractMetadata record : this.metadataRepository.findAllByUuid(uuid)) {
                            if (!this.accessManager.canEdit(serviceContext, String.valueOf(record.getId()))) {
                                report.addNotEditableMetadataId(record.getId());
                                continue;
                            }
                            ids.add(record.getId());
                            report.addMetadataId(record.getId());
                            report.incrementProcessedRecords();
                        }
                    }
                }
                catch (Exception e) {
                    report.addError(e);
                }
                finally {
                    report.close();
                }
            } else {
                if (isAdministrator) {
                    List metadataList = this.metadataRepository.findAll();
                    for (Metadata m : metadataList) {
                        ids.add(m.getId());
                        report.addMetadataId(m.getId());
                        report.incrementProcessedRecords();
                    }
                } else {
                    throw new OperationNotAllowedEx(String.format("Only administrator can trigger link analysis on the entire catalogue. This is not allowed for %s.", session.getProfile()));
                }
                report.close();
            }
            registredMAnalyseProcess.processMetadataAndTestLink(analyze, ids);
            SimpleMetadataProcessingReport simpleMetadataProcessingReport = report;
            return simpleMetadataProcessingReport;
        }
    }

    @ApiOperation(value="Remove all links and status history", notes="", nickname="purgeAll")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseBody
    public ResponseEntity purgeAll() throws IOException, JDOMException {
        this.urlAnalyser.deleteAll();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private MAnalyseProcess getRegistredMAnalyseProcess() {
        MAnalyseProcess mAnalyseProcess = new MAnalyseProcess(this.linkRepository, this.metadataRepository, this.urlAnalyser, this.appContext);
        this.mBeanExporter.registerManagedResource((Object)mAnalyseProcess, mAnalyseProcess.getObjectName());
        try {
            this.mBeanExporter.unregisterManagedResource(this.mAnalyseProcesses.removeLast().getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        this.mAnalyseProcesses.addFirst(mAnalyseProcess);
        return mAnalyseProcess;
    }
}

