/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecord;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class TrafficControllerPoolRecordDetailListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<TrafficControllerPoolRecordDetail>> {
    private final ImmutableSet.Builder<TrafficControllerPoolRecordDetail> records = ImmutableSet.builder();

    public FluentIterable<TrafficControllerPoolRecordDetail> getResult() {
        return FluentIterable.from((Iterable)this.records.build());
    }

    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (!SaxUtils.equalsOrSuffix((String)qName, (String)"PoolRecordData")) {
            return;
        }
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        TrafficControllerPoolRecord record = TrafficControllerPoolRecord.create((String)attributes.get("recordType"), (String)attributes.get("pointsTo"));
        this.records.add((Object)TrafficControllerPoolRecordDetail.builder().id((String)attributes.get("poolRecordID")).poolId((String)attributes.get("poolId")).record(record).weight(Integer.parseInt((String)Preconditions.checkNotNull(attributes.get("weight"), (Object)"weight"))).priority(Integer.parseInt((String)Preconditions.checkNotNull(attributes.get("priority"), (Object)"priority"))).forceAnswer((String)attributes.get("forceAnswer")).probingEnabled("ENABLED".equalsIgnoreCase((String)attributes.get("probing"))).status(TrafficControllerPoolRecordDetail.Status.valueOf((String)attributes.get("status"))).serving("Yes".equalsIgnoreCase((String)attributes.get("serving"))).description((String)attributes.get("description")).build());
    }
}

