/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.binders.UpdatePoolRecordToXML;
import org.jclouds.ultradns.ws.domain.PoolRecordSpec;
import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.UpdatePoolRecord;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.internal.TrafficControllerPoolRecordTypeToString;
import org.jclouds.ultradns.ws.xml.AttributeHandler;
import org.jclouds.ultradns.ws.xml.ElementTextHandler;
import org.jclouds.ultradns.ws.xml.PoolRecordSpecHandler;
import org.jclouds.ultradns.ws.xml.TrafficControllerPoolListHandler;
import org.jclouds.ultradns.ws.xml.TrafficControllerPoolRecordDetailListHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface TrafficControllerPoolApi {
    @Named(value="addTCLBPool")
    @POST
    @XMLResponseParser(value=ElementTextHandler.TCPoolID.class)
    @Payload(value="<v01:addTCLBPool><transactionID /><zoneName>{zoneName}</zoneName><hostName>{hostName}</hostName><description>{description}</description><poolRecordType>{poolRecordType}</poolRecordType><failOver>Enabled</failOver><probing>Enabled</probing><maxActive>0</maxActive><rrGUID /></v01:addTCLBPool>")
    public String createForDNameAndType(@PayloadParam(value="description") String var1, @PayloadParam(value="hostName") String var2, @PayloadParam(value="poolRecordType") @ParamParser(value=TrafficControllerPoolRecordTypeToString.class) int var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="getLoadBalancingPoolsByZone")
    @POST
    @XMLResponseParser(value=TrafficControllerPoolListHandler.class)
    @Payload(value="<v01:getLoadBalancingPoolsByZone><zoneName>{zoneName}</zoneName><lbPoolType>TC</lbPoolType></v01:getLoadBalancingPoolsByZone>")
    public FluentIterable<TrafficControllerPool> list() throws ResourceNotFoundException;

    @Named(value="getPoolRecords")
    @POST
    @XMLResponseParser(value=TrafficControllerPoolRecordDetailListHandler.class)
    @Payload(value="<v01:getPoolRecords><poolId>{poolId}</poolId></v01:getPoolRecords>")
    public FluentIterable<TrafficControllerPoolRecordDetail> listRecords(@PayloadParam(value="poolId") String var1) throws ResourceNotFoundException;

    @Nullable
    @Named(value="getPoolForPoolHostName>")
    @POST
    @Payload(value="<v01:getPoolForPoolHostName><hostName>{hostName}</hostName></v01:getPoolForPoolHostName>")
    @XMLResponseParser(value=AttributeHandler.PoolName.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String getNameByDName(@PayloadParam(value="hostName") String var1);

    @Named(value="deleteLBPool")
    @POST
    @Payload(value="<v01:deleteLBPool><transactionID /><lbPoolID>{lbPoolID}</lbPoolID><DeleteAll>Yes</DeleteAll><retainRecordId /></v01:deleteLBPool>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PayloadParam(value="lbPoolID") String var1);

    @Named(value="addPoolRecord")
    @POST
    @XMLResponseParser(value=ElementTextHandler.PoolRecordID.class)
    @Payload(value="<v01:addPoolRecord><transactionID /><poolID>{poolID}</poolID><pointsTo>{pointsTo}</pointsTo><priority /><failOverDelay /><ttl>{ttl}</ttl><weight /><mode /><threshold /></v01:addPoolRecord>")
    public String addRecordToPoolWithTTL(@PayloadParam(value="pointsTo") String var1, @PayloadParam(value="poolID") String var2, @PayloadParam(value="ttl") int var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="addPoolRecord")
    @POST
    @XMLResponseParser(value=ElementTextHandler.PoolRecordID.class)
    @Payload(value="<v01:addPoolRecord><transactionID /><poolID>{poolID}</poolID><pointsTo>{pointsTo}</pointsTo><priority /><failOverDelay /><ttl>{ttl}</ttl><weight>{weight}</weight><mode /><threshold /></v01:addPoolRecord>")
    public String addRecordToPoolWithTTLAndWeight(@PayloadParam(value="pointsTo") String var1, @PayloadParam(value="poolID") String var2, @PayloadParam(value="ttl") int var3, @PayloadParam(value="weight") int var4) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="getPoolRecordSpec>")
    @POST
    @Payload(value="<v01:getPoolRecordSpec><poolRecordId>{poolRecordId}</poolRecordId></v01:getPoolRecordSpec>")
    @XMLResponseParser(value=PoolRecordSpecHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public PoolRecordSpec getRecordSpec(@PayloadParam(value="poolRecordId") String var1);

    @Named(value="updatePoolRecord>")
    @POST
    @MapBinder(value=UpdatePoolRecordToXML.class)
    public void updateRecord(@PayloadParam(value="poolRecordID") String var1, @PayloadParam(value="update") UpdatePoolRecord var2) throws ResourceNotFoundException;

    @Named(value="deletePoolRecord")
    @POST
    @Payload(value="<v01:deletePoolRecord><transactionID /><poolRecordID>{poolRecordID}</poolRecordID><parentPoolId /><childPoolId /></v01:deletePoolRecord>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteRecord(@PayloadParam(value="poolRecordID") String var1);
}

