/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

interface Condition {
    public static final long PARK_TIMEOUT = 50L;
    public static final int MAX_PROG_YIELD = 2000;

    public boolean test();

    public void awaitNanos(long var1) throws InterruptedException;

    public void await() throws InterruptedException;

    public void signal();

    /*
     * Enabled aggressive block sorting
     */
    public static int progressiveYield(int n) {
        if (n <= 500) {
            Condition.onSpinWait();
            return n + 1;
        }
        if (n < 1000) {
            if ((n & 7) == 0) {
                LockSupport.parkNanos(50L);
                return n + 1;
            }
            Condition.onSpinWait();
            return n + 1;
        }
        if (n >= 2000) {
            Thread.yield();
            return n;
        }
        if ((n & 3) == 0) {
            Thread.yield();
            return n + 1;
        }
        Condition.onSpinWait();
        return n + 1;
    }

    public static void onSpinWait() {
    }

    public static boolean waitStatus(long timeout, TimeUnit unit, Condition condition) throws InterruptedException {
        long timeoutNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long expireTime = System.nanoTime() + timeoutNanos;
        while (condition.test()) {
            long now = System.nanoTime();
            if (now > expireTime) {
                return false;
            }
            condition.awaitNanos(expireTime - now - 50L);
        }
        return true;
    }
}

