/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.spring.xml;

import java.util.List;
import org.fao.geonet.kernel.search.facet.Facets;
import org.fao.geonet.spring.xml.FacetBeanDefinitionParser;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FacetsBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static void parseChildFacets(List<Element> childElements, ParserContext parserContext, BeanDefinitionBuilder facetsBeanDefn, boolean isMerge) {
        ManagedList children = new ManagedList(childElements.size());
        FacetBeanDefinitionParser facetParser = new FacetBeanDefinitionParser();
        for (Element element : childElements) {
            children.add((Object)facetParser.parse(element, parserContext));
        }
        children.setMergeEnabled(isMerge);
        facetsBeanDefn.addConstructorArgValue((Object)children);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        return this.parseFacetsElement(element, parserContext);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return "facets";
    }

    private AbstractBeanDefinition parseFacetsElement(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder facetsBeanDefn = BeanDefinitionBuilder.rootBeanDefinition(Facets.class);
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"facet");
        if (childElements != null && childElements.size() > 0) {
            FacetsBeanDefinitionParser.parseChildFacets(childElements, parserContext, facetsBeanDefn, this.isMerge(element));
        }
        return facetsBeanDefn.getBeanDefinition();
    }

    private boolean isMerge(Element element) {
        String merge = element.getAttribute("merge");
        return merge != null && merge.equalsIgnoreCase("true");
    }
}

