/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.keyword;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.fao.geonet.kernel.AllThesaurus;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.rdf.Query;
import org.fao.geonet.kernel.rdf.QueryBuilder;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;

public class KeywordSearchParams {
    private final QueryBuilder<KeywordBean> queryBuilder;
    private final LinkedHashSet<String> thesauriNames;
    private final String thesauriDomainName;
    private final Comparator<KeywordBean> comparator;
    private int maxResults;

    public KeywordSearchParams(QueryBuilder<KeywordBean> query, Set<String> thesauriNames, String thesauriDomainName, int maxResults, Comparator<KeywordBean> comparator) {
        this.queryBuilder = query;
        this.thesauriNames = new LinkedHashSet<String>(thesauriNames);
        this.thesauriDomainName = thesauriDomainName;
        this.maxResults = maxResults;
        this.comparator = comparator;
    }

    public List<KeywordBean> search(ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        if (this.thesauriNames.isEmpty()) {
            return this.executeAll(this.queryBuilder, finder);
        }
        if (this.thesauriNames.contains("external.none.allThesaurus") && finder.existsThesaurus("external.none.allThesaurus")) {
            final Thesaurus allThesaurus = finder.getThesaurusByName("external.none.allThesaurus");
            List<KeywordBean> resultsOriginalThesaurus = this.executeAll(this.queryBuilder, finder);
            return Lists.transform(resultsOriginalThesaurus, (Function)new Function<KeywordBean, KeywordBean>(){

                @Nullable
                public KeywordBean apply(KeywordBean input) {
                    if (input != null) {
                        input.setUriCode(AllThesaurus.buildKeywordUri(input));
                        input.setThesaurusInfo(allThesaurus);
                    }
                    return input;
                }
            });
        }
        if (this.thesauriNames.size() == 1) {
            if (this.comparator != null) {
                return this.executeOneSorted(this.queryBuilder, finder);
            }
            return this.executeOne(this.queryBuilder, finder);
        }
        return this.executeSpecific(this.queryBuilder, finder);
    }

    private List<KeywordBean> executeOne(QueryBuilder<KeywordBean> queryBuilder, ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        LinkedHashSet<KeywordBean> results = new LinkedHashSet<KeywordBean>();
        AtomicInteger id = new AtomicInteger();
        String thesaurusName = (String)this.thesauriNames.iterator().next();
        Thesaurus thesaurus = finder.getThesaurusByName(thesaurusName);
        Query<KeywordBean> query = queryBuilder.limit(this.maxResults).build();
        if (thesaurus == null) {
            throw new IllegalArgumentException("The thesaurus " + thesaurusName + " does not exist, there for the query cannot be executed: '" + query + "'");
        }
        id = this.executeQuery(id, results, thesaurus, query, this.maxResults);
        return this.setToList(results);
    }

    private List<KeywordBean> executeOneSorted(QueryBuilder<KeywordBean> queryBuilder, ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        TreeSet<KeywordBean> orderedResults = new TreeSet<KeywordBean>(this.comparator);
        AtomicInteger id = new AtomicInteger();
        String thesaurusName = (String)this.thesauriNames.iterator().next();
        Thesaurus thesaurus = finder.getThesaurusByName(thesaurusName);
        Query<KeywordBean> query = queryBuilder.limit(this.maxResults).build();
        if (thesaurus == null) {
            throw new IllegalArgumentException("The thesaurus " + thesaurusName + " does not exist, there for the query cannot be executed: '" + query + "'");
        }
        id = this.executeQuery(id, orderedResults, thesaurus, query, -1);
        return this.setToList(orderedResults);
    }

    private List<KeywordBean> executeSpecific(QueryBuilder<KeywordBean> queryBuilder, final ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        return this.executeAll(queryBuilder, new ThesaurusFinder(){

            @Override
            public boolean existsThesaurus(String name) {
                return KeywordSearchParams.this.thesauriNames.contains(name) && finder.existsThesaurus(name);
            }

            @Override
            public Thesaurus getThesaurusByName(String thesaurusName) {
                if (KeywordSearchParams.this.thesauriNames.contains(thesaurusName)) {
                    return finder.getThesaurusByName(thesaurusName);
                }
                return null;
            }

            @Override
            public Thesaurus getThesaurusByConceptScheme(String conceptSchemeUri) {
                return finder.getThesaurusByName(conceptSchemeUri);
            }

            @Override
            public Map<String, Thesaurus> getThesauriMap() {
                HashMap thesaurusMap = Maps.newHashMap();
                for (String name : KeywordSearchParams.this.thesauriNames) {
                    Thesaurus th = finder.getThesaurusByName(name);
                    if (th == null) continue;
                    thesaurusMap.put(name, th);
                }
                return thesaurusMap;
            }
        });
    }

    private List<KeywordBean> executeAll(QueryBuilder<KeywordBean> queryBuilder, ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        if (this.comparator != null) {
            return this.executeAllSorted(queryBuilder, finder);
        }
        return this.executeAllUnsorted(queryBuilder, finder);
    }

    private List<KeywordBean> executeAllUnsorted(QueryBuilder<KeywordBean> queryBuilder, ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        AtomicInteger id = new AtomicInteger();
        LinkedHashSet<KeywordBean> results = new LinkedHashSet<KeywordBean>();
        for (Thesaurus thesaurus : finder.getThesauriMap().values()) {
            if (thesaurus.getKey().equals("external.none.allThesaurus") || this.thesauriDomainName != null && !this.thesauriDomainName.equals(thesaurus.getDname())) continue;
            Query<KeywordBean> query = queryBuilder.limit(this.maxResults - results.size()).build();
            id = this.executeQuery(id, results, thesaurus, query, this.maxResults);
        }
        return this.setToList(results);
    }

    private AtomicInteger executeQuery(AtomicInteger id, Collection<KeywordBean> results, Thesaurus thesaurus, Query<KeywordBean> query, Integer maxResults) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        for (KeywordBean keywordBean : query.execute(thesaurus)) {
            if (maxResults > -1 && results.size() >= maxResults) break;
            keywordBean.setId(id.getAndIncrement());
            results.add(keywordBean);
        }
        return id;
    }

    private List<KeywordBean> executeAllSorted(QueryBuilder<KeywordBean> queryBuilder, ThesaurusFinder finder) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        AtomicInteger id = new AtomicInteger();
        TreeSet<KeywordBean> results = new TreeSet<KeywordBean>(this.comparator);
        for (Thesaurus thesaurus : finder.getThesauriMap().values()) {
            if (thesaurus.getKey().equals("external.none.allThesaurus")) continue;
            Query<KeywordBean> query = queryBuilder.build();
            if (this.thesauriDomainName != null && !this.thesauriDomainName.equals(thesaurus.getDname())) continue;
            id = this.executeQuery(id, results, thesaurus, query, -1);
        }
        return this.setToList(results);
    }

    private ArrayList<KeywordBean> setToList(Set<KeywordBean> results) {
        ArrayList list = null;
        list = this.maxResults < 0 ? Lists.newArrayListWithCapacity((int)results.size()) : Lists.newArrayListWithCapacity((int)Math.min(this.maxResults, results.size()));
        for (KeywordBean keywordBean : results) {
            if (this.maxResults > -1 && list.size() >= this.maxResults) break;
            list.add(keywordBean);
        }
        return list;
    }
}

