/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import com.google.common.xml.XmlEscapers;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.records.attachments.StoreUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataRelation;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.ExportFormat;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.NoFilterFilter;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRelationRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

class MEF2Exporter {
    MEF2Exporter() {
    }

    public static Path doExport(ServiceContext context, Set<String> uuids, MEFLib.Format format, boolean skipUUID, Path stylePath, boolean resolveXlink, boolean removeXlinkAttribute, boolean skipError, boolean addSchemaLocation) throws Exception {
        return MEF2Exporter.doExport(context, uuids, format, skipUUID, stylePath, resolveXlink, removeXlinkAttribute, skipError, addSchemaLocation, false);
    }

    public static Path doExport(ServiceContext context, Set<String> uuids, MEFLib.Format format, boolean skipUUID, Path stylePath, boolean resolveXlink, boolean removeXlinkAttribute, boolean skipError, boolean addSchemaLocation, boolean approved) throws Exception {
        Path file = Files.createTempFile("mef-", ".mef", new FileAttribute[0]);
        SearchManager searchManager = context.getBean(SearchManager.class);
        String contextLang = context.getLanguage() == null ? "eng" : context.getLanguage();
        try (FileSystem zipFs = ZipUtil.createZipFs((Path)file);
             IndexAndTaxonomy indexReaderAndTaxonomy = searchManager.getNewIndexReader(contextLang);){
            StringBuilder csvBuilder = new StringBuilder("\"schema\";\"uuid\";\"id\";\"type\";\"isHarvested\";\"title\";\"abstract\"\n");
            Element html = new Element("html").addContent((Content)new Element("head").addContent(Arrays.asList(new Element("title").setText("Export Index"), new Element("link").setAttribute("rel", "stylesheet").setAttribute("href", "https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css"), new Element("style").setText("body {\n  padding-left: 10px;\n}\np.abstract {\n  font-style: italic;\n}\n.entry {\n  padding: 20px;\n  margin: 20px 0;\n  border: 1px solid #eee;\n  border-left-width: 5px;\n  border-radius: 3px;\n  border-left-color: #1b809e;\n}\n.entry:hover {\n  background-color: #f5f5f5;\n}\n"))));
            Element body = new Element("body");
            html.addContent((Content)body);
            Iterator<String> iterator = uuids.iterator();
            while (iterator.hasNext()) {
                String uuid1;
                String uuid = uuid1 = iterator.next();
                String cleanUUID = MEF2Exporter.cleanForCsv(uuid);
                try {
                    IndexSearcher searcher = new IndexSearcher((IndexReader)indexReaderAndTaxonomy.indexReader);
                    BooleanQuery query = new BooleanQuery();
                    AbstractMetadata md = context.getBean(IMetadataUtils.class).findOneByUuid(uuid);
                    if (approved) {
                        md = context.getBean(MetadataRepository.class).findOneByUuid(uuid);
                    }
                    String id = String.valueOf(md.getId());
                    query.add(new BooleanClause((Query)new TermQuery(new Term("_id", id)), BooleanClause.Occur.MUST));
                    query.add(new BooleanClause((Query)new TermQuery(new Term("locale", contextLang)), BooleanClause.Occur.SHOULD));
                    TopDocs topDocs = searcher.search((Query)query, NoFilterFilter.instance(), 5);
                    String mdSchema = null;
                    String mdTitle = null;
                    String mdAbstract = null;
                    String isHarvested = null;
                    MetadataType mdType = null;
                    for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                        Document doc = searcher.doc(scoreDoc.doc);
                        String locale = doc.get("locale");
                        if (mdSchema == null) {
                            mdSchema = doc.get("_schema");
                        }
                        if (mdTitle == null || contextLang.equals(locale)) {
                            mdTitle = doc.get("title");
                        }
                        if (mdAbstract == null || contextLang.equals(locale)) {
                            mdAbstract = doc.get("abstract");
                        }
                        if (isHarvested == null) {
                            isHarvested = doc.get("_isHarvested");
                        }
                        if (mdType != null) continue;
                        String tmp = doc.get("_isTemplate");
                        mdType = MetadataType.lookup((char)tmp.charAt(0));
                    }
                    if (mdType == null) {
                        mdType = MetadataType.METADATA;
                    }
                    csvBuilder.append('\"').append(MEF2Exporter.cleanForCsv(mdSchema)).append("\";\"").append(cleanUUID).append("\";\"").append(MEF2Exporter.cleanForCsv(id)).append("\";\"").append(mdType.toString()).append("\";\"").append(MEF2Exporter.cleanForCsv(isHarvested)).append("\";\"").append(MEF2Exporter.cleanForCsv(mdTitle)).append("\";\"").append(MEF2Exporter.cleanForCsv(mdAbstract)).append("\"\n");
                    body.addContent((Content)new Element("div").setAttribute("class", "entry").addContent(Arrays.asList(new Element("h4").setAttribute("class", "title").addContent((Content)new Element("a").setAttribute("href", uuid).setText(MEF2Exporter.cleanXml(mdTitle))), new Element("p").setAttribute("class", "abstract").setText(MEF2Exporter.cleanXml(mdAbstract)), new Element("table").setAttribute("class", "table").addContent(Arrays.asList(new Element("thead").addContent((Content)new Element("tr").addContent(Arrays.asList(new Element("th").setText("ID"), new Element("th").setText("UUID"), new Element("th").setText("Type"), new Element("th").setText("isHarvested")))), new Element("tbody").addContent((Content)new Element("tr").addContent(Arrays.asList(new Element("td").setAttribute("class", "id").setText(id), new Element("td").setAttribute("class", "uuid").setText(XmlEscapers.xmlContentEscaper().escape(uuid)), new Element("td").setAttribute("class", "type").setText(mdType.toString()), new Element("td").setAttribute("class", "isHarvested").setText(isHarvested)))))))));
                    MEF2Exporter.createMetadataFolder(context, md, zipFs, skipUUID, stylePath, format, resolveXlink, removeXlinkAttribute, addSchemaLocation);
                }
                catch (Throwable t) {
                    if (skipError) {
                        Log.error((String)"geonetwork.mef", (Object)("Error exporting metadata to MEF file: " + uuid1), (Throwable)t);
                        continue;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
            Files.write(zipFs.getPath("/index.csv", new String[0]), csvBuilder.toString().getBytes(Constants.CHARSET), new OpenOption[0]);
            Files.write(zipFs.getPath("/index.html", new String[0]), Xml.getString((Element)html).getBytes(Constants.CHARSET), new OpenOption[0]);
        }
        return file;
    }

    private static String cleanXml(String xmlTextContent) {
        if (xmlTextContent != null) {
            return XmlEscapers.xmlContentEscaper().escape(xmlTextContent);
        }
        return "-";
    }

    private static String cleanForCsv(String csvColumnText) {
        if (csvColumnText != null) {
            return csvColumnText.replace("\"", "'");
        }
        return "-";
    }

    private static void createMetadataFolder(ServiceContext context, AbstractMetadata metadata, FileSystem zipFs, boolean skipUUID, Path stylePath, MEFLib.Format format, boolean resolveXlink, boolean removeXlinkAttribute, boolean addSchemaLocation) throws Exception {
        Path metadataRootDir = zipFs.getPath(metadata.getUuid(), new String[0]);
        Files.createDirectories(metadataRootDir, new FileAttribute[0]);
        Pair<AbstractMetadata, String> recordAndMetadataForExport = MEFLib.retrieveMetadata(context, metadata, resolveXlink, removeXlinkAttribute, addSchemaLocation);
        AbstractMetadata record = (AbstractMetadata)recordAndMetadataForExport.one();
        String xmlDocumentAsString = (String)recordAndMetadataForExport.two();
        String id = "" + record.getId();
        String isTemp = record.getDataInfo().getType().codeString;
        if (!"y".equals(isTemp) && !"n".equals(isTemp)) {
            throw new Exception("Cannot export sub template");
        }
        Path metadataXmlDir = metadataRootDir.resolve("metadata/");
        Files.createDirectories(metadataXmlDir, new FileAttribute[0]);
        for (Pair<String, String> output : ExportFormat.getFormats(context, record)) {
            Files.write(metadataXmlDir.resolve((String)output.one()), ((String)output.two()).getBytes(Constants.CHARSET), new OpenOption[0]);
        }
        Files.write(metadataXmlDir.resolve("metadata.xml"), xmlDocumentAsString.getBytes(Constants.CHARSET), new OpenOption[0]);
        String ftUUID = MEF2Exporter.getFeatureCatalogID(context, record.getId());
        if (!ftUUID.equals("")) {
            Pair<AbstractMetadata, String> ftrecordAndMetadata = MEFLib.retrieveMetadata(context, record, resolveXlink, removeXlinkAttribute, addSchemaLocation);
            Path featureMdDir = metadataRootDir.resolve("applschema/");
            Files.createDirectories(featureMdDir, new FileAttribute[0]);
            Files.write(featureMdDir.resolve("metadata.xml"), ((String)ftrecordAndMetadata.two()).getBytes(Constants.CHARSET), new OpenOption[0]);
        }
        Store store = context.getBean("resourceStore", Store.class);
        List<MetadataResource> publicResources = store.getResources(context, metadata.getUuid(), MetadataResourceVisibility.PUBLIC, null, (Boolean)true);
        if (format == MEFLib.Format.PARTIAL || format == MEFLib.Format.FULL) {
            StoreUtils.extract(context, metadata.getUuid(), publicResources, metadataRootDir.resolve("public"), true);
        }
        List<MetadataResource> privateResources = null;
        if (format == MEFLib.Format.FULL) {
            try {
                Lib.resource.checkPrivilege(context, id, ReservedOperation.download);
                privateResources = store.getResources(context, metadata.getUuid(), MetadataResourceVisibility.PRIVATE, null, (Boolean)true);
                StoreUtils.extract(context, metadata.getUuid(), privateResources, metadataRootDir.resolve("private"), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] binData = MEFLib.buildInfoFile(context, record, format, publicResources, privateResources, skipUUID).getBytes(Constants.ENCODING);
        Files.write(metadataRootDir.resolve("info.xml"), binData, new OpenOption[0]);
    }

    private static String getFeatureCatalogID(ServiceContext context, int metadataId) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = gc.getBean(DataManager.class);
        List relations = context.getBean(MetadataRelationRepository.class).findAllById_MetadataId(metadataId);
        if (relations.isEmpty()) {
            return "";
        }
        int ftId = ((MetadataRelation)relations.get(0)).getId().getRelatedId();
        String ftUuid = dm.getMetadataUuid("" + ftId);
        return ftUuid != null ? ftUuid : "";
    }
}

